/* Bkreg 
   Extract Syskey bootkey from the registry on pre sp4 w2k system

   DISCLAIMER:
   Bkreg  is  free  software, so you are free to copy, distribute, use
   the work under the following condition

   You must give the original author credit.
   You may not use this work for commercial purposes.

   I'm in NO WAY responsible for any damage the program does.
   This program is distributed in the hope that it will be useful, but
   WITHOUT  ANY  WARRANTY,  express  or  implied.  There is no implied
   warranty  of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE !
   Using it is at your own risk !

   Any of these conditions can be waived if you get permission from the author.

   Nicola Cuomo - ncuomo@studenti.unina.it
*/
#include "windows.h"
#include <string.h>
#include <stdio.h>

int main( int argc, char **argv )
{
	FILE *f;

	HKEY hk;
	HKEY hkt;
	int i;

	char *kn[] = { "JD", "Skew1", "GBG", "Data" };
	char kv[9];
	unsigned long kvsize;

	unsigned char key[0x10];
	unsigned char pkey[0x10];
				
	// int p[] = { 0x7, 0x3, 0xa, 0x8, 0xf, 0x9, 0x1, 0x2,0x4, 0xd, 0x5, 0x0, 0xe, 0xc, 0x6, 0xb };
	int p[] = { 0xb, 0x6, 0x7, 0x1, 0x8, 0xa, 0xe, 0x0,0x3, 0x5, 0x2, 0xf, 0xd, 0x9, 0xc, 0x4 };

	printf( "Bkreg ncuomo@studenti.unina.it\n\n" );

	if( argc != 2 )
	{
		printf( "Usage:\nbkreg keyfile\n" );
		return -1;
	}

	/* Open Lsa key */
	RegOpenKeyEx( HKEY_LOCAL_MACHINE, "System\\CurrentControlSet\\Control\\Lsa", 0, KEY_READ, &hk );

	
	for( i = 0; i < 4; i++ )
	{
		if( RegOpenKeyEx( hk, kn[i], 0, KEY_READ, &hkt ) )
		{
			printf( "Error opening Lsa key; sp4 installed??\n" );
			return -1;
		}

		kvsize = sizeof( kv );

		/* Get subkey class name */
		RegQueryInfoKey( hkt, kv, &kvsize, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL );
		RegCloseKey( hkt );
 
		sscanf( kv, "%x", (int*) ( &key[i*4] ) );
	}

	/* Print the boot key */
	printf( "Bootkey: " );

	for( i = 0; i < 0x10; i++ )
	{
		/* Permute the class name */
		pkey[i] = key[p[i]];
		printf( "%.2x", pkey[i] );
	}

	printf( "\n" );

	RegCloseKey( hk );

	/* write the syskey bootkey to file */
	if( ( f = fopen( argv[1], "wb" ) ) != NULL )
	{
		fwrite( pkey, 1, 16, f );
        fclose( f );
	}
	else
		printf( "error writing to %s\n", argv[1] );

	return 0;
}
