worker_processes Integer(ENV["WEB_CONCURRENCY"] || 3)
timeout 15
preload_app true

Rainbows! do
  use :ThreadPool
  worker_connections 32
end

before_fork do |server, worker|
  Signal.trap 'TERM' do
	puts 'Unicorn master intercepting TERM and sending myself QUIT instead'
	Process.kill 'QUIT', Process.pid
  end
end

after_fork do |server, worker|
  Signal.trap 'TERM' do
	puts 'Unicorn worker intercepting TERM and doing nothing. Wait for master to sent QUIT'
  end
end
