/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#pragma once
#include "eden.h"

// Note: the following data can be found in the original game's executable
const int kNumRooms = 424;
const room_t gameRooms[kNumRooms] = {
	// Mo        
	{ 1, {255,  0,  0,  0}, 0, 66, 0xFFFF,29, 93,  1,  4},
	{ 7, {  4,  0,  6,  0}, 4, 72, 0xFFFF, 8,143,  2,  2},
	{ 3, { 24,  0,  5,  0}, 6, 99,      1, 6,  6,  3,  0},
	{ 3, { 24,  0,  5,  0}, 6, 68,   0x21, 6,146,  3,  0},
	{30, { 24,  0,  5,  0}, 2, 97,      9, 6,147,  3,  0},
	{ 4, { 24,  0,  5,  0}, 2, 69,   0x29, 6,147,  3,  0},
	{31, { 24,  0,  5,  0}, 2, 98,      8, 6,147,  3,  0},
	{ 2, { 24,  0,  5,  0}, 2, 67,      0, 6,147,  3,  0},
	{ 5, {  5, 20,  2,  8}, 4, 70, 0xFFFF, 7, 64,  4, 72},
	{ 6, {  3,  7,  4,  9}, 4, 71, 0xFFFF, 5,  4,  5,  6},
	{ 8, {  1,  0, 23,  2}, 4, 73,  0x400,23,145,  6,  2},
	{29, {  1,  0,  0,  2}, 4, 96,      0, 0,  0,  6,  2},
	{ 9, {  0,  0,  5,  0}, 0, 74,      0, 0,112,  7,  8},
	{10, {  0,  0,  5,  0}, 0, 75,   0x20, 0,112,  7,  8},
	{28, {  0,  0,  4,  0}, 0, 95,      0, 0,  0,  8, 10},
	{11, {  0,  0,  4,  0}, 0, 76,   0x10, 5,110,  8, 10},
	{27, { 11,  0,  5,  0}, 4, 94,      0,37,152,  9, 12},
	{12, { 11,  0,  5,  0}, 4, 77,      8, 6,  5,  9, 12},
	{27, { 11,  0,  5,  0}, 4, 94, 0xFFFF,37,152,  9, 12},
	{13, { 13,  0, 12,  0}, 6, 78,      0,15, 10, 10, 48},
	{14, { 12,  0,  9,  0}, 4, 79,      0,12,  9, 11, 12},
	{15, { 10,  0, 11,  0}, 6, 80,      0,14, 12, 12, 16},
	{16, { 14,  0, 10,  0}, 6, 81,      0,13, 11, 13, 14},
	{17, { 15,  0, 13,  0}, 4, 82,      0, 0,  0, 14, 16},
	{18, { 16,  0, 14,  0}, 4, 83,      0,17, 13, 15, 16},
	{19, { 17,  0, 13,  0}, 0, 84,      0,18, 15, 16, 16},
	{20, { 18,  0,  9,  0}, 4, 85,      0,19, 16, 17, 16},
	{21, {  0,  1, 17,  0}, 0, 86,      0,20,  0, 18, 70},
	{21, {  0,  1, 17,  0}, 6, 87,      2,20, 14, 18, 70},
	{37, {  0,  0,  9,  0}, 0, 34, 0xFFFF, 0,  0, 19, 12},
	{ 6, {  0,  0,  4,  0}, 4, 53, 0xFFFF, 5,156, 20, 72},
	{22, {130,  0,  4,  0}, 0, 88,      0, 1,  0, 22, 46},
	{22, {130,  0,  4,  0}, 4, 89,      2, 5,  8, 22, 46},
	{23, {  6,  0,  0,  0}, 4, 90, 0xFFFF, 0,  0, 23,  2},
	{24, {103, 25,  3,  0}, 6, 91,      0, 3,  1, 24,  0},
	{25, {  0, 26,  3, 24}, 4, 92,      0,24,  2, 25,  0},
	{26, {  0,  0,  3, 25}, 4, 93,      0,25,  3, 26,  0},
	{32, {  0,  0, 89,  0}, 6,100, 0xFFFF, 0, 75, 32, 18},
	{33, {  0,  0, 50,  0}, 6,105, 0xFFFF, 0, 26, 33, 20},
	{33, {  0,  0, 51,  0}, 6,105, 0xFFFF, 0, 26, 34, 20},
	{33, {  0,  0, 52,  0}, 6,105, 0xFFFF, 0, 26, 35, 20},
	{33, {  0, 68, 53, 85}, 6,107, 0xFFFF, 0, 28, 36, 20},
	{33, { 33,  0, 54, 86}, 6,109, 0xFFFF, 0, 30, 37, 20},
	{33, { 34,  0, 55, 87}, 6,109, 0xFFFF, 0, 30, 38, 20},
	{33, { 35, 71, 56, 88}, 6,106, 0xFFFF, 0, 27, 39, 20},
	{33, { 36,  0, 57, 90}, 6,109, 0xFFFF, 0, 30, 40, 20},
	{33, { 37, 74, 58, 91}, 6,106, 0xFFFF, 0, 27, 41, 20},
	{33, {  0,  0, 59,  0}, 6,105, 0xFFFF, 0, 26, 42, 20},
	{33, {  0,  0, 60,  0}, 6,105, 0xFFFF, 0, 26, 43, 20},
	{33, {  0,  0, 61,  0}, 6,105, 0xFFFF, 0, 26, 44, 20},
	{33, {  0,  0, 62,  0}, 6,105, 0xFFFF, 0, 26, 45, 20},
	{33, { 42,  0, 63, 97}, 6,109, 0xFFFF, 0, 30, 46, 20},
	{33, { 43, 80, 64,  0}, 6,108, 0xFFFF, 0, 29, 47, 20},
	{33, { 44, 81, 65,  0}, 6,108, 0xFFFF, 0, 29, 48, 20},
	{33, { 46, 83, 66,101}, 6,106, 0xFFFF, 0, 27, 49, 20},
	{33, { 54, 86, 33,  0}, 6,108, 0xFFFF, 0, 29, 50, 20},
	{33, { 55, 87, 34,  0}, 6,108, 0xFFFF, 0, 29, 51, 20},
	{33, { 56, 88, 35, 71}, 6,106, 0xFFFF, 0, 27, 52, 20},
	{33, { 57, 90, 36,  0}, 6,108, 0xFFFF, 0, 29, 53, 20},
	{33, { 58, 91, 37, 74}, 6,106, 0xFFFF, 0, 27, 54, 20},
	{33, {  0, 92, 38, 75}, 6,107, 0xFFFF, 0, 28, 55, 20},
	{33, {  0, 93, 39, 76}, 6,107, 0xFFFF, 0, 28, 56, 20},
	{33, {  0, 95, 40, 78}, 6,107, 0xFFFF, 0, 28, 57, 20},
	{33, {  0, 96, 41, 79}, 6,110, 0xFFFF, 0, 59, 58, 20},
	{33, { 63, 97, 42,  0}, 6,108, 0xFFFF, 0, 29, 59, 20},
	{33, { 64,  0, 43, 80}, 6,109, 0xFFFF, 0, 30, 60, 20},
	{33, { 65,  0, 44, 81}, 6,109, 0xFFFF, 0, 30, 61, 20},
	{33, {  0, 99, 45, 82}, 6,107, 0xFFFF, 0, 28, 62, 20},
	{33, { 66,100, 46, 83}, 6,106, 0xFFFF, 0, 27, 63, 20},
	{33, {  0,101, 47, 84}, 6,107, 0xFFFF, 0, 28, 64, 20},
	{33, {  3,  0, 48,  0}, 6,104, 0xFFFF, 0, 74, 65, 20},
	{33, {  3,  0, 49,  0}, 6,104, 0xFFFF, 0, 74, 66, 20},
	{33, { 68, 53, 85,  0}, 6,108, 0xFFFF, 0, 29, 67, 20},
	{33, {  0, 54, 86, 33}, 6,107, 0xFFFF, 0, 28, 68, 20},
	{33, {  0, 55, 87, 34}, 6,107, 0xFFFF, 0, 28, 69, 20},
	{33, { 71, 56, 88, 35}, 6,106, 0xFFFF, 0, 27, 70, 20},
	{33, { 32,  0, 89,  0}, 6,104, 0xFFFF, 0, 74, 71, 20},
	{33, {  0, 57, 90, 36}, 6,107, 0xFFFF, 0, 28, 72, 20},
	{33, { 74, 58, 91, 37}, 6,106, 0xFFFF, 0, 27, 73, 20},
	{33, { 75,  0, 92, 38}, 6,109, 0xFFFF, 0, 30, 74, 20},
	{33, { 76,  0, 93, 39}, 6,109, 0xFFFF, 0, 30, 75, 20},
	{33, {  0,  0, 94,  0}, 6,105, 0xFFFF, 0, 26, 76, 20},
	{33, { 78,  0, 95, 40}, 6,109, 0xFFFF, 0, 30, 77, 20},
	{33, { 79,  0, 96, 41}, 6,112, 0xFFFF, 0, 61, 78, 20},
	{33, {  0, 63, 97, 42}, 6,107, 0xFFFF, 0, 28, 79, 20},
	{33, {  0,  0, 98,  0}, 6,105, 0xFFFF, 0, 26, 80, 20},
	{33, { 82,  0, 99, 45}, 6,109, 0xFFFF, 0, 30, 81, 20},
	{33, { 83, 66,100, 46}, 6,106, 0xFFFF, 0, 27, 82, 20},
	{33, { 84,  0,101, 47}, 6,109, 0xFFFF, 0, 30, 83, 20},
	{33, {  0,  0,102,  0}, 6,105, 0xFFFF, 0, 26, 84, 20},
	{33, {  0,  0, 67,  0}, 6,105, 0xFFFF, 0, 26, 85, 20},
	{33, { 85,  0, 68, 53}, 6,109, 0xFFFF, 0, 30, 86, 20},
	{33, {  0,  0, 69,  0}, 6,105, 0xFFFF, 0, 26, 87, 20},
	{33, {  0,  0, 70,  0}, 6,105, 0xFFFF, 0, 26, 88, 20},
	{33, { 88, 35, 71, 56}, 6,106, 0xFFFF, 0, 27, 89, 20},
	{33, {  0,  0, 72,  0}, 6,105, 0xFFFF, 0, 26, 90, 20},
	{33, {  0,  0, 73,  0}, 6,105, 0xFFFF, 0, 26, 91, 20},
	{33, { 91, 37, 74, 58}, 6,106, 0xFFFF, 0, 27, 92, 20},
	{33, { 92, 38, 75,  0}, 6,108, 0xFFFF, 0, 29, 93, 20},
	{33, { 93, 39, 76,  0}, 6,108, 0xFFFF, 0, 29, 94, 20},
	{33, {  0,  0, 77,  0}, 6,105, 0xFFFF, 0, 26, 95, 20},
	{33, { 95, 40, 78,  0}, 6,108, 0xFFFF, 0, 29, 96, 20},
	{33, { 96, 41, 79,  0}, 6,111, 0xFFFF, 0, 60, 97, 20},
	{33, {  0, 43, 80, 64}, 6,107, 0xFFFF, 0, 28, 98, 20},
	{33, {  0, 44, 81, 65}, 6,107, 0xFFFF, 0, 28, 99, 20},
	{33, { 99, 45, 82,  0}, 6,108, 0xFFFF, 0, 29,100, 20},
	{33, {100, 46, 83, 66}, 6,106, 0xFFFF, 0, 27,101, 20},
	{33, {101, 47, 84,  0}, 6,108, 0xFFFF, 0, 29,102, 20},
	{34, { 49,  0,  3,104}, 0,101, 0xFFFF, 0,  0,103, 20},
	{35, {105,  0,103,  0}, 0,102, 0xFFFF, 0,  0,104, 20},
	{36, { 48,  0,104,  0}, 0,103, 0xFFFF, 0,  0,105, 20},
	END_ROOMS,
	// Tau's
	{ 1, {2, 0,129, 0}, 4, 118, 0xFFFF, 22, 0, 1, 74},
	{ 2, {0, 0,  1, 0}, 6, 119, 0xFFFF, 1, 34, 2, 56},
	END_ROOMS,
	// Narim's
	{ 1, {2, 0,255, 0}, 4, 321, 0xFFFF, 1,  0, 1, 24},
	{ 2, {0, 0,  1, 0}, 6, 324, 0xFFFF, 1, 32, 2, 66},
	END_ROOMS,
	// Embalmers
	{ 1, {2, 0,129, 0}, 6, 243, 0xFFFF, 1,  0, 1, 62},
	{ 2, {0, 0,  1, 0}, 4, 244,  0x200, 1, 49, 2, 58},
	{ 2, {0, 0,  1, 0}, 0, 245,      0, 1,  0, 2, 58},
	END_ROOMS,
	// White Arch
	{ 1, {0, 0,255, 0}, 6, 120, 0xFFFF, 1,  0, 1, 42},
	{ 2, {3, 0,  0, 0}, 0, 231, 0xFFFF, 0,  0, 2, 20},
	{ 3, {0, 0,  2, 0}, 6, 232, 0xFFFF, 0, 50, 3, 20},
	{ 4, {0, 0,  0, 0}, 6, 233, 0xFFFF, 0, 96, 4, 44},
	END_ROOMS,
	// Moorkus Lair
	{ 1, {255, 2, 0, 0}, 4, 121,  0x588, 1,  0, 1, 64},
	{ 1, {255, 2, 0, 0}, 4, 323, 0xFFFF, 1,  0, 1, 64},
	{ 2, { 3,  4, 0, 0}, 0, 122, 0xFFFF, 1, 90, 2, 60},
	{ 3, { 0,  0, 0, 0}, 4, 123, 0xFFFF, 2, 91, 3, 60},
	{ 4, { 0,  0, 2, 0}, 4, 320, 0xFFFF, 2,150, 4, 60},
	END_ROOMS,
	// Chamaar
	{ 1, {255, 0,  0,  0}, 0x18,  17, 0xFFFF, 1, 0,  1, 68},
	{ 2, {255, 0,  0,  0}, 0x18,  17, 0xFFFF, 0, 0,  1, 68},
	{ 3, { 0, 17, 32,  0}, 0x81, 124, 0xFFFF, 0, 0, 16, 22},
	{ 3, { 0, 18, 33, 16}, 0x81, 125, 0xFFFF, 0, 0, 17, 22},
	{ 3, { 0, 19, 34, 17}, 0x81, 126, 0xFFFF, 0, 0, 18, 22},
	{ 3, { 0, 20, 35, 18}, 0x86, 143, 0xFFFF, 0, 0, 19, 22},
	{ 3, { 0, 21, 36, 19}, 0x81, 127, 0xFFFF, 0, 0, 20, 22},
	{ 3, { 0, 22, 37, 20}, 0x81, 128, 0xFFFF, 0, 0, 21, 22},
	{ 3, { 0, 23, 38, 21}, 0x81, 129, 0xFFFF, 0, 0, 22, 22},
	{ 3, { 0, 24, 39, 22}, 0x81, 130, 0xFFFF, 0, 0, 23, 22},
	{ 3, { 0, 25, 40, 23}, 0x81, 131, 0xFFFF, 0, 0, 24, 22},
	{ 3, { 0, 26, 41, 24}, 0x81, 132, 0xFFFF, 0, 0, 25, 22},
	{ 3, { 0, 27, 42, 25}, 0x81, 133, 0xFFFF, 0, 0, 26, 22},
	{ 3, { 0,  0, 43, 26}, 0x81, 134, 0xFFFF, 0, 0, 27, 22},
	{ 3, {16, 33, 48,  0}, 0xC1, 193, 0xFFFF, 0, 0, 32, 26},
	{ 3, {17, 34, 49, 32}, 0x81, 135, 0xFFFF, 0, 0, 33, 22},
	{ 3, {18, 35, 50, 33}, 0x81, 136, 0xFFFF, 0, 0, 34, 22},
	{ 3, {19, 36, 51, 34}, 0x81, 137, 0xFFFF, 0, 0, 35, 22},
	{ 3, {20, 37, 52, 35}, 0x81, 138, 0xFFFF, 0, 0, 36, 22},
	{ 3, {21, 38, 53, 36}, 0x81, 139, 0xFFFF, 0, 0, 37, 22},
	{ 3, {22, 39, 54, 37}, 0x81, 140, 0xFFFF, 0, 0, 38, 22},
	{ 3, {23, 40, 55, 38}, 0x81, 141, 0xFFFF, 0, 0, 39, 22},
	{ 3, {24, 41, 56, 39}, 0x81, 142, 0xFFFF, 0, 0, 40, 22},
	{ 3, {25, 42, 57, 40}, 0x81, 143, 0xFFFF, 0, 0, 41, 22},
	{ 3, {26, 43, 58, 41}, 0x81, 144, 0xFFFF, 0, 0, 42, 22},
	{ 3, {27,  0, 59, 42}, 0x81, 145, 0xFFFF, 0, 0, 43, 22},
	{ 3, {32, 49, 64,  0}, 0xC0, 235,      0, 0, 0, 48, 26},
	{ 4, {32, 49, 64,  0}, 0xC6, 234,  0x200, 0,31, 48, 26},
	{ 9, {33, 50, 65, 48}, 0xC0, 277, 0xFFFF, 0, 0, 49, 26},
	{10, { 0,  0, 49,  0}, 0xC4, 278, 0xFFFF, 0,52, 49, 26},
	{ 3, {34, 51, 66, 49}, 0xC1, 197, 0xFFFF, 0, 0, 50, 26},
	{ 3, {35, 52, 67, 50}, 0xC1, 202, 0xFFFF, 0, 0, 51, 26},
	{ 3, {36, 53, 68, 51}, 0x81, 146, 0xFFFF, 0, 0, 52, 22},
	{ 3, {37, 54, 69, 52},    1, 173, 0xFFFF, 0, 0, 53, 28},
	{ 3, {38, 55, 70, 53},    1, 174, 0xFFFF, 0, 0, 54, 28},
	{ 3, {39, 56, 71, 54},    1, 175, 0xFFFF, 0, 0, 55, 28},
	{ 3, {40, 57, 72, 55},    1, 176, 0xFFFF, 0, 0, 56, 28},
	{ 3, {41, 58, 73, 56},    1, 177, 0xFFFF, 0, 0, 57, 28},
	{ 3, {42, 59, 74, 57},    1, 178, 0xFFFF, 0, 0, 58, 28},
	{ 3, {43,  0, 75, 58},    1, 181, 0xFFFF, 0, 0, 59, 28},
	{ 5, {48, 65,  1,  0}, 0xC0, 276, 0xFFFF, 0, 0, 64, 26},
	{ 3, {49, 66,  1, 64}, 0xC1, 194, 0xFFFF, 0, 0, 65, 26},
	{ 3, {50, 67,  1, 65}, 0xC1, 200, 0xFFFF, 0, 0, 66, 26},
	{ 3, {51, 68,  1, 66}, 0xC1, 195, 0xFFFF, 0, 0, 67, 26},
	{ 9, {52, 69,  1, 67}, 0xC0, 279, 0xFFFF, 0, 0, 68, 26},
	{10, { 0,  0, 68,  0}, 0xC4, 280, 0xFFFF, 0,78, 68, 26},
	{ 3, {53, 70,  1, 68},    1, 163, 0xFFFF, 0, 0, 69, 28},
	{ 3, {54, 71,  1, 69},    1, 170, 0xFFFF, 0, 0, 70, 28},
	{ 3, {55, 72,  1, 70},    1, 171, 0xFFFF, 0, 0, 71, 28},
	{ 3, {56, 73,  1, 71},    1, 167, 0xFFFF, 0, 0, 72, 28},
	{11, {57, 74,  1, 72}, 0x40, 223, 0xFFFF, 0, 0, 73, 32},
	{12, {58, 75,  1, 73}, 0x40, 215, 0xFFFF, 0, 0, 74, 32},
	{ 3, {59,  0,  1, 74},    1, 166, 0xFFFF, 0, 0, 75, 28},
	END_ROOMS,
	// Uluru
	{ 1, {255,  0,  0,  0}, 0x18,  41, 0xFFFF, 1, 0,  1, 36},
	{ 2, {255,  0,  0,  0}, 0x18,  41, 0xFFFF, 0, 0,  1, 36},
	{ 3, {  0, 17, 32,  0}, 0x81, 149, 0xFFFF, 0, 0, 16, 24},
	{ 3, {  0, 18, 33, 16}, 0x81, 150, 0xFFFF, 0, 0, 17, 24},
	{ 3, {  0, 19, 34, 17}, 0x81, 151, 0xFFFF, 0, 0, 18, 24},
	{ 3, {  0, 20, 35, 18}, 0x81, 152, 0xFFFF, 0, 0, 19, 24},
	{ 3, {  0, 21, 36, 19}, 0x81, 153, 0xFFFF, 0, 0, 20, 24},
	{ 3, {  0, 22, 37, 20}, 0x81, 149, 0xFFFF, 0, 0, 21, 24},
	{ 3, {  0, 23, 38, 21}, 0x81, 154, 0xFFFF, 0, 0, 22, 24},
	{ 3, {  0, 24, 39, 22}, 0x81, 155, 0xFFFF, 0, 0, 23, 24},
	{ 3, {  0, 25, 40, 23}, 0x81, 156, 0xFFFF, 0, 0, 24, 24},
	{ 3, {  0, 26, 41, 24}, 0x81, 157, 0xFFFF, 0, 0, 25, 24},
	{ 3, {  0, 27, 42, 25}, 0x81, 158, 0xFFFF, 0, 0, 26, 24},
	{ 4, {  0,  0, 43, 26}, 0x86, 238,  0xA00, 0,47, 27, 52},
	{ 4, {  0,  0, 43, 26}, 0x80, 239,  0x800, 0, 0, 27, 52},
	{ 9, { 16, 33, 48,  0}, 0xC0, 277, 0xFFFF, 0, 0, 32, 26},
	{10, {  0,  0, 32,  0}, 0xC4, 278, 0xFFFF, 0,52, 32, 26},
	{ 3, { 17, 34, 49, 32},    1, 191, 0xFFFF, 0, 0, 33, 30},
	{ 3, { 18, 35, 50, 33},    1, 184, 0xFFFF, 0, 0, 34, 30},
	{ 3, { 19, 36, 51, 34},    1, 185, 0xFFFF, 0, 0, 35, 30},
	{ 3, { 20, 37, 52, 35},    1, 186, 0xFFFF, 0, 0, 36, 30},
	{ 3, { 21, 38, 53, 36}, 0x81, 161, 0xFFFF, 0, 0, 37, 24},
	{ 3, { 22, 39, 54, 37},    1, 189, 0xFFFF, 0, 0, 38, 30},
	{ 3, { 23, 40, 55, 38},    1, 186, 0xFFFF, 0, 0, 39, 30},
	{ 3, { 24, 41, 56, 39},    1, 185, 0xFFFF, 0, 0, 40, 30},
	{13, { 25, 42, 57, 40},    1, 192, 0xFFFF, 0, 0, 41, 30},
	{ 3, { 26, 43, 58, 41}, 0x81, 159, 0xFFFF, 0, 0, 42, 24},
	{ 3, { 27,  0, 59, 42}, 0x81, 160, 0xFFFF, 0, 0, 43, 24},
	{12, { 32, 49,  0,  0}, 0x40, 205, 0xFFFF, 0, 0, 48, 34},
	{11, { 33, 50,  0, 48}, 0x40, 210, 0xFFFF, 0, 0, 49, 34},
	{11, { 34, 51,  0, 49}, 0x40, 212, 0xFFFF, 0, 0, 50, 34},
	{11, { 35, 52,  0, 50}, 0x40, 211, 0xFFFF, 0, 0, 51, 34},
	{11, { 36, 53, 68, 51}, 0x40, 207, 0xFFFF, 0, 0, 52, 34},
	{ 3, { 37, 54, 69, 52}, 0xC1, 195, 0xFFFF, 0, 0, 53, 26},
	{ 3, { 38, 55, 70, 53},    1, 190, 0xFFFF, 0, 0, 54, 30},
	{ 3, { 39, 56, 71, 54},    1, 182, 0xFFFF, 0, 0, 55, 30},
	{ 3, { 40, 57, 72, 55},    1, 187, 0xFFFF, 0, 0, 56, 30},
	{ 3, { 41, 58, 73, 56},    1, 188, 0xFFFF, 0, 0, 57, 30},
	{ 3, { 42, 59, 74, 57},    1, 190, 0xFFFF, 0, 0, 58, 30},
	{ 3, { 43,  0, 75, 58}, 0xC1, 197, 0xFFFF, 0, 0, 59, 26},
	{11, { 52, 69,  1,  0}, 0x40, 208, 0xFFFF, 0, 0, 68, 34},
	{ 3, { 53, 70,  1, 68},    1, 182, 0xFFFF, 0, 0, 69, 30},
	{ 3, { 54, 71,  1, 69},    1, 187, 0xFFFF, 0, 0, 70, 30},
	{ 3, { 55, 72,  1, 70},    1, 188, 0xFFFF, 0, 0, 71, 30},
	{ 3, { 56, 73,  1, 71},    1, 190, 0xFFFF, 0, 0, 72, 30},
	{ 3, { 57, 74,  1, 72},    1, 187, 0xFFFF, 0, 0, 73, 30},
	{ 3, { 58, 75,  1, 73},    1, 182, 0xFFFF, 0, 0, 74, 30},
	{ 6, { 59,  0,  1, 74}, 0xC0, 276, 0xFFFF, 0, 0, 75, 26},
	END_ROOMS,
	// Koto
	{ 1, {255,  0,  0,  0}, 0x18,  42, 0xFFFF, 1, 0,  1, 40},
	{ 2, {255,  0,  0,  0}, 0x18,  42, 0xFFFF, 0, 0,  1, 40},
	{13, {  0, 17, 32,  0}, 0x86, 283, 0xFFFF, 0,57, 16, 50},
	{ 3, {  0, 18, 33, 16}, 0x81, 125, 0xFFFF, 0, 0, 17, 22},
	{ 3, {  0, 19, 34, 17}, 0x81, 126, 0xFFFF, 0, 0, 18, 22},
	{ 3, {  0, 20, 35, 18}, 0x81, 127, 0xFFFF, 0, 0, 19, 22},
	{ 3, {  0, 21, 36, 19}, 0x81, 128, 0xFFFF, 0, 0, 20, 22},
	{ 3, {  0, 22, 37, 20}, 0x81, 131, 0xFFFF, 0, 0, 21, 22},
	{ 3, {  0, 23, 38, 21}, 0x81, 129, 0xFFFF, 0, 0, 22, 22},
	{ 3, {  0, 24, 39, 22}, 0x81, 126, 0xFFFF, 0, 0, 23, 22},
	{ 3, {  0, 25, 40, 23}, 0x81, 125, 0xFFFF, 0, 0, 24, 22},
	{ 3, {  0, 26, 41, 24}, 0x81, 127, 0xFFFF, 0, 0, 25, 22},
	{ 3, {  0, 27, 42, 25}, 0x81, 133, 0xFFFF, 0, 0, 26, 22},
	{ 3, {  0,  0, 43, 26}, 0x81, 132, 0xFFFF, 0, 0, 27, 22},
	{ 3, { 16, 33, 48,  0}, 0x81, 133, 0xFFFF, 0, 0, 32, 22},
	{ 3, { 17, 34, 49, 32}, 0x81, 124, 0xFFFF, 0, 0, 33, 22},
	{ 3, { 18, 35, 50, 33}, 0x81, 132, 0xFFFF, 0, 0, 34, 22},
	{ 3, { 19, 36, 51, 34}, 0x81, 131, 0xFFFF, 0, 0, 35, 22},
	{ 3, { 20, 37, 52, 35}, 0x81, 126, 0xFFFF, 0, 0, 36, 22},
	{ 3, { 21, 38, 53, 36}, 0x81, 125, 0xFFFF, 0, 0, 37, 22},
	{ 3, { 22, 39, 54, 37}, 0x81, 126, 0xFFFF, 0, 0, 38, 22},
	{ 3, { 23, 40, 55, 38}, 0x81, 128, 0xFFFF, 0, 0, 39, 22},
	{ 3, { 24, 41, 56, 39}, 0x81, 127, 0xFFFF, 0, 0, 40, 22},
	{ 3, { 25, 42, 57, 40}, 0x81, 133, 0xFFFF, 0, 0, 41, 22},
	{ 3, { 26, 43, 58, 41}, 0x81, 124, 0xFFFF, 0, 0, 42, 22},
	{ 3, { 27,  0, 59, 42}, 0x81, 129, 0xFFFF, 0, 0, 43, 22},
	{11, { 32, 49,  0,  0}, 0x40, 221, 0xFFFF, 0, 0, 48, 32},
	{12, { 33, 50,  0, 48}, 0x40, 215, 0xFFFF, 0, 0, 49, 32},
	{11, { 34, 51, 66, 49}, 0x40, 217, 0xFFFF, 0, 0, 50, 32},
	{11, { 35, 52, 67, 50}, 0x40, 223, 0xFFFF, 0, 0, 51, 32},
	{ 3, { 36, 53, 68, 51},    1, 179, 0xFFFF, 0, 0, 52, 28},
	{ 3, { 37, 54, 69, 52},    1, 180, 0xFFFF, 0, 0, 53, 28},
	{ 3, { 38, 55, 70, 53},    1, 178, 0xFFFF, 0, 0, 54, 28},
	{ 3, { 39, 56, 71, 54},    1, 177, 0xFFFF, 0, 0, 55, 28},
	{ 3, { 40, 57, 72, 55}, 0xC1, 196, 0xFFFF, 0, 0, 56, 26},
	{ 3, { 41, 58, 73, 56}, 0xC1, 197, 0xFFFF, 0, 0, 57, 26},
	{ 9, { 42, 59, 74, 57}, 0xC0, 279, 0xFFFF, 0, 0, 58, 26},
	{10, {  0,  0, 58,  0}, 0xC4, 280, 0xFFFF, 0,78, 58, 26},
	{ 3, { 43,  0, 75, 58}, 0xC0, 237,      0, 0, 0, 59, 26},
	{ 4, { 43,  0, 75, 58}, 0xC6, 236,  0x200, 0,46, 59, 26},
	{11, { 50, 67,  1,  0}, 0x40, 218, 0xFFFF, 0, 0, 66, 32},
	{11, { 51, 68,  1, 66}, 0x40, 217, 0xFFFF, 0, 0, 67, 32},
	{ 3, { 52, 69,  1, 67},    1, 168, 0xFFFF, 0, 0, 68, 28},
	{ 3, { 53, 70,  1, 68},    1, 172, 0xFFFF, 0, 0, 69, 28},
	{ 3, { 54, 71,  1, 69},    1, 170, 0xFFFF, 0, 0, 70, 28},
	{ 3, { 55, 72,  1, 70}, 0xC1, 201, 0xFFFF, 0, 0, 71, 26},
	{ 7, { 56, 73,  1, 71}, 0xC0, 276, 0xFFFF, 0, 0, 72, 26},
	{ 3, { 57, 74,  1, 72}, 0xC1, 194, 0xFFFF, 0, 0, 73, 26},
	{ 3, { 58, 75,  1, 73}, 0xC1, 195, 0xFFFF, 0, 0, 74, 26},
	{ 9, { 59,  0,  1, 74}, 0xC0, 277, 0xFFFF, 0, 0, 75, 26},
	{10, {  0,  0, 75,  0}, 0xC4, 278, 0xFFFF, 0,52, 75, 26},
	END_ROOMS,
	// Tamara
	{ 1, {255,  0,  0,  0}, 0x1A,  43, 0xFFFF, 1, 0,  1, 36},
	{ 2, {255,  0,  0,  0}, 0x1A,  43, 0xFFFF, 0, 0,  1, 36},
	{ 3, {  0, 17, 32,  0}, 0x81, 147, 0xFFFF, 0, 0, 16, 24},
	{ 3, {  0, 18, 33, 16}, 0x81, 148, 0xFFFF, 0, 0, 17, 24},
	{ 3, {  0, 19, 34, 17}, 0x81, 149, 0xFFFF, 0, 0, 18, 24},
	{ 3, {  0, 20, 35, 18}, 0x81, 150, 0xFFFF, 0, 0, 19, 24},
	{ 3, {  0, 21, 36, 19}, 0x81, 151, 0xFFFF, 0, 0, 20, 24},
	{ 3, {  0, 22, 37, 20}, 0x81, 152, 0xFFFF, 0, 0, 21, 24},
	{ 3, {  0, 23, 38, 21}, 0x81, 153, 0xFFFF, 0, 0, 22, 24},
	{ 3, {  0, 24, 39, 22}, 0x81, 154, 0xFFFF, 0, 0, 23, 24},
	{ 3, {  0,  0, 40, 23}, 0x81, 155, 0xFFFF, 0, 0, 24, 24},
	{ 3, { 16, 33, 48,  0}, 0x81, 154, 0xFFFF, 0, 0, 32, 24},
	{ 3, { 17, 34, 49, 32}, 0x81, 156, 0xFFFF, 0, 0, 33, 24},
	{ 3, { 18, 35, 50, 33}, 0x81, 157, 0xFFFF, 0, 0, 34, 24},
	{ 3, { 19, 36, 51, 34}, 0x81, 158, 0xFFFF, 0, 0, 35, 24},
	{ 3, { 20, 37, 52, 35}, 0x81, 159, 0xFFFF, 0, 0, 36, 24},
	{ 3, { 21, 38, 53, 36}, 0x81, 160, 0xFFFF, 0, 0, 37, 24},
	{ 3, { 22, 39, 54, 37}, 0x81, 161, 0xFFFF, 0, 0, 38, 24},
	{ 3, { 23, 40, 55, 38}, 0x81, 162, 0xFFFF, 0, 0, 39, 24},
	{ 4, { 24, 41, 56, 39}, 0xC0, 248,  0x280, 0, 0, 40, 26},
	{ 4, { 24, 41, 56, 39}, 0xC0, 247,  0x200, 0, 0, 40, 26},
	{ 4, { 24, 41, 56, 39}, 0xC0, 246, 0xFFFF, 0, 0, 40, 26},
	{11, {  0,  0, 57, 40}, 0x40, 207, 0xFFFF, 0, 0, 41, 34},
	{ 3, { 32, 49, 64,  0}, 0xC1, 193, 0xFFFF, 0, 0, 48, 26},
	{ 3, { 33, 50, 65, 48}, 0xC1, 200, 0xFFFF, 0, 0, 49, 26},
	{ 3, { 34, 51, 66, 49},    1, 184, 0xFFFF, 0, 0, 50, 30},
	{ 3, { 35, 52, 67, 50},    1, 185, 0xFFFF, 0, 0, 51, 30},
	{ 3, { 36, 53, 68, 51}, 0x81, 189, 0xFFFF, 0, 0, 52, 30},
	{ 3, { 37, 54, 69, 52},    1, 192, 0xFFFF, 0, 0, 53, 30},
	{ 3, { 38, 55, 70, 53},    1, 191, 0xFFFF, 0, 0, 54, 30},
	{ 9, { 39, 56, 71, 54}, 0xC0, 277, 0xFFFF, 0, 0, 55, 26},
	{10, {  0,  0, 55,  0}, 0xC4, 278, 0xFFFF, 0,52, 55, 26},
	{ 3, { 40, 57, 72, 55}, 0xC1, 195, 0xFFFF, 0, 0, 56, 26},
	{11, { 41, 58,  0, 56}, 0x40, 208, 0xFFFF, 0, 0, 57, 34},
	{11, {  0,  0,  0, 57}, 0x40, 212, 0xFFFF, 0, 0, 58, 34},
	{ 8, { 48, 65,  1,  0}, 0xC1, 276, 0xFFFF, 0, 0, 64, 26},
	{ 3, { 49, 66,  1, 64},    1, 187, 0xFFFF, 0, 0, 65, 30},
	{ 3, { 50, 67,  1, 65},    1, 188, 0xFFFF, 0, 0, 66, 30},
	{ 3, { 51, 68,  1, 66},    1, 190, 0xFFFF, 0, 0, 67, 30},
	{12, { 52, 69,  1, 67}, 0x40, 205, 0xFFFF, 0, 0, 68, 34},
	{11, { 53, 70,  1, 68}, 0x40, 203, 0xFFFF, 0, 0, 69, 34},
	{11, { 54, 71,  1, 69}, 0x40, 211, 0xFFFF, 0, 0, 70, 34},
	{14, { 55, 72,  1, 70}, 0x40, 213,      2, 0, 0, 71, 34},
	{11, { 55, 72,  1, 70}, 0x40, 210, 0xFFFF, 0, 0, 71, 34},
	{11, { 56,  0,  1, 71}, 0x40, 207, 0xFFFF, 0, 0, 72, 34},
	END_ROOMS,
	// Cantura
	{ 1, {255,  0,  0,  0}, 0x18,  44, 0xFFFF, 1, 0,  1, 38},
	{ 2, {255,  0,  0,  0}, 0x18,  44, 0xFFFF, 0, 0,  1, 38},
	{ 4, {  0,  0, 18,  0}, 0x86, 240,  0xA00, 0,48, 17, 54},
	{13, {  0,  0, 18,  0}, 0x80, 241,  0xA80, 0, 0, 17, 54},
	{14, {  0,  0, 18,  0}, 0x80, 242,  0xA02, 0, 0, 17, 54},
	{14, {  0,  0, 18,  0}, 0x80, 242, 0xFFFF, 0, 0, 17, 54},
	{15, { 17, 19,  0,  0}, 0x40, 224, 0xFFFF, 0, 0, 18, 32},
	{ 3, {  0, 20,  0, 18}, 0x40, 225, 0xFFFF, 0, 0, 19, 32},
	{ 3, {  0, 21,  0, 19}, 0x40, 226, 0xFFFF, 0, 0, 20, 32},
	{ 3, {  0, 22,  0, 20}, 0x40, 227, 0xFFFF, 0, 0, 21, 32},
	{ 9, {  0, 23, 38, 21}, 0xC0, 277, 0xFFFF, 0, 0, 22, 26},
	{10, {  0,  0, 22,  0}, 0xC4, 278, 0xFFFF, 0,52, 22, 26},
	{ 5, {  0, 24, 39, 22}, 0xC0, 276, 0xFFFF, 0, 0, 23, 26},
	{ 3, {  0, 25, 40, 23}, 0x81, 125, 0xFFFF, 0, 0, 24, 22},
	{ 3, {  0, 26, 41, 24}, 0x81, 131, 0xFFFF, 0, 0, 25, 22},
	{ 3, {  0, 27, 42, 25}, 0x81, 133, 0xFFFF, 0, 0, 26, 22},
	{ 3, {  0,  0, 43, 26}, 0x81, 132, 0xFFFF, 0, 0, 27, 22},
	{11, { 22, 39, 54,  0}, 0x40, 223, 0xFFFF, 0, 0, 38, 32},
	{ 3, { 23, 40, 55, 38},    1, 167, 0xFFFF, 0, 0, 39, 28},
	{ 3, { 24, 41, 56, 39}, 0x81, 126, 0xFFFF, 0, 0, 40, 22},
	{ 3, { 25, 42, 57, 40},    1, 172, 0xFFFF, 0, 0, 41, 28},
	{ 3, { 26, 43, 58, 41},    1, 163, 0xFFFF, 0, 0, 42, 28},
	{ 3, { 27,  0, 59, 42},    1, 168, 0xFFFF, 0, 0, 43, 28},
	{ 3, { 38, 55, 70,  0},    1, 164, 0xFFFF, 0, 0, 54, 28},
	{ 3, { 39, 56, 71, 54},    1, 165, 0xFFFF, 0, 0, 55, 28},
	{ 3, { 40, 57, 72, 55},    1, 163, 0xFFFF, 0, 0, 56, 28},
	{ 3, { 41, 58, 73, 56},    1, 167, 0xFFFF, 0, 0, 57, 28},
	{ 3, { 42, 59, 74, 57},    1, 166, 0xFFFF, 0, 0, 58, 28},
	{ 3, { 43,  0, 75, 58},    1, 171, 0xFFFF, 0, 0, 59, 28},
	{12, {  0, 70,  1,  0}, 0x40, 215, 0xFFFF, 0, 0, 69, 32},
	{ 3, { 54, 71,  1, 69},    1, 173, 0xFFFF, 0, 0, 70, 28},
	{ 3, { 55, 72,  1, 70},    1, 168, 0xFFFF, 0, 0, 71, 28},
	{ 3, { 56, 73,  1, 71},    1, 169, 0xFFFF, 0, 0, 72, 28},
	{ 3, { 57, 74,  1, 72},    1, 170, 0xFFFF, 0, 0, 73, 28},
	{ 3, { 58, 75,  1, 73},    1, 172, 0xFFFF, 0, 0, 74, 28},
	{ 3, { 59,  0,  1, 74},    1, 175, 0xFFFF, 0, 0, 75, 28},
	END_ROOMS,
	// Shandovra
	{ 1, {255, 0,  0,  0}, 0x18,  45, 0xFFFF, 1, 0,  1, 40},
	{ 2, {255, 0,  0,  0}, 0x18,  45, 0xFFFF, 0, 0,  1, 40},
	{ 3, { 0, 17, 32,  0}, 0xC1, 193, 0xFFFF, 0, 0, 16, 26},
	{ 3, { 0, 18, 33, 16}, 0x81, 125, 0xFFFF, 0, 0, 17, 22},
	{ 3, { 0, 19, 34, 17}, 0x81, 126, 0xFFFF, 0, 0, 18, 22},
	{ 3, { 0, 20, 35, 18}, 0x81, 127, 0xFFFF, 0, 0, 19, 22},
	{ 3, { 0, 21, 36, 19}, 0x81, 128, 0xFFFF, 0, 0, 20, 22},
	{ 3, { 0, 22, 37, 20}, 0x81, 131, 0xFFFF, 0, 0, 21, 22},
	{ 3, { 0, 23, 38, 21}, 0x81, 129, 0xFFFF, 0, 0, 22, 22},
	{ 3, { 0, 24, 39, 22}, 0x81, 130, 0xFFFF, 0, 0, 23, 22},
	{ 3, { 0, 25, 40, 23}, 0x81, 125, 0xFFFF, 0, 0, 24, 22},
	{ 3, { 0, 26, 41, 24}, 0x81, 124, 0xFFFF, 0, 0, 25, 22},
	{ 4, { 0, 27, 42, 25}, 0x80, 250,  0x100, 0, 0, 26, 22},
	{ 4, { 0, 27, 42, 25}, 0x80, 250,  0x300, 0, 0, 26, 22},
	{ 4, { 0, 27, 42, 25}, 0x80, 251,  0x200, 0, 0, 26, 22},
	{ 4, { 0, 27, 42, 25}, 0x80, 249, 0xFFFF, 0, 0, 26, 22},
	{ 3, { 0,  0, 43, 26}, 0x81, 132, 0xFFFF, 0, 0, 27, 22},
	{ 3, {16, 33, 48,  0}, 0xC1, 193, 0xFFFF, 0, 0, 32, 26},
	{ 3, {17, 34, 49, 32}, 0xC1, 193, 0xFFFF, 0, 0, 33, 26},
	{ 3, {18, 35, 50, 33}, 0xC1, 201, 0xFFFF, 0, 0, 34, 26},
	{ 3, {19, 36, 51, 34},    1, 170, 0xFFFF, 0, 0, 35, 28},
	{ 3, {20, 37, 52, 35},    1, 165, 0xFFFF, 0, 0, 36, 28},
	{ 3, {21, 38, 53, 36},    1, 164, 0xFFFF, 0, 0, 37, 28},
	{ 3, {22, 39, 54, 37}, 0x81, 126, 0xFFFF, 0, 0, 38, 22},
	{ 3, {23, 40, 55, 38},    1, 167, 0xFFFF, 0, 0, 39, 28},
	{ 3, {24, 41, 56, 39}, 0x81, 126, 0xFFFF, 0, 0, 40, 22},
	{ 3, {25, 42,  0, 40}, 0x81, 132, 0xFFFF, 0, 0, 41, 22},
	{ 3, {26, 43, 58, 41}, 0x81, 124, 0xFFFF, 0, 0, 42, 22},
	{ 3, {27,  0, 59, 42}, 0x81, 129, 0xFFFF, 0, 0, 43, 22},
	{ 6, {32, 49, 64,  0}, 0xC0, 276, 0xFFFF, 0, 0, 48, 26},
	{ 9, {33, 50, 65, 48}, 0xC0, 279, 0xFFFF, 0, 0, 49, 26},
	{10, { 0,  0, 49,  0}, 0xC4, 280, 0xFFFF, 0, 78, 49, 26},
	{ 3, {34, 51, 66, 49}, 0xC1, 197, 0xFFFF, 0, 0, 50, 26},
	{ 3, {35, 52, 67, 50}, 0xC1, 202, 0xFFFF, 0, 0, 51, 26},
	{ 3, {36, 53, 68, 51},    1, 177, 0xFFFF, 0, 0, 52, 28},
	{ 3, {37, 54, 69, 52}, 0x81, 124, 0xFFFF, 0, 0, 53, 22},
	{ 3, {38, 55, 70, 53}, 0x81, 125, 0xFFFF, 0, 0, 54, 22},
	{ 3, {39, 56, 71, 54},    1, 180, 0xFFFF, 0, 0, 55, 28},
	{12, {40,  0, 72, 55}, 0x40, 215, 0xFFFF, 0, 0, 56, 32},
	{11, {42, 59,  0,  0}, 0x40, 218, 0xFFFF, 0, 0, 58, 32},
	{11, {43,  0, 75, 58}, 0x40, 216, 0xFFFF, 0, 0, 59, 32},
	{ 9, {48, 65,  1,  0}, 0xC0, 277, 0xFFFF, 0, 0, 64, 26},
	{10, { 0,  0, 64,  0}, 0xC4, 278, 0xFFFF, 0, 52, 64, 26},
	{ 3, {49, 66,  1, 64}, 0xC1, 197, 0xFFFF, 0, 0, 65, 26},
	{ 3, {50, 67,  1, 65}, 0xC1, 200, 0xFFFF, 0, 0, 66, 26},
	{ 3, {51, 68,  1, 66}, 0x81, 125, 0xFFFF, 0, 0, 67, 22},
	{ 3, {52, 69,  1, 67}, 0x81, 129, 0xFFFF, 0, 0, 68, 22},
	{ 3, {53, 70,  1, 68}, 0x81, 133, 0xFFFF, 0, 0, 69, 22},
	{ 3, {54, 71,  1, 69},    1, 179, 0xFFFF, 0, 0, 70, 28},
	{ 3, {55, 72,  1, 70},    1, 181, 0xFFFF, 0, 0, 71, 28},
	{11, {56,  0,  1, 71}, 0x40, 214, 0xFFFF, 0, 0, 72, 32},
	{11, {59,  0,  1,  0}, 0x40, 223, 0xFFFF, 0, 0, 75, 32},
	END_ROOMS
};
