# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6
inherit autotools flag-o-matic qmake-utils xdg-utils

REAL_PN="${PN/-qt5}"
REAL_P="${P/-qt5}"
DESCRIPTION="Qt5 libraries for LightDM"
HOMEPAGE="https://github.com/CanonicalLtd/lightdm"
SRC_URI="https://github.com/CanonicalLtd/lightdm/releases/download/${PV}/${REAL_P}.tar.xz
	mirror://gentoo/introspection-20110205.m4.tar.bz2"

LICENSE="GPL-3 LGPL-3"
SLOT="0"
KEYWORDS="~amd64 ~arm ~x86"
IUSE=""

COMMON_DEPEND="~x11-misc/lightdm-base-${PV}
	dev-qt/qtcore:5
	dev-qt/qtdbus:5
	dev-qt/qtgui:5
"
RDEPEND="${COMMON_DEPEND}"
DEPEND="${COMMON_DEPEND}"

DOCS=( NEWS )
S="${WORKDIR}/${REAL_P}"

src_prepare() {
	xdg_environment_reset

	# use correct version of qmake. bug #566950
	sed \
		-e "/AC_CHECK_TOOLS(MOC5/a AC_SUBST(MOC5,$(qt5_get_bindir)/moc)" \
		-i configure.ac || die

	default

	# Remove bogus Makefile statement. This needs to go upstream
	sed -i /"@YELP_HELP_RULES@"/d help/Makefile.am || die
	if has_version dev-libs/gobject-introspection; then
		eautoreconf
	else
		AT_M4DIR=${WORKDIR} eautoreconf
	fi
}

src_configure() {
	append-cxxflags -std=c++11  # use qt5

	local myeconfargs=(
		--localstatedir=/var
		--disable-static
		--disable-tests
		--disable-libaudit
		--disable-introspection
		--disable-liblightdm-qt
		--enable-liblightdm-qt5
		--disable-vala
	)
	econf "${myeconfargs[@]}"
}

src_compile() {
	cd "${S}/liblightdm-qt" && \
		emake
}

src_install() {
	cd "${S}/liblightdm-qt" && \
		emake DESTDIR="${ED}" install

	find "${ED}" \( -name '*.a' -o -name "*.la" \) -delete || die
}
