# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

PYTHON_COMPAT=( python2_7 )

inherit eutils gnome2-utils fdo-mime python-single-r1

DESCRIPTION="Rigo, the Sabayon Application Browser"
HOMEPAGE="http://www.sabayon.org"
LICENSE="GPL-3"

SLOT="0"
KEYWORDS="~amd64 ~arm ~x86"
IUSE="+passwordless-upgrade"

SRC_URI="mirror://sabayon/sys-apps/entropy-${PV}.tar.bz2"
S="${WORKDIR}/entropy-${PV}/rigo"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${PYTHON_DEPS}
	|| ( dev-python/pygobject-cairo:3 dev-python/pygobject:3[cairo] )
	~sys-apps/entropy-${PV}[${PYTHON_USEDEP}]
	~sys-apps/rigo-daemon-${PV}[${PYTHON_USEDEP}]
	sys-devel/gettext
	x11-libs/gtk+:3
	x11-libs/vte:2.91
	>=x11-misc/xdg-utils-1.1.0_rc1_p20120319"
PDEPEND="passwordless-upgrade? ( app-misc/passwordless-upgrade )"

REQUIRED_USE="${PYTHON_REQUIRED_USE}"

src_prepare() {
	default
	python_fix_shebang "${S}"
}

src_install() {
	emake DESTDIR="${D}" install
	python_optimize "${D}/usr/lib/rigo/${PN}"
}

pkg_postinst() {
	fdo-mime_mime_database_update
	fdo-mime_desktop_database_update
}

pkg_postrm() {
	fdo-mime_mime_database_update
	fdo-mime_desktop_database_update
}
