# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5
inherit epatch

DESCRIPTION="A GTK/Pango-based terminal that uses libvterm to provide terminal emulation"
HOMEPAGE="http://www.leonerd.org.uk/code/pangoterm/"
SRC_URI="https://dev.gentoo.org/~tranquility/distfiles/${P}.tar.gz"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64"
IUSE=""

DEPEND=">=dev-libs/libvterm-0.0_pre20151022"
RDEPEND="${DEPEND}
	dev-libs/glib:2
	x11-libs/cairo
	x11-libs/gdk-pixbuf:2
	x11-libs/gtk+:2
	x11-libs/pango
"

S=${WORKDIR}/pangoterm-0

src_prepare() {
	epatch "${FILESDIR}/${PN}-VTermColor.patch"  # bug 695484
	epatch_user
}

src_install() {
	emake PREFIX="/usr" DESTDIR="${D}" install
}
