/*******************************************/
/*  Envelope Class, Perry R. Cook, 1995-96 */ 
/*  This is the base class for envelopes.  */
/*  This one is capable of ramping state   */
/*  from where it is to a target value by  */
/*  a rate.  It also responds to simple    */
/*  KeyOn and KeyOff messages, ramping to  */         
/*  1.0 on keyon and to 0.0 on keyoff.     */
/*  There are two tick (update value)      */
/*  methods, one returns the value, and    */
/*  other returns 0 if the envelope is at  */
/*  the target value (the state bit).      */
/*******************************************/

#if !defined(__Envelope_h)
#define __Envelope_h

extern FLOAT esr;
#define RATE_NORM	(22050.0/esr)

typedef struct Envelope {
    FLOAT	value;
    FLOAT	target;
    FLOAT	rate;
    int		state;
} Envelope;

void make_Envelope(Envelope*);
void dest_Envelope(Envelope*);
void Envelope_keyOn(Envelope*);
void Envelope_keyOff(Envelope*);
void Envelope_setRate(Envelope*, FLOAT);
void Envelope_setTarget(Envelope*, FLOAT);
void Envelope_setValue(Envelope*,FLOAT);
FLOAT Envelope_tick(Envelope*);
int Envelope_informTick(Envelope*);
FLOAT Envelope_lastOut(Envelope*);

#endif
