/**********************************************/
/*  Lip Filter Object by Perry R. Cook, 1995-96*/    
/*  The lip of the brass player has dynamics  */
/*  which are controlled by the mass, spring  */
/*  constant, and damping of the lip.  This   */
/*  filter simulates that behavior and the    */
/*  transmission/reflection properties as     */
/*  well.  See Cook TBone and HosePlayer      */
/*  instruments and articles.                 */
/**********************************************/

#include "biquad.h"

typedef BiQuad LipFilt;

void make_LipFilt(LipFilt*);
void LipFilt_clear(LipFilt*);
void LipFilt_setFreq(LipFilt*, FLOAT frequency);
FLOAT LipFilt_tick(LipFilt*, FLOAT mouthSample,FLOAT boreSample);
FLOAT LipFilt_lastOut(LipFilt*);

