/*  
    onepole.h:

    Copyright (C) 1996, 1997 Perry Cook, John ffitch

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

/*******************************************/
/*  One Pole Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */
/*  The parameter gain is an additional    */
/*  gain parameter applied to the filter   */
/*  on top of the normalization that takes */
/*  place automatically.  So the net max   */
/*  gain through the system equals the     */
/*  value of gain.  sgain is the combina-  */
/*  tion of gain and the normalization     */
/*  parameter, so if you set the poleCoeff */
/*  to alpha, sgain is always set to       */
/*  gain * (1.0 - fabs(alpha)).            */
/*******************************************/

#if !defined(__OnePole_h)
#define __OnePole_h

typedef struct OnePole {
    MYFLT gain;                 /* Start Filter subclass */
    MYFLT outputs;
    /*    MYFLT *inputs; */
    MYFLT lastOutput;           /* End */
    MYFLT poleCoeff;
    MYFLT sgain;
} OnePole;

void make_OnePole(OnePole*);
void OnePole_clear(OnePole*);
void OnePole_setPole(OnePole*, MYFLT aValue);
void OnePole_setGain(OnePole*, MYFLT aValue);
MYFLT OnePole_tick(OnePole*, MYFLT sample);
void OnePole_print(OnePole*);

#endif
