// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s
// RUN: %clang_cc1 -verify -fopenmp -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck -check-prefix=LAMBDA %s
// RUN: %clang_cc1 -verify -fopenmp -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck -check-prefix=BLOCKS %s
// RUN: %clang_cc1 -verify -fopenmp -x c++ -std=c++11 -DARRAY -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck -check-prefix=ARRAY %s

// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY0 %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefix SIMD-ONLY1 %s
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY2 %s
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY3 %s
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -std=c++11 -DARRAY -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck --check-prefix SIMD-ONLY4 %s
// expected-no-diagnostics

#ifndef ARRAY
#ifndef HEADER
#define HEADER

template <class T>
struct S {
  T f;
  S(T a) : f(a) {}
  S() : f() {}
  S(const S &s, T t = T()) : f(s.f + t) {}
  operator T() { return T(); }
  ~S() {}
};

volatile double g;

template <typename T>
T tmain() {
  S<T> ttt;
  S<T> test(ttt);
  T t_var __attribute__((aligned(128))) = T();
  T vec[] = {1, 2};
  S<T> s_arr[] = {1, 2};
  S<T> var(3);
#pragma omp parallel master taskloop simd firstprivate(t_var, vec, s_arr, s_arr, var, var)
  for (int i = 0; i < 10; ++i) {
    vec[0] = t_var;
    s_arr[0] = var;
  }
  return T();
}

int main() {
  static int sivar;
#ifdef LAMBDA
  [&]() {


#pragma omp parallel master taskloop simd firstprivate(g, sivar)
  for (int i = 0; i < 10; ++i) {

    g = 1;
    sivar = 11;
    [&]() {
      g = 2;
      sivar = 22;
    }();
  }
  }();
  return 0;
#elif defined(BLOCKS)
  ^{

#pragma omp parallel master taskloop simd firstprivate(g, sivar)
  for (int i = 0; i < 10; ++i) {

    g = 1;
    sivar = 11;
    ^{
      g = 2;
      sivar = 22;
    }();
  }
  }();
  return 0;
#else
  S<double> ttt;
  S<double> test(ttt);
  int t_var = 0;
  int vec[] = {1, 2};
  S<double> s_arr[] = {1, 2};
  S<double> var(3);
#pragma omp parallel master taskloop simd firstprivate(var, t_var, s_arr, vec, s_arr, var, sivar)
  for (int i = 0; i < 10; ++i) {
    vec[0] = t_var;
    s_arr[0] = var;
    sivar = 33;
  }
  return tmain<int>();
#endif
}



// Store original variables in capture struct.

// Allocate task.
// Returns struct kmp_task_t {
//         [[KMP_TASK_T]] task_data;
//         [[KMP_TASK_MAIN_TY]] privates;
//       };

// Fill kmp_task_t->shareds by copying from original capture argument.

// Initialize kmp_task_t->privates with default values (no init for simple types, default constructors for classes).
// Also copy address of private copy to the corresponding shareds reference.

// Constructors for s_arr and var.
// s_arr;

// var;

// t_var;

// vec;

// sivar;

// Provide pointer to destructor function, which will destroy private variables at the end of the task.

// Start task.






// Privates actually are used.








// Store original variables in capture struct.

// Allocate task.
// Returns struct kmp_task_t {
//         [[KMP_TASK_T_TY]] task_data;
//         [[KMP_TASK_TMAIN_TY]] privates;
//       };

// Fill kmp_task_t->shareds by copying from original capture argument.

// Initialize kmp_task_t->privates with default values (no init for simple types, default constructors for classes).

// t_var;

// vec;

// Constructors for s_arr and var.
// a_arr;

// var;

// Provide pointer to destructor function, which will destroy private variables at the end of the task.

// Start task.



// Privates actually are used.






#endif
#else
struct St {
  int a, b;
  St() : a(0), b(0) {}
  St(const St &) {}
  ~St() {}
};

void array_func(int n, float a[n], St s[2]) {
#pragma omp parallel master taskloop simd firstprivate(a, s)
  for (int i = 0; i < 10; ++i)
    ;
}
#endif

// CHECK-LABEL: define {{[^@]+}}@main
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// CHECK-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S]], align 8
// CHECK-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 16
// CHECK-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S]], align 8
// CHECK-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    call void @_ZN1SIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]])
// CHECK-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]], ptr noundef nonnull align 8 dereferenceable(8) [[TTT]], double noundef 0.000000e+00)
// CHECK-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// CHECK-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// CHECK-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_BEGIN]], double noundef 1.000000e+00)
// CHECK-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_ELEMENT]], double noundef 2.000000e+00)
// CHECK-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]], double noundef 3.000000e+00)
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[T_VAR]], align 4
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[T_VAR_CASTED]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1:[0-9]+]], i32 4, ptr @main.omp_outlined, ptr [[VEC]], i64 [[TMP1]], ptr [[S_ARR]], ptr [[VAR]])
// CHECK-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]]) #[[ATTR4:[0-9]+]]
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK:       arraydestroy.body:
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK:       arraydestroy.done1:
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]]) #[[ATTR4]]
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]]) #[[ATTR4]]
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP3]]
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ev
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC1ERKS0_d
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// CHECK-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[T_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIdEC2ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], ptr noundef nonnull align 8 dereferenceable(8) [[TMP0]], double noundef [[TMP1]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ed
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIdEC2Ed(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], double noundef [[TMP0]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@main.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 8 dereferenceable(16) [[S_ARR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[VAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK:       omp_if.then:
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[TMP7]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_ANON]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[TMP8]], align 8
// CHECK-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP4]], i32 9, i64 120, i64 16, ptr @.omp_task_entry.)
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP9]], i32 0, i32 0
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP10]], i32 0, i32 0
// CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP12]], ptr align 8 [[AGG_CAPTURED]], i64 16, i1 false)
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP9]], i32 0, i32 1
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP13]], i32 0, i32 0
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[TMP14]], i32 0, i32 0
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP15]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE1:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK:       omp.arraycpy.body:
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[OMP_IF_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[OMP_IF_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 8 dereferenceable(8) [[OMP_ARRAYCPY_SRCELEMENTPAST]], double noundef 0.000000e+00)
// CHECK-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP15]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE1]], label [[OMP_ARRAYCPY_BODY]]
// CHECK:       omp.arraycpy.done1:
// CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP13]], i32 0, i32 1
// CHECK-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[TMP16]], ptr noundef nonnull align 8 dereferenceable(8) [[TMP2]], double noundef 0.000000e+00)
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP13]], i32 0, i32 2
// CHECK-NEXT:    [[TMP18:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4
// CHECK-NEXT:    store i32 [[TMP18]], ptr [[TMP17]], align 8
// CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP13]], i32 0, i32 3
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP19]], ptr align 4 [[TMP0]], i64 8, i1 false)
// CHECK-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP13]], i32 0, i32 4
// CHECK-NEXT:    [[TMP21:%.*]] = load i32, ptr @_ZZ4mainE5sivar, align 4
// CHECK-NEXT:    store i32 [[TMP21]], ptr [[TMP20]], align 4
// CHECK-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 3
// CHECK-NEXT:    store ptr @.omp_task_destructor., ptr [[TMP22]], align 8
// CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 5
// CHECK-NEXT:    store i64 0, ptr [[TMP23]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 6
// CHECK-NEXT:    store i64 9, ptr [[TMP24]], align 8
// CHECK-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 7
// CHECK-NEXT:    store i64 1, ptr [[TMP25]], align 8
// CHECK-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 9
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP26]], i8 0, i64 8, i1 false)
// CHECK-NEXT:    [[TMP27:%.*]] = load i64, ptr [[TMP25]], align 8
// CHECK-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP4]], ptr [[TMP9]], i32 1, ptr [[TMP23]], ptr [[TMP24]], i64 [[TMP27]], i32 1, i32 0, i64 0, ptr @.omp_task_dup.)
// CHECK-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    br label [[OMP_IF_END]]
// CHECK:       omp_if.end:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]], ptr noalias noundef [[TMP2:%.*]], ptr noalias noundef [[TMP3:%.*]], ptr noalias noundef [[TMP4:%.*]], ptr noalias noundef [[TMP5:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP4]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    store ptr [[TMP5]], ptr [[DOTADDR5]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP6]], i32 0, i32 0
// CHECK-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP7]], ptr [[TMP8]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP6]], i32 0, i32 1
// CHECK-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store ptr [[TMP9]], ptr [[TMP10]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP6]], i32 0, i32 2
// CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[DOTADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP11]], ptr [[TMP12]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP6]], i32 0, i32 3
// CHECK-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    store ptr [[TMP13]], ptr [[TMP14]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP6]], i32 0, i32 4
// CHECK-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR5]], align 8
// CHECK-NEXT:    store ptr [[TMP15]], ptr [[TMP16]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR4_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP3]], i32 0, i32 1
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias [[META14:![0-9]+]]
// CHECK-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias [[META14]]
// CHECK-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR2_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR3_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR4_I]]) #[[ATTR4]]
// CHECK-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR4_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// CHECK-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP27]] to i32
// CHECK-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]]
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK:       omp.inner.for.cond.i:
// CHECK-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15:![0-9]+]]
// CHECK-NEXT:    [[CONV5_I:%.*]] = sext i32 [[TMP28]] to i64
// CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV5_I]], [[TMP29]]
// CHECK-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// CHECK:       omp.inner.for.body.i:
// CHECK-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    store i32 [[TMP30]], ptr [[I_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr [[TMP23]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    store i32 [[TMP31]], ptr [[TMP25]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP24]], ptr align 8 [[TMP22]], i64 8, i1 false), !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    store i32 33, ptr [[TMP26]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    [[ADD7_I:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK-NEXT:    store i32 [[ADD7_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK:       .omp_outlined..exit:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_dup.
// CHECK-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], i32 noundef [[TMP2:%.*]]) #[[ATTR7]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR2:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[DOTADDR2]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP3]], i32 0, i32 1
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP8]], i32 0, i32 0
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[TMP9]], i32 0, i32 0
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP12]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE3:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK:       omp.arraycpy.body:
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP11]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 8 dereferenceable(8) [[OMP_ARRAYCPY_SRCELEMENTPAST]], double noundef 0.000000e+00)
// CHECK-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP12]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE3]], label [[OMP_ARRAYCPY_BODY]]
// CHECK:       omp.arraycpy.done3:
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP8]], i32 0, i32 1
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_ANON]], ptr [[TMP7]], i32 0, i32 1
// CHECK-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[TMP13]], ptr noundef nonnull align 8 dereferenceable(8) [[TMP15]], double noundef 0.000000e+00)
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_destructor.
// CHECK-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR7]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP2]], i32 0, i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP3]], i32 0, i32 1
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TMP5]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK:       arraydestroy.body:
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK:       arraydestroy.done2:
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdED1Ev
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIdED2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]]) #[[ATTR4]]
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK-SAME: () #[[ATTR9:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK-NEXT:    [[T_VAR:%.*]] = alloca i32, align 128
// CHECK-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]])
// CHECK-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]], ptr noundef nonnull align 4 dereferenceable(4) [[TTT]], i32 noundef 0)
// CHECK-NEXT:    store i32 0, ptr [[T_VAR]], align 128
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// CHECK-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// CHECK-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]], i32 noundef 3)
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[T_VAR]], align 128
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[T_VAR_CASTED]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8
// CHECK-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_Z5tmainIiET_v.omp_outlined, ptr [[VEC]], i64 [[TMP1]], ptr [[S_ARR]], ptr [[VAR]])
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK:       arraydestroy.body:
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK:       arraydestroy.done1:
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]]) #[[ATTR4]]
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP3]]
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ev
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    store double 0.000000e+00, ptr [[F]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC2ERKS0_d
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// CHECK-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// CHECK-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[TMP0]], i32 0, i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = load double, ptr [[F2]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load double, ptr [[T_ADDR]], align 8
// CHECK-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], [[TMP2]]
// CHECK-NEXT:    store double [[ADD]], ptr [[F]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ed
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// CHECK-NEXT:    store double [[TMP0]], ptr [[F]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIdED2Ev
// CHECK-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC1ERKS0_i
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// CHECK-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_ADDR]], align 4
// CHECK-NEXT:    call void @_ZN1SIiEC2ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]], i32 noundef [[TMP1]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_Z5tmainIiET_v.omp_outlined
// CHECK-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_1:%.*]], align 8
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK:       omp_if.then:
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_1]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[TMP7]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_ANON_1]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[TMP8]], align 8
// CHECK-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP4]], i32 9, i64 256, i64 16, ptr @.omp_task_entry..3)
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2:%.*]], ptr [[TMP9]], i32 0, i32 0
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP10]], i32 0, i32 0
// CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 128
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP12]], ptr align 8 [[AGG_CAPTURED]], i64 16, i1 false)
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2]], ptr [[TMP9]], i32 0, i32 2
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3:%.*]], ptr [[TMP13]], i32 0, i32 0
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4
// CHECK-NEXT:    store i32 [[TMP15]], ptr [[TMP14]], align 128
// CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP13]], i32 0, i32 1
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP16]], ptr align 4 [[TMP0]], i64 8, i1 false)
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP13]], i32 0, i32 2
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[TMP17]], i32 0, i32 0
// CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP18]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE1:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK:       omp.arraycpy.body:
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[OMP_IF_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[OMP_IF_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 noundef 0)
// CHECK-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP18]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE1]], label [[OMP_ARRAYCPY_BODY]]
// CHECK:       omp.arraycpy.done1:
// CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP13]], i32 0, i32 3
// CHECK-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[TMP19]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP2]], i32 noundef 0)
// CHECK-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 3
// CHECK-NEXT:    store ptr @.omp_task_destructor..5, ptr [[TMP20]], align 8
// CHECK-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 5
// CHECK-NEXT:    store i64 0, ptr [[TMP21]], align 8
// CHECK-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 6
// CHECK-NEXT:    store i64 9, ptr [[TMP22]], align 16
// CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 7
// CHECK-NEXT:    store i64 1, ptr [[TMP23]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP10]], i32 0, i32 9
// CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP24]], i8 0, i64 8, i1 false)
// CHECK-NEXT:    [[TMP25:%.*]] = load i64, ptr [[TMP23]], align 8
// CHECK-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP4]], ptr [[TMP9]], i32 1, ptr [[TMP21]], ptr [[TMP22]], i64 [[TMP25]], i32 1, i32 0, i64 0, ptr @.omp_task_dup..4)
// CHECK-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK-NEXT:    br label [[OMP_IF_END]]
// CHECK:       omp_if.end:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_privates_map..2
// CHECK-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]], ptr noalias noundef [[TMP2:%.*]], ptr noalias noundef [[TMP3:%.*]], ptr noalias noundef [[TMP4:%.*]]) #[[ATTR6]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP4]], ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store ptr [[TMP6]], ptr [[TMP7]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP5]], i32 0, i32 1
// CHECK-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[DOTADDR2]], align 8
// CHECK-NEXT:    store ptr [[TMP8]], ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP5]], i32 0, i32 2
// CHECK-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTADDR3]], align 8
// CHECK-NEXT:    store ptr [[TMP10]], ptr [[TMP11]], align 8
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP5]], i32 0, i32 3
// CHECK-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTADDR4]], align 8
// CHECK-NEXT:    store ptr [[TMP12]], ptr [[TMP13]], align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_entry..3
// CHECK-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR7]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 128
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2]], ptr [[TMP3]], i32 0, i32 2
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 16
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// CHECK-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 64
// CHECK-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META21:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META24:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META26:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META28:![0-9]+]])
// CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META30:![0-9]+]])
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias [[META32:![0-9]+]]
// CHECK-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store ptr @.omp_task_privates_map..2, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias [[META32]]
// CHECK-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR2_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META32]]
// CHECK-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP26]] to i32
// CHECK-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META32]]
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK:       omp.inner.for.cond.i:
// CHECK-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META32]], !llvm.access.group [[ACC_GRP33:![0-9]+]]
// CHECK-NEXT:    [[CONV4_I:%.*]] = sext i32 [[TMP27]] to i64
// CHECK-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META32]], !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV4_I]], [[TMP28]]
// CHECK-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__1_EXIT:%.*]]
// CHECK:       omp.inner.for.body.i:
// CHECK-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META32]], !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    store i32 [[TMP29]], ptr [[I_I]], align 4, !noalias [[META32]], !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    [[TMP30:%.*]] = load i32, ptr [[TMP22]], align 128, !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    store i32 [[TMP30]], ptr [[TMP23]], align 4, !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP24]], ptr align 4 [[TMP25]], i64 4, i1 false), !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META32]], !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    [[ADD6_I:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK-NEXT:    store i32 [[ADD6_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META32]], !llvm.access.group [[ACC_GRP33]]
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP34:![0-9]+]]
// CHECK:       .omp_outlined..1.exit:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_dup..4
// CHECK-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], i32 noundef [[TMP2:%.*]]) #[[ATTR7]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[DOTADDR2:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[DOTADDR2]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 128
// CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2]], ptr [[TMP3]], i32 0, i32 2
// CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3:%.*]], ptr [[TMP8]], i32 0, i32 2
// CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_ANON_1:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[TMP9]], i32 0, i32 0
// CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP12]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE3:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK:       omp.arraycpy.body:
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP11]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 noundef 0)
// CHECK-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP12]]
// CHECK-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE3]], label [[OMP_ARRAYCPY_BODY]]
// CHECK:       omp.arraycpy.done3:
// CHECK-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP8]], i32 0, i32 3
// CHECK-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_ANON_1]], ptr [[TMP7]], i32 0, i32 1
// CHECK-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[TMP13]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP15]], i32 noundef 0)
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@.omp_task_destructor..5
// CHECK-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR7]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_2:%.*]], ptr [[TMP2]], i32 0, i32 2
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3:%.*]], ptr [[TMP3]], i32 0, i32 2
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T_3]], ptr [[TMP3]], i32 0, i32 3
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP5]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[TMP4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK:       arraydestroy.body:
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK:       arraydestroy.done2:
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    store i32 0, ptr [[F]], align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC2ERKS0_i
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// CHECK-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// CHECK-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[TMP0]], i32 0, i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[F2]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[T_ADDR]], align 4
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[F]], align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-NEXT:    ret void
//
//
// LAMBDA-LABEL: define {{[^@]+}}@main
// LAMBDA-SAME: () #[[ATTR0:[0-9]+]] {
// LAMBDA-NEXT:  entry:
// LAMBDA-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 1
// LAMBDA-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// LAMBDA-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 1 dereferenceable(1) [[REF_TMP]])
// LAMBDA-NEXT:    ret i32 0
//
//
// LAMBDA-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// LAMBDA-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]], ptr noalias noundef [[TMP2:%.*]]) #[[ATTR5:[0-9]+]] {
// LAMBDA-NEXT:  entry:
// LAMBDA-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTADDR2:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// LAMBDA-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// LAMBDA-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR2]], align 8
// LAMBDA-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// LAMBDA-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP3]], i32 0, i32 0
// LAMBDA-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// LAMBDA-NEXT:    store ptr [[TMP4]], ptr [[TMP5]], align 8
// LAMBDA-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP3]], i32 0, i32 1
// LAMBDA-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTADDR2]], align 8
// LAMBDA-NEXT:    store ptr [[TMP6]], ptr [[TMP7]], align 8
// LAMBDA-NEXT:    ret void
//
//
// LAMBDA-LABEL: define {{[^@]+}}@.omp_task_entry.
// LAMBDA-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// LAMBDA-NEXT:  entry:
// LAMBDA-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// LAMBDA-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// LAMBDA-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// LAMBDA-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[REF_TMP_I:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// LAMBDA-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// LAMBDA-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// LAMBDA-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// LAMBDA-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// LAMBDA-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// LAMBDA-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// LAMBDA-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// LAMBDA-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// LAMBDA-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// LAMBDA-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// LAMBDA-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP3]], i32 0, i32 1
// LAMBDA-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// LAMBDA-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// LAMBDA-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// LAMBDA-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// LAMBDA-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// LAMBDA-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// LAMBDA-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// LAMBDA-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// LAMBDA-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// LAMBDA-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// LAMBDA-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// LAMBDA-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// LAMBDA-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// LAMBDA-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// LAMBDA-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// LAMBDA-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias [[META14:![0-9]+]]
// LAMBDA-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias [[META14]]
// LAMBDA-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]]) #[[ATTR3:[0-9]+]]
// LAMBDA-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// LAMBDA-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP24]] to i32
// LAMBDA-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]]
// LAMBDA-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// LAMBDA:       omp.inner.for.cond.i:
// LAMBDA-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15:![0-9]+]]
// LAMBDA-NEXT:    [[CONV2_I:%.*]] = sext i32 [[TMP25]] to i64
// LAMBDA-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV2_I]], [[TMP26]]
// LAMBDA-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// LAMBDA:       omp.inner.for.body.i:
// LAMBDA-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    store i32 [[TMP27]], ptr [[I_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    store double 1.000000e+00, ptr [[TMP22]], align 8, !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    store i32 11, ptr [[TMP23]], align 4, !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    store ptr [[TMP22]], ptr [[REF_TMP_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP_I]], i32 0, i32 1
// LAMBDA-NEXT:    store ptr [[TMP23]], ptr [[TMP28]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP_I]]), !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    [[ADD3_I:%.*]] = add nsw i32 [[TMP29]], 1
// LAMBDA-NEXT:    store i32 [[ADD3_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// LAMBDA-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP16:![0-9]+]]
// LAMBDA:       .omp_outlined..exit:
// LAMBDA-NEXT:    ret i32 0
//
//
// BLOCKS-LABEL: define {{[^@]+}}@main
// BLOCKS-SAME: () #[[ATTR1:[0-9]+]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// BLOCKS-NEXT:    [[TMP0:%.*]] = load ptr, ptr getelementptr inbounds ([[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr @__block_literal_global, i32 0, i32 3), align 8
// BLOCKS-NEXT:    call void [[TMP0]](ptr noundef @__block_literal_global)
// BLOCKS-NEXT:    ret i32 0
//
//
// BLOCKS-LABEL: define {{[^@]+}}@__main_block_invoke
// BLOCKS-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2:[0-9]+]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// BLOCKS-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// BLOCKS-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1:[0-9]+]], i32 0, ptr @__main_block_invoke.omp_outlined)
// BLOCKS-NEXT:    ret void
//
//
// BLOCKS-LABEL: define {{[^@]+}}@__main_block_invoke.omp_outlined
// BLOCKS-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 1
// BLOCKS-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// BLOCKS-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// BLOCKS-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// BLOCKS-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// BLOCKS-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// BLOCKS-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// BLOCKS-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// BLOCKS:       omp_if.then:
// BLOCKS-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// BLOCKS-NEXT:    [[TMP4:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i64 96, i64 1, ptr @.omp_task_entry.)
// BLOCKS-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP4]], i32 0, i32 0
// BLOCKS-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP4]], i32 0, i32 1
// BLOCKS-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP6]], i32 0, i32 0
// BLOCKS-NEXT:    [[TMP8:%.*]] = load volatile double, ptr @g, align 8
// BLOCKS-NEXT:    store volatile double [[TMP8]], ptr [[TMP7]], align 8
// BLOCKS-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP6]], i32 0, i32 1
// BLOCKS-NEXT:    [[TMP10:%.*]] = load i32, ptr @_ZZ4mainE5sivar, align 4
// BLOCKS-NEXT:    store i32 [[TMP10]], ptr [[TMP9]], align 8
// BLOCKS-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP5]], i32 0, i32 5
// BLOCKS-NEXT:    store i64 0, ptr [[TMP11]], align 8
// BLOCKS-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP5]], i32 0, i32 6
// BLOCKS-NEXT:    store i64 9, ptr [[TMP12]], align 8
// BLOCKS-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP5]], i32 0, i32 7
// BLOCKS-NEXT:    store i64 1, ptr [[TMP13]], align 8
// BLOCKS-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP5]], i32 0, i32 9
// BLOCKS-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP14]], i8 0, i64 8, i1 false)
// BLOCKS-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP13]], align 8
// BLOCKS-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP4]], i32 1, ptr [[TMP11]], ptr [[TMP12]], i64 [[TMP15]], i32 1, i32 0, i64 0, ptr null)
// BLOCKS-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// BLOCKS-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// BLOCKS-NEXT:    br label [[OMP_IF_END]]
// BLOCKS:       omp_if.end:
// BLOCKS-NEXT:    ret void
//
//
// BLOCKS-LABEL: define {{[^@]+}}@_block_invoke
// BLOCKS-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// BLOCKS-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// BLOCKS-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 5
// BLOCKS-NEXT:    store double 2.000000e+00, ptr [[BLOCK_CAPTURE_ADDR]], align 8
// BLOCKS-NEXT:    [[BLOCK_CAPTURE_ADDR1:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 6
// BLOCKS-NEXT:    store i32 22, ptr [[BLOCK_CAPTURE_ADDR1]], align 8
// BLOCKS-NEXT:    ret void
//
//
// BLOCKS-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// BLOCKS-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]], ptr noalias noundef [[TMP2:%.*]]) #[[ATTR6:[0-9]+]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTADDR2:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// BLOCKS-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// BLOCKS-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR2]], align 8
// BLOCKS-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// BLOCKS-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP3]], i32 0, i32 0
// BLOCKS-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// BLOCKS-NEXT:    store ptr [[TMP4]], ptr [[TMP5]], align 8
// BLOCKS-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP3]], i32 0, i32 1
// BLOCKS-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTADDR2]], align 8
// BLOCKS-NEXT:    store ptr [[TMP6]], ptr [[TMP7]], align 8
// BLOCKS-NEXT:    ret void
//
//
// BLOCKS-LABEL: define {{[^@]+}}@.omp_task_entry.
// BLOCKS-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// BLOCKS-NEXT:  entry:
// BLOCKS-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// BLOCKS-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// BLOCKS-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// BLOCKS-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    [[BLOCK_I:%.*]] = alloca <{ ptr, i32, i32, ptr, ptr, double, i32 }>, align 8
// BLOCKS-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// BLOCKS-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// BLOCKS-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// BLOCKS-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// BLOCKS-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// BLOCKS-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// BLOCKS-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// BLOCKS-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// BLOCKS-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// BLOCKS-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// BLOCKS-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP3]], i32 0, i32 1
// BLOCKS-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// BLOCKS-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// BLOCKS-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// BLOCKS-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// BLOCKS-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// BLOCKS-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// BLOCKS-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// BLOCKS-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// BLOCKS-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// BLOCKS-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// BLOCKS-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// BLOCKS-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// BLOCKS-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// BLOCKS-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// BLOCKS-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// BLOCKS-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias [[META14:![0-9]+]]
// BLOCKS-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias [[META14]]
// BLOCKS-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]]) #[[ATTR4:[0-9]+]]
// BLOCKS-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// BLOCKS-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP24]] to i32
// BLOCKS-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]]
// BLOCKS-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// BLOCKS:       omp.inner.for.cond.i:
// BLOCKS-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15:![0-9]+]]
// BLOCKS-NEXT:    [[CONV2_I:%.*]] = sext i32 [[TMP25]] to i64
// BLOCKS-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV2_I]], [[TMP26]]
// BLOCKS-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// BLOCKS:       omp.inner.for.body.i:
// BLOCKS-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store i32 [[TMP27]], ptr [[I_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store double 1.000000e+00, ptr [[TMP22]], align 8, !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store i32 11, ptr [[TMP23]], align 4, !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store ptr @_NSConcreteStackBlock, ptr [[BLOCK_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_FLAGS_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 1
// BLOCKS-NEXT:    store i32 1073741824, ptr [[BLOCK_FLAGS_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_RESERVED_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 2
// BLOCKS-NEXT:    store i32 0, ptr [[BLOCK_RESERVED_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_INVOKE_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 3
// BLOCKS-NEXT:    store ptr @_block_invoke, ptr [[BLOCK_INVOKE_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_DESCRIPTOR_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 4
// BLOCKS-NEXT:    store ptr @__block_descriptor_tmp.1, ptr [[BLOCK_DESCRIPTOR_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_CAPTURED_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 5
// BLOCKS-NEXT:    [[TMP28:%.*]] = load volatile double, ptr [[TMP22]], align 8, !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store volatile double [[TMP28]], ptr [[BLOCK_CAPTURED_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[BLOCK_CAPTURED3_I:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK_I]], i32 0, i32 6
// BLOCKS-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP23]], align 4, !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    store i32 [[TMP29]], ptr [[BLOCK_CAPTURED3_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr [[BLOCK_I]], i32 0, i32 3
// BLOCKS-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[TMP30]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    call void [[TMP31]](ptr noundef [[BLOCK_I]]) #[[ATTR4]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    [[ADD4_I:%.*]] = add nsw i32 [[TMP32]], 1
// BLOCKS-NEXT:    store i32 [[ADD4_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// BLOCKS-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP16:![0-9]+]]
// BLOCKS:       .omp_outlined..exit:
// BLOCKS-NEXT:    ret i32 0
//
//
// ARRAY-LABEL: define {{[^@]+}}@_Z10array_funciPfP2St
// ARRAY-SAME: (i32 noundef [[N:%.*]], ptr noundef [[A:%.*]], ptr noundef [[S:%.*]]) #[[ATTR0:[0-9]+]] {
// ARRAY-NEXT:  entry:
// ARRAY-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    store i32 [[N]], ptr [[N_ADDR]], align 4
// ARRAY-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// ARRAY-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// ARRAY-NEXT:    [[TMP0:%.*]] = load i32, ptr [[N_ADDR]], align 4
// ARRAY-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// ARRAY-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// ARRAY-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// ARRAY-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1:[0-9]+]], i32 3, ptr @_Z10array_funciPfP2St.omp_outlined, i64 [[TMP1]], ptr [[TMP2]], ptr [[TMP3]])
// ARRAY-NEXT:    ret void
//
//
// ARRAY-LABEL: define {{[^@]+}}@_Z10array_funciPfP2St.omp_outlined
// ARRAY-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[VLA:%.*]], ptr noundef [[A:%.*]], ptr noundef [[S:%.*]]) #[[ATTR1:[0-9]+]] {
// ARRAY-NEXT:  entry:
// ARRAY-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// ARRAY-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 8
// ARRAY-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// ARRAY-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// ARRAY-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// ARRAY-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// ARRAY-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// ARRAY-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// ARRAY-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// ARRAY-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 4
// ARRAY-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP2]])
// ARRAY-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
// ARRAY-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// ARRAY:       omp_if.then:
// ARRAY-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_ANON]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// ARRAY-NEXT:    store i64 [[TMP0]], ptr [[TMP5]], align 8
// ARRAY-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP2]])
// ARRAY-NEXT:    [[TMP6:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i64 96, i64 8, ptr @.omp_task_entry.)
// ARRAY-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP6]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP7]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// ARRAY-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP9]], ptr align 8 [[AGG_CAPTURED]], i64 8, i1 false)
// ARRAY-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP6]], i32 0, i32 1
// ARRAY-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP10]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// ARRAY-NEXT:    store ptr [[TMP12]], ptr [[TMP11]], align 8
// ARRAY-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP10]], i32 0, i32 1
// ARRAY-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// ARRAY-NEXT:    store ptr [[TMP14]], ptr [[TMP13]], align 8
// ARRAY-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP7]], i32 0, i32 5
// ARRAY-NEXT:    store i64 0, ptr [[TMP15]], align 8
// ARRAY-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP7]], i32 0, i32 6
// ARRAY-NEXT:    store i64 9, ptr [[TMP16]], align 8
// ARRAY-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP7]], i32 0, i32 7
// ARRAY-NEXT:    store i64 1, ptr [[TMP17]], align 8
// ARRAY-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP7]], i32 0, i32 9
// ARRAY-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP18]], i8 0, i64 8, i1 false)
// ARRAY-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP17]], align 8
// ARRAY-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP2]], ptr [[TMP6]], i32 1, ptr [[TMP15]], ptr [[TMP16]], i64 [[TMP19]], i32 1, i32 0, i64 0, ptr null)
// ARRAY-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP2]])
// ARRAY-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP2]])
// ARRAY-NEXT:    br label [[OMP_IF_END]]
// ARRAY:       omp_if.end:
// ARRAY-NEXT:    ret void
//
//
// ARRAY-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// ARRAY-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]], ptr noalias noundef [[TMP2:%.*]]) #[[ATTR4:[0-9]+]] {
// ARRAY-NEXT:  entry:
// ARRAY-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTADDR2:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// ARRAY-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// ARRAY-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR2]], align 8
// ARRAY-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// ARRAY-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP3]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// ARRAY-NEXT:    store ptr [[TMP4]], ptr [[TMP5]], align 8
// ARRAY-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], ptr [[TMP3]], i32 0, i32 1
// ARRAY-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTADDR2]], align 8
// ARRAY-NEXT:    store ptr [[TMP6]], ptr [[TMP7]], align 8
// ARRAY-NEXT:    ret void
//
//
// ARRAY-LABEL: define {{[^@]+}}@.omp_task_entry.
// ARRAY-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR5:[0-9]+]] {
// ARRAY-NEXT:  entry:
// ARRAY-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// ARRAY-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// ARRAY-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// ARRAY-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// ARRAY-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// ARRAY-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// ARRAY-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// ARRAY-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// ARRAY-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// ARRAY-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// ARRAY-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// ARRAY-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// ARRAY-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], ptr [[TMP3]], i32 0, i32 1
// ARRAY-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// ARRAY-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// ARRAY-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// ARRAY-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// ARRAY-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// ARRAY-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// ARRAY-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// ARRAY-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// ARRAY-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// ARRAY-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// ARRAY-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// ARRAY-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// ARRAY-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// ARRAY-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// ARRAY-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// ARRAY-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias [[META14:![0-9]+]]
// ARRAY-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias [[META14]]
// ARRAY-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[TMP20:%.*]] = load i64, ptr [[TMP19]], align 8
// ARRAY-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    call void [[TMP21]](ptr [[TMP22]], ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]]) #[[ATTR2:[0-9]+]]
// ARRAY-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias [[META14]]
// ARRAY-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP25]] to i32
// ARRAY-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]]
// ARRAY-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// ARRAY:       omp.inner.for.cond.i:
// ARRAY-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15:![0-9]+]]
// ARRAY-NEXT:    [[CONV2_I:%.*]] = sext i32 [[TMP26]] to i64
// ARRAY-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// ARRAY-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV2_I]], [[TMP27]]
// ARRAY-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// ARRAY:       omp.inner.for.body.i:
// ARRAY-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// ARRAY-NEXT:    store i32 [[TMP28]], ptr [[I_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// ARRAY-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// ARRAY-NEXT:    [[ADD3_I:%.*]] = add nsw i32 [[TMP29]], 1
// ARRAY-NEXT:    store i32 [[ADD3_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias [[META14]], !llvm.access.group [[ACC_GRP15]]
// ARRAY-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP16:![0-9]+]]
// ARRAY:       .omp_outlined..exit:
// ARRAY-NEXT:    ret i32 0
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@main
// SIMD-ONLY0-SAME: () #[[ATTR0:[0-9]+]] {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// SIMD-ONLY0-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S]], align 8
// SIMD-ONLY0-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// SIMD-ONLY0-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 16
// SIMD-ONLY0-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S]], align 8
// SIMD-ONLY0-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY0-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY0-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]])
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]], ptr noundef nonnull align 8 dereferenceable(8) [[TTT]], double noundef 0.000000e+00)
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// SIMD-ONLY0-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// SIMD-ONLY0-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_BEGIN]], double noundef 1.000000e+00)
// SIMD-ONLY0-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_ELEMENT]], double noundef 2.000000e+00)
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]], double noundef 3.000000e+00)
// SIMD-ONLY0-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY0-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY0-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// SIMD-ONLY0-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY0:       omp.inner.for.cond:
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2:![0-9]+]]
// SIMD-ONLY0-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP2]]
// SIMD-ONLY0-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY0:       omp.inner.for.body:
// SIMD-ONLY0-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// SIMD-ONLY0-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY0-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[TMP4:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    store i32 [[TMP4]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[ARRAYIDX2]], ptr align 8 [[VAR]], i64 8, i1 false), !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    store i32 33, ptr @_ZZ4mainE5sivar, align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY0:       omp.body.continue:
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY0:       omp.inner.for.inc:
// SIMD-ONLY0-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP5]], 1
// SIMD-ONLY0-NEXT:    store i32 [[ADD3]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// SIMD-ONLY0:       omp.inner.for.end:
// SIMD-ONLY0-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY0-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// SIMD-ONLY0-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]]) #[[ATTR4:[0-9]+]]
// SIMD-ONLY0-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// SIMD-ONLY0-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD-ONLY0:       arraydestroy.body:
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// SIMD-ONLY0-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD-ONLY0:       arraydestroy.done4:
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    ret i32 [[TMP7]]
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC1ERKS0_d
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load double, ptr [[T_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC2ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], ptr noundef nonnull align 8 dereferenceable(8) [[TMP0]], double noundef [[TMP1]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ed
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdEC2Ed(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], double noundef [[TMP0]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// SIMD-ONLY0-SAME: () #[[ATTR3:[0-9]+]] {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// SIMD-ONLY0-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0]], align 4
// SIMD-ONLY0-NEXT:    [[T_VAR:%.*]] = alloca i32, align 128
// SIMD-ONLY0-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// SIMD-ONLY0-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// SIMD-ONLY0-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S_0]], align 4
// SIMD-ONLY0-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY0-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY0-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]])
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]], ptr noundef nonnull align 4 dereferenceable(4) [[TTT]], i32 noundef 0)
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[T_VAR]], align 128
// SIMD-ONLY0-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// SIMD-ONLY0-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// SIMD-ONLY0-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]], i32 noundef 3)
// SIMD-ONLY0-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY0-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY0-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// SIMD-ONLY0-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY0:       omp.inner.for.cond:
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6:![0-9]+]]
// SIMD-ONLY0-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP2]]
// SIMD-ONLY0-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY0:       omp.inner.for.body:
// SIMD-ONLY0-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// SIMD-ONLY0-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY0-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[TMP4:%.*]] = load i32, ptr [[T_VAR]], align 128, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    store i32 [[TMP4]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY0-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX2]], ptr align 4 [[VAR]], i64 4, i1 false), !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY0:       omp.body.continue:
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY0:       omp.inner.for.inc:
// SIMD-ONLY0-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP5]], 1
// SIMD-ONLY0-NEXT:    store i32 [[ADD3]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY0-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// SIMD-ONLY0:       omp.inner.for.end:
// SIMD-ONLY0-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// SIMD-ONLY0-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD-ONLY0:       arraydestroy.body:
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// SIMD-ONLY0-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD-ONLY0:       arraydestroy.done4:
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY0-NEXT:    ret i32 [[TMP7]]
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdED1Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIdED2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store double 0.000000e+00, ptr [[F]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdED2Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC2ERKS0_d
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[TMP0]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load double, ptr [[F2]], align 8
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = load double, ptr [[T_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], [[TMP2]]
// SIMD-ONLY0-NEXT:    store double [[ADD]], ptr [[F]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ed
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store double [[TMP0]], ptr [[F]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC1ERKS0_i
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_ADDR]], align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC2ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]], i32 noundef [[TMP1]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    store i32 0, ptr [[F]], align 4
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC2ERKS0_i
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[TMP0]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP1:%.*]] = load i32, ptr [[F2]], align 4
// SIMD-ONLY0-NEXT:    [[TMP2:%.*]] = load i32, ptr [[T_ADDR]], align 4
// SIMD-ONLY0-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
// SIMD-ONLY0-NEXT:    store i32 [[ADD]], ptr [[F]], align 4
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY0-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD-ONLY0-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY0-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// SIMD-ONLY0-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY0-NEXT:  entry:
// SIMD-ONLY0-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY0-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY0-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@main
// SIMD-ONLY1-SAME: () #[[ATTR0:[0-9]+]] {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S:%.*]], align 8
// SIMD-ONLY1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S]], align 8
// SIMD-ONLY1-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// SIMD-ONLY1-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 16
// SIMD-ONLY1-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S]], align 8
// SIMD-ONLY1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]])
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC1ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]], ptr noundef nonnull align 8 dereferenceable(8) [[TTT]], double noundef 0.000000e+00)
// SIMD-ONLY1-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// SIMD-ONLY1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// SIMD-ONLY1-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_BEGIN]], double noundef 1.000000e+00)
// SIMD-ONLY1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYINIT_ELEMENT]], double noundef 2.000000e+00)
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC1Ed(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]], double noundef 3.000000e+00)
// SIMD-ONLY1-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY1-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// SIMD-ONLY1-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY1:       omp.inner.for.cond:
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2:![0-9]+]]
// SIMD-ONLY1-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// SIMD-ONLY1-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP2]]
// SIMD-ONLY1-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY1:       omp.inner.for.body:
// SIMD-ONLY1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// SIMD-ONLY1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY1-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    store i32 [[TMP4]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[ARRAYIDX2]], ptr align 8 [[VAR]], i64 8, i1 false), !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    store i32 33, ptr @_ZZ4mainE5sivar, align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY1:       omp.body.continue:
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY1:       omp.inner.for.inc:
// SIMD-ONLY1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP5]], 1
// SIMD-ONLY1-NEXT:    store i32 [[ADD3]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// SIMD-ONLY1:       omp.inner.for.end:
// SIMD-ONLY1-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY1-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// SIMD-ONLY1-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[VAR]]) #[[ATTR4:[0-9]+]]
// SIMD-ONLY1-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// SIMD-ONLY1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD-ONLY1:       arraydestroy.body:
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// SIMD-ONLY1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD-ONLY1:       arraydestroy.done4:
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TEST]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdED1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[TTT]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY1-NEXT:    ret i32 [[TMP7]]
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC1ERKS0_d
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load double, ptr [[T_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC2ERKS0_d(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], ptr noundef nonnull align 8 dereferenceable(8) [[TMP0]], double noundef [[TMP1]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC1Ed
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdEC2Ed(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]], double noundef [[TMP0]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// SIMD-ONLY1-SAME: () #[[ATTR3:[0-9]+]] {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[TTT:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// SIMD-ONLY1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0]], align 4
// SIMD-ONLY1-NEXT:    [[T_VAR:%.*]] = alloca i32, align 128
// SIMD-ONLY1-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// SIMD-ONLY1-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// SIMD-ONLY1-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S_0]], align 4
// SIMD-ONLY1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]])
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC1ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]], ptr noundef nonnull align 4 dereferenceable(4) [[TTT]], i32 noundef 0)
// SIMD-ONLY1-NEXT:    store i32 0, ptr [[T_VAR]], align 128
// SIMD-ONLY1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// SIMD-ONLY1-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// SIMD-ONLY1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]], i32 noundef 3)
// SIMD-ONLY1-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY1-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// SIMD-ONLY1-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY1:       omp.inner.for.cond:
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6:![0-9]+]]
// SIMD-ONLY1-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// SIMD-ONLY1-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP2]]
// SIMD-ONLY1-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY1:       omp.inner.for.body:
// SIMD-ONLY1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// SIMD-ONLY1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY1-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[T_VAR]], align 128, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    store i32 [[TMP4]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// SIMD-ONLY1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX2]], ptr align 4 [[VAR]], i64 4, i1 false), !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY1:       omp.body.continue:
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY1:       omp.inner.for.inc:
// SIMD-ONLY1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP5]], 1
// SIMD-ONLY1-NEXT:    store i32 [[ADD3]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// SIMD-ONLY1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// SIMD-ONLY1:       omp.inner.for.end:
// SIMD-ONLY1-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// SIMD-ONLY1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD-ONLY1:       arraydestroy.body:
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// SIMD-ONLY1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD-ONLY1:       arraydestroy.done4:
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TTT]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RETVAL]], align 4
// SIMD-ONLY1-NEXT:    ret i32 [[TMP7]]
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdED1Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIdED2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    store double 0.000000e+00, ptr [[F]], align 8
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdED2Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC2ERKS0_d
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[S:%.*]], double noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[T_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store double [[T]], ptr [[T_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[TMP0]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load double, ptr [[F2]], align 8
// SIMD-ONLY1-NEXT:    [[TMP2:%.*]] = load double, ptr [[T_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[ADD:%.*]] = fadd double [[TMP1]], [[TMP2]]
// SIMD-ONLY1-NEXT:    store double [[ADD]], ptr [[F]], align 8
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIdEC2Ed
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], double noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[A_ADDR:%.*]] = alloca double, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store double [[A]], ptr [[A_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load double, ptr [[A_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store double [[TMP0]], ptr [[F]], align 8
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC1ERKS0_i
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_ADDR]], align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC2ERKS0_i(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]], i32 noundef [[TMP1]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    store i32 0, ptr [[F]], align 4
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC2ERKS0_i
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[S:%.*]], i32 noundef [[T:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[T_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store i32 [[T]], ptr [[T_ADDR]], align 4
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[TMP0]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[F2]], align 4
// SIMD-ONLY1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[T_ADDR]], align 4
// SIMD-ONLY1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
// SIMD-ONLY1-NEXT:    store i32 [[ADD]], ptr [[F]], align 4
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD-ONLY1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD-ONLY1-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY1-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// SIMD-ONLY1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD-ONLY1-NEXT:  entry:
// SIMD-ONLY1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD-ONLY1-NEXT:    ret void
//
//
// SIMD-ONLY2-LABEL: define {{[^@]+}}@main
// SIMD-ONLY2-SAME: () #[[ATTR0:[0-9]+]] {
// SIMD-ONLY2-NEXT:  entry:
// SIMD-ONLY2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 1
// SIMD-ONLY2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY2-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 1 dereferenceable(1) [[REF_TMP]])
// SIMD-ONLY2-NEXT:    ret i32 0
//
//
// SIMD-ONLY3-LABEL: define {{[^@]+}}@main
// SIMD-ONLY3-SAME: () #[[ATTR1:[0-9]+]] {
// SIMD-ONLY3-NEXT:  entry:
// SIMD-ONLY3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD-ONLY3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD-ONLY3-NEXT:    [[TMP0:%.*]] = load ptr, ptr getelementptr inbounds ([[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr @__block_literal_global, i32 0, i32 3), align 8
// SIMD-ONLY3-NEXT:    call void [[TMP0]](ptr noundef @__block_literal_global)
// SIMD-ONLY3-NEXT:    ret i32 0
//
//
// SIMD-ONLY3-LABEL: define {{[^@]+}}@__main_block_invoke
// SIMD-ONLY3-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2:[0-9]+]] {
// SIMD-ONLY3-NEXT:  entry:
// SIMD-ONLY3-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY3-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY3-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY3-NEXT:    [[BLOCK:%.*]] = alloca <{ ptr, i32, i32, ptr, ptr, double, i32 }>, align 8
// SIMD-ONLY3-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// SIMD-ONLY3-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// SIMD-ONLY3-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY3-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY3-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY3-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// SIMD-ONLY3-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY3:       omp.inner.for.cond:
// SIMD-ONLY3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2:![0-9]+]]
// SIMD-ONLY3-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// SIMD-ONLY3-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP2]]
// SIMD-ONLY3-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY3:       omp.inner.for.body:
// SIMD-ONLY3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// SIMD-ONLY3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY3-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    store double 1.000000e+00, ptr @g, align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    store i32 11, ptr @_ZZ4mainE5sivar, align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_ISA:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 0
// SIMD-ONLY3-NEXT:    store ptr @_NSConcreteStackBlock, ptr [[BLOCK_ISA]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_FLAGS:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 1
// SIMD-ONLY3-NEXT:    store i32 1073741824, ptr [[BLOCK_FLAGS]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_RESERVED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 2
// SIMD-ONLY3-NEXT:    store i32 0, ptr [[BLOCK_RESERVED]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_INVOKE:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 3
// SIMD-ONLY3-NEXT:    store ptr @__main_block_invoke_2, ptr [[BLOCK_INVOKE]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_DESCRIPTOR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 4
// SIMD-ONLY3-NEXT:    store ptr @__block_descriptor_tmp.1, ptr [[BLOCK_DESCRIPTOR]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_CAPTURED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 5
// SIMD-ONLY3-NEXT:    [[TMP4:%.*]] = load volatile double, ptr @g, align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    store volatile double [[TMP4]], ptr [[BLOCK_CAPTURED]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[BLOCK_CAPTURED2:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[BLOCK]], i32 0, i32 6
// SIMD-ONLY3-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZZ4mainE5sivar, align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    store i32 [[TMP5]], ptr [[BLOCK_CAPTURED2]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr [[BLOCK]], i32 0, i32 3
// SIMD-ONLY3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    call void [[TMP7]](ptr noundef [[BLOCK]]), !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY3:       omp.body.continue:
// SIMD-ONLY3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY3:       omp.inner.for.inc:
// SIMD-ONLY3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// SIMD-ONLY3-NEXT:    store i32 [[ADD3]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// SIMD-ONLY3:       omp.inner.for.end:
// SIMD-ONLY3-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY3-NEXT:    ret void
//
//
// SIMD-ONLY3-LABEL: define {{[^@]+}}@__main_block_invoke_2
// SIMD-ONLY3-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2]] {
// SIMD-ONLY3-NEXT:  entry:
// SIMD-ONLY3-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY3-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY3-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// SIMD-ONLY3-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// SIMD-ONLY3-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 5
// SIMD-ONLY3-NEXT:    store double 2.000000e+00, ptr [[BLOCK_CAPTURE_ADDR]], align 8
// SIMD-ONLY3-NEXT:    [[BLOCK_CAPTURE_ADDR1:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, double, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 6
// SIMD-ONLY3-NEXT:    store i32 22, ptr [[BLOCK_CAPTURE_ADDR1]], align 8
// SIMD-ONLY3-NEXT:    ret void
//
//
// SIMD-ONLY4-LABEL: define {{[^@]+}}@_Z10array_funciPfP2St
// SIMD-ONLY4-SAME: (i32 noundef [[N:%.*]], ptr noundef [[A:%.*]], ptr noundef [[S:%.*]]) #[[ATTR0:[0-9]+]] {
// SIMD-ONLY4-NEXT:  entry:
// SIMD-ONLY4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// SIMD-ONLY4-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY4-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// SIMD-ONLY4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// SIMD-ONLY4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// SIMD-ONLY4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// SIMD-ONLY4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// SIMD-ONLY4-NEXT:    [[I:%.*]] = alloca i32, align 4
// SIMD-ONLY4-NEXT:    store i32 [[N]], ptr [[N_ADDR]], align 4
// SIMD-ONLY4-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// SIMD-ONLY4-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// SIMD-ONLY4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[N_ADDR]], align 4
// SIMD-ONLY4-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// SIMD-ONLY4-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY4-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// SIMD-ONLY4-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// SIMD-ONLY4-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP2]] to i32
// SIMD-ONLY4-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// SIMD-ONLY4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// SIMD-ONLY4:       omp.inner.for.cond:
// SIMD-ONLY4-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2:![0-9]+]]
// SIMD-ONLY4-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP3]] to i64
// SIMD-ONLY4-NEXT:    [[TMP4:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY4-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP4]]
// SIMD-ONLY4-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// SIMD-ONLY4:       omp.inner.for.body:
// SIMD-ONLY4-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP5]], 1
// SIMD-ONLY4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SIMD-ONLY4-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SIMD-ONLY4:       omp.body.continue:
// SIMD-ONLY4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// SIMD-ONLY4:       omp.inner.for.inc:
// SIMD-ONLY4-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], 1
// SIMD-ONLY4-NEXT:    store i32 [[ADD2]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// SIMD-ONLY4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// SIMD-ONLY4:       omp.inner.for.end:
// SIMD-ONLY4-NEXT:    store i32 10, ptr [[I]], align 4
// SIMD-ONLY4-NEXT:    ret void
//
