.ds q \N'34'
.TH RADEON __drivermansuffix__ __vendorversion__
.SH NAME
radeon \- ATI RADEON video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qradeon\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B radeon
is an __xservername__ driver for ATI RADEON-based video cards with the
following features:
.PP
.PD 0
.TP 2
\(bu
Full support for 8-, 15-, 16- and 24-bit pixel depths;
.TP
\(bu
RandR 1.2 and RandR 1.3 support;
.TP
\(bu
TV-out support (only on RV/RS1xx, RV/RS2xx, R/RV/RS3xx. Experimental
support on R/RV5xx, R/RV6xx, and R/RV7xx through the
.B ATOMTvOut
option);  TV-out is not supported on cards that use the Rage Theatre
chip for TV-out (R100, R200).
.TP
\(bu
Full EXA 2D acceleration;
.TP
\(bu
Full XAA 2D acceleration (only on R/RV/RS1xx, R/RV/RS2xx, R/RV/RS3xx,
R/RV/RS4xx, R/RV5xx, RS6xx. XAA Render acceleration supported only on R/RV100,
R/RV/RS2xx and RS3xx);
.TP
\(bu
Textured XVideo acceleration including anti-tearing support (Bicubic filtering
only available on R/RV3xx, R/RV/RS4xx, R/RV5xx, and RS6xx/RS740);
.TP
\(bu
Overlay XVideo acceleration (only on R/RV/RS1xx, R/RV/RS2xx,
R/RV/RS3xx, R/RV/RS4xx);
.TP
\(bu
3D acceleration;
.PD
.SH SUPPORTED HARDWARE
The
.B radeon
driver supports PCI, AGP, and PCIE video cards based on the following ATI chips
(note: list is non-exhaustive):
.PP
.PD 0
.TP 12
.B R100
Radeon 7200
.TP 12
.B RV100
Radeon 7000(VE), M6, RN50/ES1000
.TP 12
.B RS100
Radeon IGP320(M)
.TP 12
.B RV200
Radeon 7500, M7, FireGL 7800
.TP 12
.B RS200
Radeon IGP330(M)/IGP340(M)
.TP 12
.B RS250
Radeon Mobility 7000 IGP
.TP 12
.B R200
Radeon 8500, 9100, FireGL 8800/8700
.TP 12
.B RV250
Radeon 9000PRO/9000, M9
.TP 12
.B RV280
Radeon 9200PRO/9200/9200SE/9250, M9+
.TP 12
.B RS300
Radeon 9100 IGP
.TP 12
.B RS350
Radeon 9200 IGP
.TP 12
.B RS400/RS480
Radeon XPRESS 200(M)/1100 IGP
.TP 12
.B R300
Radeon 9700PRO/9700/9500PRO/9500/9600TX, FireGL X1/Z1
.TP 12
.B R350
Radeon 9800PRO/9800SE/9800, FireGL X2
.TP 12
.B R360
Radeon 9800XT
.TP 12
.B RV350
Radeon 9600PRO/9600SE/9600/9550, M10/M11, FireGL T2
.TP 12
.B RV360
Radeon 9600XT
.TP 12
.B RV370
Radeon X300, M22
.TP 12
.B RV380
Radeon X600, M24
.TP 12
.B RV410
Radeon X700, M26 PCIE
.TP 12
.B R420
Radeon X800 AGP
.TP 12
.B R423/R430
Radeon X800, M28 PCIE
.TP 12
.B R480/R481
Radeon X850 PCIE/AGP
.TP 12
.B RV505/RV515/RV516/RV550
Radeon X1300/X1400/X1500/X1550/X2300
.TP 12
.B R520
Radeon X1800
.TP 12
.B RV530/RV560
Radeon X1600/X1650/X1700
.TP 12
.B RV570/R580
Radeon X1900/X1950
.TP 12
.B RS600/RS690/RS740
Radeon X1200/X1250/X2100
.TP 12
.B R600
Radeon HD 2900
.TP 12
.B RV610/RV630
Radeon HD 2400/2600/2700/4200/4225/4250
.TP 12
.B RV620/RV635
Radeon HD 3410/3430/3450/3470/3650/3670
.TP 12
.B RV670
Radeon HD 3690/3850/3870
.TP 12
.B RS780/RS880
Radeon HD 3100/3200/3300/4100/4200/4250/4290
.TP 12
.B RV710/RV730
Radeon HD 4330/4350/4550/4650/4670/5145/5165/530v/545v/560v/565v
.TP 12
.B RV740/RV770/RV790
Radeon HD 4770/4730/4830/4850/4860/4870/4890
.TP 12
.B CEDAR
Radeon HD 5430/5450/6330/6350/6370
.TP 12
.B REDWOOD
Radeon HD 5550/5570/5650/5670/5730/5750/5770/6530/6550/6570
.TP 12
.B JUNIPER
Radeon HD 5750/5770/5830/5850/5870/6750/6770/6830/6850/6870
.TP 12
.B CYPRESS
Radeon HD 5830/5850/5870
.TP 12
.B HEMLOCK
Radeon HD 5970
.TP 12
.B PALM
Radeon HD 6310/6250
.TP 12
.B SUMO/SUMO2
Radeon HD 6370/6380/6410/6480/6520/6530/6550/6620
.TP 12
.B BARTS
Radeon HD 6790/6850/6870/6950/6970/6990
.TP 12
.B TURKS
Radeon HD 6570/6630/6650/6670/6730/6750/6770
.TP 12
.B CAICOS
Radeon HD 6430/6450/6470/6490
.TP 12
.B CAYMAN
Radeon HD 6950/6970/6990
.TP 12
.B ARUBA
.PD
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The driver auto\-detects all device information necessary to initialize
the card.  However, if you have problems with auto\-detection, you can
specify for UMS (Userspace Modesetting):
.PP
.RS 4
VideoRam \- in kilobytes
.br
MemBase  \- physical address of the linear framebuffer
.br
IOBase   \- physical address of the MMIO registers
.br
ChipID   \- PCI DEVICE ID
.RE
.PP
In addition, the following driver
.B Options
are supported for both
.B UMS
(Userspace Modesetting) and
.B KMS
(Kernel Modesetting):
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Enables or disables all hardware acceleration.
.br
The default is to
.B enable
hardware acceleration.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the RandR output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you must use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.BI "Option \*qEXAVSync\*q \*q" boolean \*q
This option attempts to avoid tearing by stalling the engine until the display
controller has passed the destination region.  It reduces tearing at the cost
of performance and has been known to cause instability on some chips.
The default is
.B off.

.PP
The following driver
.B Options
are supported for
.B KMS
(Kernel Modesetting):
.TP
.BI "Option \*qColorTiling\*q \*q" "boolean" \*q
The framebuffer can be addressed either in linear or tiled mode. Tiled mode can provide
significant performance benefits with 3D applications.  Tiling will be disabled if the drm
module is too old or if the current display configuration does not support it.  On R600+
this enables 1D tiling mode.
.br
The default value is
.B on
for R/RV3XX, R/RV4XX, R/RV5XX, RS6XX, RS740, R/RV6XX, R/RV7XX, RS780, RS880,
EVERGREEN, and CAYMAN and
.B off
for R/RV/RS1XX, R/RV/RS2XX, and RS3XX.
.TP
.BI "Option \*qColorTiling2D\*q \*q" "boolean" \*q
The framebuffer can be addressed either in linear, 1D, or 2D tiled modes. 2D tiled mode can
provide significant performance benefits over 1D tiling with 3D applications.  Tiling
will be disabled if the drm module is too old or if the current display configuration
does not support it. KMS ColorTiling2D is only supported on R600 and newer chips.
.br
The default value is
.B off
for R/RV6XX, R/RV7XX, RS780, RS880, EVERGREEN, and CAYMAN.
.TP
.BI "Option \*qEXAPixmaps\*q \*q" boolean \*q
Under KMS, to avoid thrashing pixmaps in/out of VRAM on low memory cards,
we use a heuristic based on VRAM amount to determine whether to allow EXA
to use VRAM for non-essential pixmaps.  This option allows us to override the
heuristic.  The default is
.B on
with > 32MB VRAM, off with < 32MB.
.TP
.BI "Option \*qSwapbuffersWait\*q \*q" boolean \*q
This option controls the behavior of glXSwapBuffers and glXCopySubBufferMESA
calls by GL applications.  If enabled, the calls will avoid tearing by making
sure the display scanline is outside of the area to be copied before the copy
occurs.  If disabled, no scanline synchronization is performed, meaning tearing
will likely occur.  Note that when enabled, this option can adversely affect
the framerate of applications that render frames at less than refresh rate.
.IP
The default value is
.B on.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable DRI2 page flipping.  The default is
.B on.
Pageflipping is supported on all radeon hardware.
.PP
The following driver
.B Options
are supported for
.B UMS
(Userspace Modesetting):
.TP
.BI "Option \*qDac6Bit\*q \*q" boolean \*q
Enables or disables the use of 6 bits per color component when in 8 bpp
mode (emulates VGA mode).  By default, all 8 bits per color component
are used.
.br
The default is
.B off.
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
This overrides the default pixel value for the YUV video overlay key.
.br
The default value is
.B 0x1E.
.TP
.BI "Option \*qScalerWidth\*q \*q" integer \*q
This sets the overlay scaler buffer width. Accepted values range from
1024 to 2048, divisible by 64.  Values other than 1536 and 1920 may
not make sense.  This should be set automatically, but no one knows
what the limit is for which chip. If you think quality is not optimal
when playing back HD video (with horizontal resolution larger than
this setting), increase this value.  If you get an empty area at the
right (usually pink), decrease it. Note that this only affects the "true"
overlay via Xv, and won't affect things like textured video.
.br
The default value is either 1536 (for most chips) or 1920.
.TP
.BI "Option \*qAGPMode\*q \*q" integer \*q
Set AGP data transfer rate.
(used only when DRI is enabled)
.br
1      \-\- 1x (before AGP v3 only)
.br
2      \-\- 2x (before AGP v3 only)
.br
4      \-\- 4x
.br
8      \-\- 8x (AGP v3 only)
.br
others \-\- invalid
.br
The default is to
.B leave it unchanged.
.TP
.BI "Option \*qAGPFastWrite\*q \*q" boolean \*q
Enable AGP fast writes.  Enabling this is frequently the cause of
instability. Used only when the DRI is enabled. If you enable
this option you will get *NO* support from developers.
.br
The default is
.B off.
.TP
.BI "Option \*qBusType\*q \*q" string \*q
Used to replace previous ForcePCIMode option.
Should only be used when driver's bus detection is incorrect
or you want to force an AGP card to PCI mode. You should NEVER force
a PCI card to AGP bus.
.br
PCI    \-\- PCI bus
.br
AGP    \-\- AGP bus
.br
PCIE   \-\- PCI Express bus
.br
(used only when DRI is enabled)
.br
The default is
.B auto detect.
.TP
.BI "Option \*qDisplayPriority\*q \*q" string \*q
.br
Used to prevent flickering or tearing problem caused by display buffer underflow.
.br
AUTO   \-\- Driver calculated (default).
.br
BIOS   \-\- Remain unchanged from BIOS setting.
          Use this if the calculation is not correct
          for your card.
.br
HIGH   \-\- Force to the highest priority.
          Use this if you have problem with above options.
          This may affect performance slightly.
.br
The default value is
.B AUTO.
.TP
.BI "Option \*qColorTiling\*q \*q" "boolean" \*q
The framebuffer can be addressed either in linear or tiled mode. Tiled mode can provide
significant performance benefits with 3D applications.  For 2D it shouldn't matter
much. Tiling will be disabled if the virtual x resolution exceeds 2048 (3968 for R300 
and above), or if DRI is enabled and the drm module is too old.
.br
If this option is enabled, a new DRI driver is required for direct rendering.
.br
Color tiling will be automatically disabled in interlaced or doublescan screen modes.
.br
The default value is
.B on.
.TP 
.BI "Option \*qIgnoreEDID\*q \*q" boolean \*q
Do not use EDID data for mode validation.  DDC is still used
for monitor detection. This is different from NoDDC option.
.br
The default value is
.B off.
.TP 
.BI "Option \*qCustomEDID\*q \*q" string \*q
Forces the X driver to use the EDID data specified in a file rather
than the display's EDID. Also overrides DDC monitor detection.
.br
You may specify a semicolon-separated list of output name and filename pairs
with an optional flag, "digital" or "analog", to override the digital bit in
the EDID which is used by the driver to determine whether to use the
analog or digital encoder associated with a DVI-I port.
The output name is the RandR output name, e.g., "VGA-0" or "DVI-0";
consult the Xorg log for the supported output names of any given system.
.br
The file must contain a raw 128-byte EDID block, as captured by
.B
get-edid.
.br
For example:
.B
Option \*qCustomEDID\*q \*qVGA-0:/tmp/edid1.bin; DVI-0:/tmp/edid2.bin:digital\*q
will assign the EDID from the file /tmp/edid1.bin to the output device
VGA-0, and the EDID from the file /tmp/edid2.bin to the output device
DVI-0 and force the DVI port to use the digital encoder.
.br
Note that an output name must always be specified,
even if only one EDID is specified.
.br
.B
Caution:
Specifying an EDID that doesn't exactly match your display may
damage your hardware, as it allows the driver to specify timings beyond
the capabilities of your display. Use with care.
.TP 
.BI "Option \*qPanelSize\*q \*q" "string" \*q
Should only be used when driver cannot detect the correct panel size.
Apply to both desktop (TMDS) and laptop (LVDS) digital panels.
When a valid panel size is specified, the timings collected from
DDC and BIOS will not be used. If you have a panel with timings
different from that of a standard VESA mode, you have to provide
this information through the Modeline.
.br
For example, Option "PanelSize" "1400x1050"
.br
The default value is
.B none.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable page flipping for 3D acceleration. This will increase performance
but not work correctly in some rare cases, hence the default is
.B off.
It is currently only supported on R/RV/RS4xx and older hardware.
.TP
.BI "Option \*qForceMinDotClock\*q \*q" frequency \*q
Override minimum dot clock. Some Radeon BIOSes report a minimum dot
clock unsuitable (too high) for use with television sets even when they
actually can produce lower dot clocks. If this is the case you can
override the value here.
.B Note that using this option may damage your hardware.
You have been warned. The
.B frequency
parameter may be specified as a float value with standard suffixes like
"k", "kHz", "M", "MHz".
.TP
.BI "Option \*qRenderAccel\*q \*q" boolean \*q
Enables or disables hardware Render acceleration.  It is supported on all
Radeon cards when using EXA acceleration and on Radeon R/RV/RS1xx,
R/RV/RS2xx and RS3xx when using XAA.  The default is to
.B enable
Render acceleration.
.TP
.BI "Option \*qAccelMethod\*q \*q" "string" \*q
Chooses between available acceleration architectures.  Valid options are
.B XAA
and
.B EXA.
XAA is the traditional acceleration architecture and support for it is very
stable.  EXA is a newer acceleration architecture with better performance for
the Render and Composite extensions.  The default is
.B EXA.
.TP
.BI "Option \*qAccelDFS\*q \*q" boolean \*q
Use or don't use accelerated EXA DownloadFromScreen hook when possible (only
when Direct Rendering is enabled, e.g.).
Default:
.B off
with AGP due to issues with GPU->host transfers with some AGP bridges,
.B on
otherwise.
.TP
.BI "Option \*qFBTexPercent\*q \*q" integer \*q
Amount of video RAM to reserve for OpenGL textures, in percent. With EXA, the
remainder of video RAM is reserved for EXA offscreen management. Specifying 0
results in all offscreen video RAM being reserved for EXA and only GART memory
being available for OpenGL textures. This may improve EXA performance, but
beware that it may cause problems with OpenGL drivers from Mesa versions older
than 6.4. With XAA, specifying lower percentage than what gets reserved without
this option has no effect, but the driver tries to increase the video RAM
reserved for textures to the amount specified roughly.
Default:
.B 50.
.TP
.BI "Option \*qDepthBits\*q \*q" integer \*q
Precision in bits per pixel of the shared depth buffer used for 3D acceleration.
Valid values are 16 and 24. When this is 24, there will also be a hardware
accelerated stencil buffer, but the combined depth/stencil buffer will take up
twice as much video RAM as when it's 16.
Default:
.B The same as the screen depth.
.TP
.BI "Option \*qDMAForXv\*q \*q" boolean \*q
Try or don't try to use DMA for Xv image transfers. This will reduce CPU
usage when playing big videos like DVDs, but may cause instabilities.
Default:
.B on.
.TP
.BI "Option \*qSubPixelOrder\*q \*q" "string" \*q
Force subpixel order to specified order.
Subpixel order is used for subpixel decimation on flat panels.
.br
NONE   \-\- No subpixel (CRT like displays)
.br
RGB    \-\- in horizontal RGB order (most flat panels)
.br
BGR    \-\- in horizontal BGR order (some flat panels)

.br
This option is intended to be used in following cases:
.br
1. The default subpixel order is incorrect for your panel.
.br
2. Enable subpixel decimation on analog panels.
.br
3. Adjust to one display type in dual-head clone mode setup.
.br
4. Get better performance with Render acceleration on
digital panels (use NONE setting).
.br
The default is 
.B NONE 
for CRT, 
.B RGB 
for digital panels
.TP
.BI "Option \*qClockGating\*q \*q" boolean \*q
Enable dynamic clock gating.  This can help reduce heat and increase battery
life by reducing power usage.  Some users report reduced 3D performance
with this enabled.  The default is
.B off.
.TP
.BI "Option \*qForceLowPowerMode\*q \*q" boolean \*q
Enable a static low power mode.  This can help reduce heat and increase battery
life by reducing power usage at the expense of performance. The default is
.B off.
.TP
.BI "Option \*qDynamicPM\*q \*q" boolean \*q
Enable dynamic power mode switching.  This can help reduce heat and increase battery
life by reducing power usage when the system is idle (DPMS active). The default is
.B off.
.TP
.BI "Option \*qVGAAccess\*q \*q" boolean \*q
Tell the driver if it can do legacy VGA IOs to the card. This is
necessary for properly resuming consoles when in VGA text mode, but
shouldn't be if the console is using radeonfb or some other graphic
mode driver. Some platforms like PowerPC have issues with those, and they aren't
necessary unless you have a real text mode in console. The default is
.B off
on PowerPC and SPARC and
.B on
on other architectures.
.TP
.BI "Option \*qReverseDDC\*q \*q" boolean \*q
When BIOS connector information isn't available, use this option to
reverse the mapping of the two main DDC ports. Use this if the X server
obviously detects the wrong display for each connector. This is
typically needed on the Radeon 9600 cards bundled with Apple G5s. The
default is
.B off.
.TP
.BI "Option \*qLVDSProbePLL\*q \*q" boolean \*q
When BIOS panel information isn't available (like on PowerBooks), it
may still be necessary to use the firmware-provided PLL values for the
panel or flickering will happen. This option will force probing of
the current value programmed in the chip when X is launched in that
case.  This is only useful for LVDS panels (laptop internal panels).
The default is
.B on.
.TP
.BI "Option \*qTVDACLoadDetect\*q \*q" boolean \*q
Enable load detection on the TV DAC.  The TV DAC is used to drive both
TV-out and analog monitors. Load detection is often unreliable in the
TV DAC so it is disabled by default.
The default is
.B off.
.TP
.BI "Option \*qDefaultTMDSPLL\*q \*q" boolean \*q
Use the default driver provided TMDS PLL values rather than the ones
provided by the BIOS. This option has no effect on Mac cards.  Enable
this option if you are having problems with a DVI monitor using the
internal TMDS controller.
The default is
.B off.
.TP
.BI "Option \*qDefaultTVDACAdj\*q \*q" boolean \*q
Use the default driver provided TVDAC Adj values rather than the ones
provided by the BIOS. This option has no effect on Mac cards.  Enable
this option if you are having problems with a washed out display on
the secondary DAC.
The default is
.B off.
.TP
.BI "Option \*qDRI\*q \*q" boolean \*q
Enable DRI support.  This option allows you to enable to disable the DRI.
The default is
.B off 
for RN50/ES1000 and
.B on 
for others.
.TP
.BI "Option \*qDefaultConnectorTable\*q \*q" boolean \*q
Enable this option to skip the BIOS connector table parsing and use the
driver defaults for each chip.
The default is
.B off 
.TP
.BI "Option \*qMacModel\*q \*q" string \*q
.br
Used to specify Mac models for connector tables and quirks.  If you have
a PowerBook or Mini with DVI that does not work properly, try the alternate
options as Apple does not seem to provide a good way of knowing whether
they use internal or external TMDS for DVI.  Only valid on PowerPC.
On Linux, the driver will attempt to detect the MacModel automatically.
.br
ibook                \-\- ibooks
.br
powerbook-external   \-\- Powerbooks with external DVI
.br
powerbook-internal   \-\- Powerbooks with integrated DVI
.br
powerbook-vga        \-\- Powerbooks with VGA rather than DVI
.br
mini-external        \-\- Mac Mini with external DVI
.br
mini-internal        \-\- Mac Mini with integrated DVI
.br
imac-g5-isight       \-\- iMac G5 iSight
.br
emac                 \-\- eMac G4
.br
sam440ep             \-\- SAM440ep embedded board
.br
The default value is
.B undefined.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
.br
Used to specify the default TV standard if you want to use something other than
the BIOS default. Valid options are:
.br
ntsc
.br
pal
.br
pal-m
.br
pal-60
.br
ntsc-j
.br
scart-pal
.br
The default value is
.B undefined.
.TP
.BI "Option \*qForceTVOut\*q \*q" boolean \*q
Enable this option to force TV-out to always be detected as attached.
The default is
.B off 
.TP
.BI "Option \*qIgnoreLidStatus\*q \*q" boolean \*q
Enable this option to ignore lid status on laptops and always detect
LVDS as attached.
The default is
.B on. 
.TP
.BI "Option \*qInt10\*q \*q" boolean \*q
This option allows you to disable INT10 initialization.  Set this to
False if you are experiencing a hang when initializing a secondary card.
The default is
.B on.
.TP 
.BI "Option \*qATOMTvOut\*q \*q" boolean \*q
This option enables experimental TV-out support for R/RV5xx, R/RV6xx, and R/RV7xx
AtomBIOS chips. TV-out is experimental and may not function on these chips as
well as hoped for.
The default is
.B off.
.TP 
.BI "Option \*qR4xxATOM\*q \*q" boolean \*q
This option enables modesetting on R/RV4xx chips using AtomBIOS.
The default is
.B off.

.SH TEXTURED VIDEO ATTRIBUTES
The driver supports the following X11 Xv attributes for Textured Video.
You can use the "xvattr" tool to query/set those attributes at runtime.

.TP
.BI "XV_VSYNC"
XV_VSYNC is used to control whether textured adapter synchronizes
the screen update to the monitor vertical refresh to eliminate tearing.
It has two values: 'off'(0) and 'on'(1). The default is
.B 'on'(1).

.TP
.BI "XV_CRTC"
XV_CRTC is used to control which display controller (crtc) the textured
adapter synchronizes the screen update with when XV_VSYNC is enabled.
The default, 'auto'(-1), will sync to the display controller that more
of the video is on; when this is ambiguous, the display controller associated
with the RandR primary output is preferred.  This attribute is useful for
things like clone mode where the user can best decide which display should be
synced.
The default is
.B 'auto'(-1).

.TP
.BI "XV_BICUBIC"
XV_BICUBIC is used to control whether textured adapter should apply
a bicubic filter to smooth the output. It has three values: 'off'(0), 'on'(1)
and 'auto'(2). 'off' means never apply the filter, 'on' means always apply
the filter and 'auto' means apply the filter only if the X and Y
sizes are scaled to more than double to avoid blurred output.  Bicubic
filtering is not currently compatible with other Xv attributes like hue,
contrast, and brightness, and must be disabled to use those attributes.
The default is
.B 'off'(0).

.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
Wiki page:
.RS 4
http://www.x.org/wiki/radeon
.RE
.IP " 2." 4
Overview about radeon development code:
.RS 4
http://cgit.freedesktop.org/xorg/driver/xf86-video-ati/
.RE
.IP " 3." 4
Mailing list:
.RS 4
http://lists.x.org/mailman/listinfo/xorg-driver-ati
.RE
.IP " 4." 4
IRC channel:
.RS 4
#radeon on irc.freenode.net
.RE
.IP " 5." 4
Query the bugtracker for radeon bugs:
.RS 4
https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/Radeon
.RE
.IP " 6." 4
Submit bugs & patches:
.RS 4
https://bugs.freedesktop.org/enter_bug.cgi?product=xorg&component=Driver/Radeon
.RE

.SH AUTHORS
.nf
Authors include:
Rickard E. (Rik) Faith   \fIfaith@precisioninsight.com\fP
Kevin E. Martin          \fIkem@freedesktop.org\fP
Alan Hourihane           \fIalanh@fairlite.demon.co.uk\fP
Marc Aurele La France    \fItsi@xfree86.org\fP
Benjamin Herrenschmidt   \fIbenh@kernel.crashing.org\fP
Michel D\(:anzer            \fImichel@daenzer.net\fP
Alex Deucher             \fIalexdeucher@gmail.com\fP
Bogdan D.                \fIbogdand@users.sourceforge.net\fP
Eric Anholt              \fIeric@anholt.net\fP
