#!/usr/bin/env python

#   This file is part of Compare-Mirrors - <http://github.com/joshuastrot/compare-mirrors>
#
#   Copyright Compare-Mirrors, Joshua Strot <joshuastrot@gmail.com>
#
#   Compare-Mirrors is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Compare-Mirrors is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Compare-Mirrors. If not, see <http://www.gnu.org/licenses/>.

def output(outFormat, configuration, versionDifferences):
    """
    Output the version differences. 
    """
    
    #Output format done here:
    if not outFormat:
        print("=> Version Changes")
    
        #Output all the versions in plain format
        for repository in configuration["Repositories"]:
            print("    => [" + repository + "] Version Changes")
            for packageName, packageVersions in versionDifferences[repository].items():
                print("        => %s-%s  ->  %s-%s" % (packageName, packageVersions[0], packageName, packageVersions[1]))
    elif outFormat == "yaml":
        # Yaml format:
        #Repository
        #    - Package name
        #        -Manjaro Version
        #        -Arch Version
        print("""# Output generated by compare-mirrors
# 
# Author: Joshua Strot
# URL: https://github.com/joshuastrot/compare-mirrors

        """)
        
        #Output in YAML format
        for repository in configuration["Repositories"]:
            print("\"" + repository + "\":")
            for packageName, packageVersions in versionDifferences[repository].items():
                print("    - \"" + packageName + "\":")
                print("        - \"" + packageVersions[0] + "\"")
                print("        - \"" + packageVersions[1] + "\"")
                
    elif outFormat == "csv":
        # CSV Format:
        #Package Name, Repository, Version One, Version Two
        
        #Output CSV titles
        print("\"Package Name\", \"Repository\", \"Manjaro Version\", \"Arch Version\"")
        
        #Output in YAML format
        for repository in configuration["Repositories"]:
            for packageName, packageVersions in versionDifferences[repository].items():
                print("\"%s\", \"%s\", \"%s\", \"%s\"" % (packageName, repository, packageVersions[0], packageVersions[1]))
                
                
                
                
