// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use cairo;
use gdk_pixbuf;
use gdk_sys;
use glib::translate::*;
use std::fmt;
use std::mem;
use CursorType;
use Display;

glib_wrapper! {
    pub struct Cursor(Object<gdk_sys::GdkCursor, CursorClass>);

    match fn {
        get_type => || gdk_sys::gdk_cursor_get_type(),
    }
}

impl Cursor {
    #[cfg_attr(feature = "v3_16", deprecated)]
    pub fn new(cursor_type: CursorType) -> Cursor {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(gdk_sys::gdk_cursor_new(cursor_type.to_glib())) }
    }

    pub fn new_for_display(display: &Display, cursor_type: CursorType) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gdk_sys::gdk_cursor_new_for_display(
                display.to_glib_none().0,
                cursor_type.to_glib(),
            ))
        }
    }

    pub fn new_from_name(display: &Display, name: &str) -> Option<Cursor> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gdk_sys::gdk_cursor_new_from_name(
                display.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    pub fn new_from_pixbuf(
        display: &Display,
        pixbuf: &gdk_pixbuf::Pixbuf,
        x: i32,
        y: i32,
    ) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gdk_sys::gdk_cursor_new_from_pixbuf(
                display.to_glib_none().0,
                pixbuf.to_glib_none().0,
                x,
                y,
            ))
        }
    }

    pub fn new_from_surface(display: &Display, surface: &cairo::Surface, x: f64, y: f64) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(gdk_sys::gdk_cursor_new_from_surface(
                display.to_glib_none().0,
                mut_override(surface.to_glib_none().0),
                x,
                y,
            ))
        }
    }

    pub fn get_cursor_type(&self) -> CursorType {
        unsafe { from_glib(gdk_sys::gdk_cursor_get_cursor_type(self.to_glib_none().0)) }
    }

    pub fn get_display(&self) -> Display {
        unsafe { from_glib_none(gdk_sys::gdk_cursor_get_display(self.to_glib_none().0)) }
    }

    pub fn get_image(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe { from_glib_full(gdk_sys::gdk_cursor_get_image(self.to_glib_none().0)) }
    }

    pub fn get_surface(&self) -> (Option<cairo::Surface>, f64, f64) {
        unsafe {
            let mut x_hot = mem::MaybeUninit::uninit();
            let mut y_hot = mem::MaybeUninit::uninit();
            let ret = from_glib_full(gdk_sys::gdk_cursor_get_surface(
                self.to_glib_none().0,
                x_hot.as_mut_ptr(),
                y_hot.as_mut_ptr(),
            ));
            let x_hot = x_hot.assume_init();
            let y_hot = y_hot.assume_init();
            (ret, x_hot, y_hot)
        }
    }
}

impl fmt::Display for Cursor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Cursor")
    }
}
