// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use libc;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use CellRenderer;
use CellRendererMode;
use TreePath;

glib_wrapper! {
    pub struct CellRendererToggle(Object<gtk_sys::GtkCellRendererToggle, gtk_sys::GtkCellRendererToggleClass, CellRendererToggleClass>) @extends CellRenderer;

    match fn {
        get_type => || gtk_sys::gtk_cell_renderer_toggle_get_type(),
    }
}

impl CellRendererToggle {
    pub fn new() -> CellRendererToggle {
        assert_initialized_main_thread!();
        unsafe {
            CellRenderer::from_glib_none(gtk_sys::gtk_cell_renderer_toggle_new()).unsafe_cast()
        }
    }
}

impl Default for CellRendererToggle {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
pub struct CellRendererToggleBuilder {
    activatable: Option<bool>,
    active: Option<bool>,
    inconsistent: Option<bool>,
    indicator_size: Option<i32>,
    radio: Option<bool>,
    cell_background: Option<String>,
    cell_background_rgba: Option<gdk::RGBA>,
    cell_background_set: Option<bool>,
    height: Option<i32>,
    is_expanded: Option<bool>,
    is_expander: Option<bool>,
    mode: Option<CellRendererMode>,
    sensitive: Option<bool>,
    visible: Option<bool>,
    width: Option<i32>,
    xalign: Option<f32>,
    xpad: Option<u32>,
    yalign: Option<f32>,
    ypad: Option<u32>,
}

impl CellRendererToggleBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> CellRendererToggle {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activatable) = self.activatable {
            properties.push(("activatable", activatable));
        }
        if let Some(ref active) = self.active {
            properties.push(("active", active));
        }
        if let Some(ref inconsistent) = self.inconsistent {
            properties.push(("inconsistent", inconsistent));
        }
        if let Some(ref indicator_size) = self.indicator_size {
            properties.push(("indicator-size", indicator_size));
        }
        if let Some(ref radio) = self.radio {
            properties.push(("radio", radio));
        }
        if let Some(ref cell_background) = self.cell_background {
            properties.push(("cell-background", cell_background));
        }
        if let Some(ref cell_background_rgba) = self.cell_background_rgba {
            properties.push(("cell-background-rgba", cell_background_rgba));
        }
        if let Some(ref cell_background_set) = self.cell_background_set {
            properties.push(("cell-background-set", cell_background_set));
        }
        if let Some(ref height) = self.height {
            properties.push(("height", height));
        }
        if let Some(ref is_expanded) = self.is_expanded {
            properties.push(("is-expanded", is_expanded));
        }
        if let Some(ref is_expander) = self.is_expander {
            properties.push(("is-expander", is_expander));
        }
        if let Some(ref mode) = self.mode {
            properties.push(("mode", mode));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width) = self.width {
            properties.push(("width", width));
        }
        if let Some(ref xalign) = self.xalign {
            properties.push(("xalign", xalign));
        }
        if let Some(ref xpad) = self.xpad {
            properties.push(("xpad", xpad));
        }
        if let Some(ref yalign) = self.yalign {
            properties.push(("yalign", yalign));
        }
        if let Some(ref ypad) = self.ypad {
            properties.push(("ypad", ypad));
        }
        glib::Object::new(CellRendererToggle::static_type(), &properties)
            .expect("object new")
            .downcast()
            .expect("downcast")
    }

    pub fn activatable(mut self, activatable: bool) -> Self {
        self.activatable = Some(activatable);
        self
    }

    pub fn active(mut self, active: bool) -> Self {
        self.active = Some(active);
        self
    }

    pub fn inconsistent(mut self, inconsistent: bool) -> Self {
        self.inconsistent = Some(inconsistent);
        self
    }

    pub fn indicator_size(mut self, indicator_size: i32) -> Self {
        self.indicator_size = Some(indicator_size);
        self
    }

    pub fn radio(mut self, radio: bool) -> Self {
        self.radio = Some(radio);
        self
    }

    pub fn cell_background(mut self, cell_background: &str) -> Self {
        self.cell_background = Some(cell_background.to_string());
        self
    }

    pub fn cell_background_rgba(mut self, cell_background_rgba: &gdk::RGBA) -> Self {
        self.cell_background_rgba = Some(cell_background_rgba.clone());
        self
    }

    pub fn cell_background_set(mut self, cell_background_set: bool) -> Self {
        self.cell_background_set = Some(cell_background_set);
        self
    }

    pub fn height(mut self, height: i32) -> Self {
        self.height = Some(height);
        self
    }

    pub fn is_expanded(mut self, is_expanded: bool) -> Self {
        self.is_expanded = Some(is_expanded);
        self
    }

    pub fn is_expander(mut self, is_expander: bool) -> Self {
        self.is_expander = Some(is_expander);
        self
    }

    pub fn mode(mut self, mode: CellRendererMode) -> Self {
        self.mode = Some(mode);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width(mut self, width: i32) -> Self {
        self.width = Some(width);
        self
    }

    pub fn xalign(mut self, xalign: f32) -> Self {
        self.xalign = Some(xalign);
        self
    }

    pub fn xpad(mut self, xpad: u32) -> Self {
        self.xpad = Some(xpad);
        self
    }

    pub fn yalign(mut self, yalign: f32) -> Self {
        self.yalign = Some(yalign);
        self
    }

    pub fn ypad(mut self, ypad: u32) -> Self {
        self.ypad = Some(ypad);
        self
    }
}

pub const NONE_CELL_RENDERER_TOGGLE: Option<&CellRendererToggle> = None;

pub trait CellRendererToggleExt: 'static {
    fn get_activatable(&self) -> bool;

    fn get_active(&self) -> bool;

    fn get_radio(&self) -> bool;

    fn set_activatable(&self, setting: bool);

    fn set_active(&self, setting: bool);

    fn set_radio(&self, radio: bool);

    fn get_property_inconsistent(&self) -> bool;

    fn set_property_inconsistent(&self, inconsistent: bool);

    fn get_property_indicator_size(&self) -> i32;

    fn set_property_indicator_size(&self, indicator_size: i32);

    fn connect_toggled<F: Fn(&Self, TreePath) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_activatable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_inconsistent_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_indicator_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_radio_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<CellRendererToggle>> CellRendererToggleExt for O {
    fn get_activatable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_cell_renderer_toggle_get_activatable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_active(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_cell_renderer_toggle_get_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_radio(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_cell_renderer_toggle_get_radio(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_activatable(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_cell_renderer_toggle_set_activatable(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_active(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_cell_renderer_toggle_set_active(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_radio(&self, radio: bool) {
        unsafe {
            gtk_sys::gtk_cell_renderer_toggle_set_radio(
                self.as_ref().to_glib_none().0,
                radio.to_glib(),
            );
        }
    }

    fn get_property_inconsistent(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"inconsistent\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `inconsistent` getter")
                .unwrap()
        }
    }

    fn set_property_inconsistent(&self, inconsistent: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"inconsistent\0".as_ptr() as *const _,
                Value::from(&inconsistent).to_glib_none().0,
            );
        }
    }

    fn get_property_indicator_size(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indicator-size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `indicator-size` getter")
                .unwrap()
        }
    }

    fn set_property_indicator_size(&self, indicator_size: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indicator-size\0".as_ptr() as *const _,
                Value::from(&indicator_size).to_glib_none().0,
            );
        }
    }

    fn connect_toggled<F: Fn(&Self, TreePath) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggled_trampoline<P, F: Fn(&P, TreePath) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            path: *mut libc::c_char,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            let path = from_glib_full(gtk_sys::gtk_tree_path_new_from_string(path));
            f(
                &CellRendererToggle::from_glib_borrow(this).unsafe_cast(),
                path,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggled\0".as_ptr() as *const _,
                Some(transmute(toggled_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_activatable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_activatable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            f(&CellRendererToggle::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activatable\0".as_ptr() as *const _,
                Some(transmute(notify_activatable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            f(&CellRendererToggle::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::active\0".as_ptr() as *const _,
                Some(transmute(notify_active_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_inconsistent_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_inconsistent_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            f(&CellRendererToggle::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inconsistent\0".as_ptr() as *const _,
                Some(transmute(
                    notify_inconsistent_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_indicator_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_indicator_size_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            f(&CellRendererToggle::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indicator-size\0".as_ptr() as *const _,
                Some(transmute(
                    notify_indicator_size_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_radio_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_radio_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkCellRendererToggle,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<CellRendererToggle>,
        {
            let f: &F = &*(f as *const F);
            f(&CellRendererToggle::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::radio\0".as_ptr() as *const _,
                Some(transmute(notify_radio_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for CellRendererToggle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "CellRendererToggle")
    }
}
