// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use gdk_pixbuf;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use std;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;
use AccelGroup;
use Align;
use Application;
use Bin;
use Buildable;
use Container;
use ResizeMode;
use Widget;
use WindowGroup;
use WindowPosition;
use WindowType;

glib_wrapper! {
    pub struct Window(Object<gtk_sys::GtkWindow, gtk_sys::GtkWindowClass, WindowClass>) @extends Bin, Container, Widget, @implements Buildable;

    match fn {
        get_type => || gtk_sys::gtk_window_get_type(),
    }
}

impl Window {
    pub fn new(type_: WindowType) -> Window {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(gtk_sys::gtk_window_new(type_.to_glib())).unsafe_cast() }
    }

    pub fn get_default_icon_list() -> Vec<gdk_pixbuf::Pixbuf> {
        assert_initialized_main_thread!();
        unsafe {
            FromGlibPtrContainer::from_glib_container(gtk_sys::gtk_window_get_default_icon_list())
        }
    }

    pub fn get_default_icon_name() -> Option<GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gtk_sys::gtk_window_get_default_icon_name()) }
    }

    pub fn list_toplevels() -> Vec<Widget> {
        assert_initialized_main_thread!();
        unsafe { FromGlibPtrContainer::from_glib_container(gtk_sys::gtk_window_list_toplevels()) }
    }

    pub fn set_auto_startup_notification(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            gtk_sys::gtk_window_set_auto_startup_notification(setting.to_glib());
        }
    }

    pub fn set_default_icon(icon: &gdk_pixbuf::Pixbuf) {
        assert_initialized_main_thread!();
        unsafe {
            gtk_sys::gtk_window_set_default_icon(icon.to_glib_none().0);
        }
    }

    pub fn set_default_icon_from_file<P: AsRef<std::path::Path>>(
        filename: P,
    ) -> Result<(), glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gtk_sys::gtk_window_set_default_icon_from_file(
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn set_default_icon_list(list: &[gdk_pixbuf::Pixbuf]) {
        assert_initialized_main_thread!();
        unsafe {
            gtk_sys::gtk_window_set_default_icon_list(list.to_glib_container().0);
        }
    }

    pub fn set_default_icon_name(name: &str) {
        assert_initialized_main_thread!();
        unsafe {
            gtk_sys::gtk_window_set_default_icon_name(name.to_glib_none().0);
        }
    }

    pub fn set_interactive_debugging(enable: bool) {
        assert_initialized_main_thread!();
        unsafe {
            gtk_sys::gtk_window_set_interactive_debugging(enable.to_glib());
        }
    }
}

#[derive(Clone, Default)]
pub struct WindowBuilder {
    accept_focus: Option<bool>,
    application: Option<Application>,
    attached_to: Option<Widget>,
    decorated: Option<bool>,
    default_height: Option<i32>,
    default_width: Option<i32>,
    deletable: Option<bool>,
    destroy_with_parent: Option<bool>,
    focus_on_map: Option<bool>,
    focus_visible: Option<bool>,
    gravity: Option<gdk::Gravity>,
    hide_titlebar_when_maximized: Option<bool>,
    icon: Option<gdk_pixbuf::Pixbuf>,
    icon_name: Option<String>,
    mnemonics_visible: Option<bool>,
    modal: Option<bool>,
    resizable: Option<bool>,
    role: Option<String>,
    screen: Option<gdk::Screen>,
    skip_pager_hint: Option<bool>,
    skip_taskbar_hint: Option<bool>,
    startup_id: Option<String>,
    title: Option<String>,
    transient_for: Option<Window>,
    type_: Option<WindowType>,
    type_hint: Option<gdk::WindowTypeHint>,
    urgency_hint: Option<bool>,
    window_position: Option<WindowPosition>,
    border_width: Option<u32>,
    child: Option<Widget>,
    resize_mode: Option<ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
}

impl WindowBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> Window {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref accept_focus) = self.accept_focus {
            properties.push(("accept-focus", accept_focus));
        }
        if let Some(ref application) = self.application {
            properties.push(("application", application));
        }
        if let Some(ref attached_to) = self.attached_to {
            properties.push(("attached-to", attached_to));
        }
        if let Some(ref decorated) = self.decorated {
            properties.push(("decorated", decorated));
        }
        if let Some(ref default_height) = self.default_height {
            properties.push(("default-height", default_height));
        }
        if let Some(ref default_width) = self.default_width {
            properties.push(("default-width", default_width));
        }
        if let Some(ref deletable) = self.deletable {
            properties.push(("deletable", deletable));
        }
        if let Some(ref destroy_with_parent) = self.destroy_with_parent {
            properties.push(("destroy-with-parent", destroy_with_parent));
        }
        if let Some(ref focus_on_map) = self.focus_on_map {
            properties.push(("focus-on-map", focus_on_map));
        }
        if let Some(ref focus_visible) = self.focus_visible {
            properties.push(("focus-visible", focus_visible));
        }
        if let Some(ref gravity) = self.gravity {
            properties.push(("gravity", gravity));
        }
        if let Some(ref hide_titlebar_when_maximized) = self.hide_titlebar_when_maximized {
            properties.push(("hide-titlebar-when-maximized", hide_titlebar_when_maximized));
        }
        if let Some(ref icon) = self.icon {
            properties.push(("icon", icon));
        }
        if let Some(ref icon_name) = self.icon_name {
            properties.push(("icon-name", icon_name));
        }
        if let Some(ref mnemonics_visible) = self.mnemonics_visible {
            properties.push(("mnemonics-visible", mnemonics_visible));
        }
        if let Some(ref modal) = self.modal {
            properties.push(("modal", modal));
        }
        if let Some(ref resizable) = self.resizable {
            properties.push(("resizable", resizable));
        }
        if let Some(ref role) = self.role {
            properties.push(("role", role));
        }
        if let Some(ref screen) = self.screen {
            properties.push(("screen", screen));
        }
        if let Some(ref skip_pager_hint) = self.skip_pager_hint {
            properties.push(("skip-pager-hint", skip_pager_hint));
        }
        if let Some(ref skip_taskbar_hint) = self.skip_taskbar_hint {
            properties.push(("skip-taskbar-hint", skip_taskbar_hint));
        }
        if let Some(ref startup_id) = self.startup_id {
            properties.push(("startup-id", startup_id));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        if let Some(ref transient_for) = self.transient_for {
            properties.push(("transient-for", transient_for));
        }
        if let Some(ref type_) = self.type_ {
            properties.push(("type", type_));
        }
        if let Some(ref type_hint) = self.type_hint {
            properties.push(("type-hint", type_hint));
        }
        if let Some(ref urgency_hint) = self.urgency_hint {
            properties.push(("urgency-hint", urgency_hint));
        }
        if let Some(ref window_position) = self.window_position {
            properties.push(("window-position", window_position));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        {
            if let Some(ref focus_on_click) = self.focus_on_click {
                properties.push(("focus-on-click", focus_on_click));
            }
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        glib::Object::new(Window::static_type(), &properties)
            .expect("object new")
            .downcast()
            .expect("downcast")
    }

    pub fn accept_focus(mut self, accept_focus: bool) -> Self {
        self.accept_focus = Some(accept_focus);
        self
    }

    pub fn application<P: IsA<Application>>(mut self, application: &P) -> Self {
        self.application = Some(application.clone().upcast());
        self
    }

    pub fn attached_to<P: IsA<Widget>>(mut self, attached_to: &P) -> Self {
        self.attached_to = Some(attached_to.clone().upcast());
        self
    }

    pub fn decorated(mut self, decorated: bool) -> Self {
        self.decorated = Some(decorated);
        self
    }

    pub fn default_height(mut self, default_height: i32) -> Self {
        self.default_height = Some(default_height);
        self
    }

    pub fn default_width(mut self, default_width: i32) -> Self {
        self.default_width = Some(default_width);
        self
    }

    pub fn deletable(mut self, deletable: bool) -> Self {
        self.deletable = Some(deletable);
        self
    }

    pub fn destroy_with_parent(mut self, destroy_with_parent: bool) -> Self {
        self.destroy_with_parent = Some(destroy_with_parent);
        self
    }

    pub fn focus_on_map(mut self, focus_on_map: bool) -> Self {
        self.focus_on_map = Some(focus_on_map);
        self
    }

    pub fn focus_visible(mut self, focus_visible: bool) -> Self {
        self.focus_visible = Some(focus_visible);
        self
    }

    pub fn gravity(mut self, gravity: gdk::Gravity) -> Self {
        self.gravity = Some(gravity);
        self
    }

    pub fn hide_titlebar_when_maximized(mut self, hide_titlebar_when_maximized: bool) -> Self {
        self.hide_titlebar_when_maximized = Some(hide_titlebar_when_maximized);
        self
    }

    pub fn icon(mut self, icon: &gdk_pixbuf::Pixbuf) -> Self {
        self.icon = Some(icon.clone());
        self
    }

    pub fn icon_name(mut self, icon_name: &str) -> Self {
        self.icon_name = Some(icon_name.to_string());
        self
    }

    pub fn mnemonics_visible(mut self, mnemonics_visible: bool) -> Self {
        self.mnemonics_visible = Some(mnemonics_visible);
        self
    }

    pub fn modal(mut self, modal: bool) -> Self {
        self.modal = Some(modal);
        self
    }

    pub fn resizable(mut self, resizable: bool) -> Self {
        self.resizable = Some(resizable);
        self
    }

    pub fn role(mut self, role: &str) -> Self {
        self.role = Some(role.to_string());
        self
    }

    pub fn screen(mut self, screen: &gdk::Screen) -> Self {
        self.screen = Some(screen.clone());
        self
    }

    pub fn skip_pager_hint(mut self, skip_pager_hint: bool) -> Self {
        self.skip_pager_hint = Some(skip_pager_hint);
        self
    }

    pub fn skip_taskbar_hint(mut self, skip_taskbar_hint: bool) -> Self {
        self.skip_taskbar_hint = Some(skip_taskbar_hint);
        self
    }

    pub fn startup_id(mut self, startup_id: &str) -> Self {
        self.startup_id = Some(startup_id.to_string());
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }

    pub fn transient_for<P: IsA<Window>>(mut self, transient_for: &P) -> Self {
        self.transient_for = Some(transient_for.clone().upcast());
        self
    }

    pub fn type_(mut self, type_: WindowType) -> Self {
        self.type_ = Some(type_);
        self
    }

    pub fn type_hint(mut self, type_hint: gdk::WindowTypeHint) -> Self {
        self.type_hint = Some(type_hint);
        self
    }

    pub fn urgency_hint(mut self, urgency_hint: bool) -> Self {
        self.urgency_hint = Some(urgency_hint);
        self
    }

    pub fn window_position(mut self, window_position: WindowPosition) -> Self {
        self.window_position = Some(window_position);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub const NONE_WINDOW: Option<&Window> = None;

pub trait GtkWindowExt: 'static {
    fn activate_default(&self) -> bool;

    fn activate_focus(&self) -> bool;

    fn activate_key(&self, event: &gdk::EventKey) -> bool;

    fn add_accel_group<P: IsA<AccelGroup>>(&self, accel_group: &P);

    fn add_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P);

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32);

    fn begin_resize_drag(
        &self,
        edge: gdk::WindowEdge,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    );

    fn close(&self);

    fn deiconify(&self);

    fn fullscreen(&self);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, screen: &gdk::Screen, monitor: i32);

    fn get_accept_focus(&self) -> bool;

    fn get_application(&self) -> Option<Application>;

    fn get_attached_to(&self) -> Option<Widget>;

    fn get_decorated(&self) -> bool;

    fn get_default_size(&self) -> (i32, i32);

    fn get_default_widget(&self) -> Option<Widget>;

    fn get_deletable(&self) -> bool;

    fn get_destroy_with_parent(&self) -> bool;

    fn get_focus(&self) -> Option<Widget>;

    fn get_focus_on_map(&self) -> bool;

    fn get_focus_visible(&self) -> bool;

    fn get_gravity(&self) -> gdk::Gravity;

    fn get_group(&self) -> Option<WindowGroup>;

    fn get_hide_titlebar_when_maximized(&self) -> bool;

    fn get_icon(&self) -> Option<gdk_pixbuf::Pixbuf>;

    fn get_icon_list(&self) -> Vec<gdk_pixbuf::Pixbuf>;

    fn get_icon_name(&self) -> Option<GString>;

    fn get_mnemonic_modifier(&self) -> gdk::ModifierType;

    fn get_mnemonics_visible(&self) -> bool;

    fn get_modal(&self) -> bool;

    fn get_position(&self) -> (i32, i32);

    fn get_resizable(&self) -> bool;

    fn get_role(&self) -> Option<GString>;

    fn get_size(&self) -> (i32, i32);

    fn get_skip_pager_hint(&self) -> bool;

    fn get_skip_taskbar_hint(&self) -> bool;

    fn get_title(&self) -> Option<GString>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_titlebar(&self) -> Option<Widget>;

    fn get_transient_for(&self) -> Option<Window>;

    fn get_type_hint(&self) -> gdk::WindowTypeHint;

    fn get_urgency_hint(&self) -> bool;

    fn get_window_type(&self) -> WindowType;

    fn has_group(&self) -> bool;

    fn has_toplevel_focus(&self) -> bool;

    fn iconify(&self);

    fn is_active(&self) -> bool;

    fn is_maximized(&self) -> bool;

    fn maximize(&self);

    fn mnemonic_activate(&self, keyval: u32, modifier: gdk::ModifierType) -> bool;

    fn move_(&self, x: i32, y: i32);

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn parse_geometry(&self, geometry: &str) -> bool;

    fn present_with_time(&self, timestamp: u32);

    fn propagate_key_event(&self, event: &gdk::EventKey) -> bool;

    fn remove_accel_group<P: IsA<AccelGroup>>(&self, accel_group: &P);

    fn remove_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P);

    fn resize(&self, width: i32, height: i32);

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn resize_to_geometry(&self, width: i32, height: i32);

    fn set_accept_focus(&self, setting: bool);

    fn set_application<P: IsA<Application>>(&self, application: Option<&P>);

    fn set_attached_to<P: IsA<Widget>>(&self, attach_widget: Option<&P>);

    fn set_decorated(&self, setting: bool);

    fn set_default<P: IsA<Widget>>(&self, default_widget: Option<&P>);

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn set_default_geometry(&self, width: i32, height: i32);

    fn set_default_size(&self, width: i32, height: i32);

    fn set_deletable(&self, setting: bool);

    fn set_destroy_with_parent(&self, setting: bool);

    fn set_focus<P: IsA<Widget>>(&self, focus: Option<&P>);

    fn set_focus_on_map(&self, setting: bool);

    fn set_focus_visible(&self, setting: bool);

    fn set_geometry_hints<P: IsA<Widget>>(
        &self,
        geometry_widget: Option<&P>,
        geometry: Option<&gdk::Geometry>,
        geom_mask: gdk::WindowHints,
    );

    fn set_gravity(&self, gravity: gdk::Gravity);

    fn set_has_user_ref_count(&self, setting: bool);

    fn set_hide_titlebar_when_maximized(&self, setting: bool);

    fn set_icon(&self, icon: Option<&gdk_pixbuf::Pixbuf>);

    fn set_icon_from_file<P: AsRef<std::path::Path>>(&self, filename: P)
        -> Result<(), glib::Error>;

    fn set_icon_list(&self, list: &[gdk_pixbuf::Pixbuf]);

    fn set_icon_name(&self, name: Option<&str>);

    fn set_keep_above(&self, setting: bool);

    fn set_keep_below(&self, setting: bool);

    fn set_mnemonic_modifier(&self, modifier: gdk::ModifierType);

    fn set_mnemonics_visible(&self, setting: bool);

    fn set_modal(&self, modal: bool);

    fn set_position(&self, position: WindowPosition);

    fn set_resizable(&self, resizable: bool);

    fn set_role(&self, role: &str);

    fn set_screen(&self, screen: &gdk::Screen);

    fn set_skip_pager_hint(&self, setting: bool);

    fn set_skip_taskbar_hint(&self, setting: bool);

    fn set_startup_id(&self, startup_id: &str);

    fn set_title(&self, title: &str);

    fn set_titlebar<P: IsA<Widget>>(&self, titlebar: Option<&P>);

    fn set_transient_for<P: IsA<Window>>(&self, parent: Option<&P>);

    fn set_type_hint(&self, hint: gdk::WindowTypeHint);

    fn set_urgency_hint(&self, setting: bool);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn set_wmclass(&self, wmclass_name: &str, wmclass_class: &str);

    fn stick(&self);

    fn unfullscreen(&self);

    fn unmaximize(&self);

    fn unstick(&self);

    fn get_property_default_height(&self) -> i32;

    fn set_property_default_height(&self, default_height: i32);

    fn get_property_default_width(&self) -> i32;

    fn set_property_default_width(&self, default_width: i32);

    fn get_property_has_toplevel_focus(&self) -> bool;

    fn get_property_is_active(&self) -> bool;

    fn get_property_is_maximized(&self) -> bool;

    fn get_property_type(&self) -> WindowType;

    fn get_property_window_position(&self) -> WindowPosition;

    fn set_property_window_position(&self, window_position: WindowPosition);

    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_default(&self);

    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_focus(&self);

    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_enable_debugging(&self, toggle: bool) -> bool;

    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_set_focus<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_accept_focus_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_attached_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_default_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_default_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_destroy_with_parent_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_focus_on_map_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_focus_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_gravity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_toplevel_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_hide_titlebar_when_maximized_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_mnemonics_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_role_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_skip_pager_hint_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_skip_taskbar_hint_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_transient_for_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_urgency_hint_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_window_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<Window>> GtkWindowExt for O {
    fn activate_default(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_activate_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn activate_focus(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_activate_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn activate_key(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_activate_key(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn add_accel_group<P: IsA<AccelGroup>>(&self, accel_group: &P) {
        unsafe {
            gtk_sys::gtk_window_add_accel_group(
                self.as_ref().to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
            );
        }
    }

    fn add_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P) {
        unsafe {
            gtk_sys::gtk_window_add_mnemonic(
                self.as_ref().to_glib_none().0,
                keyval,
                target.as_ref().to_glib_none().0,
            );
        }
    }

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32) {
        unsafe {
            gtk_sys::gtk_window_begin_move_drag(
                self.as_ref().to_glib_none().0,
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn begin_resize_drag(
        &self,
        edge: gdk::WindowEdge,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    ) {
        unsafe {
            gtk_sys::gtk_window_begin_resize_drag(
                self.as_ref().to_glib_none().0,
                edge.to_glib(),
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn close(&self) {
        unsafe {
            gtk_sys::gtk_window_close(self.as_ref().to_glib_none().0);
        }
    }

    fn deiconify(&self) {
        unsafe {
            gtk_sys::gtk_window_deiconify(self.as_ref().to_glib_none().0);
        }
    }

    fn fullscreen(&self) {
        unsafe {
            gtk_sys::gtk_window_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, screen: &gdk::Screen, monitor: i32) {
        unsafe {
            gtk_sys::gtk_window_fullscreen_on_monitor(
                self.as_ref().to_glib_none().0,
                screen.to_glib_none().0,
                monitor,
            );
        }
    }

    fn get_accept_focus(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_accept_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_application(&self) -> Option<Application> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_application(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_attached_to(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_attached_to(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_decorated(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_decorated(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_default_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            gtk_sys::gtk_window_get_default_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn get_default_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_default_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_deletable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_deletable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_destroy_with_parent(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_destroy_with_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_focus(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_focus_on_map(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_focus_on_map(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_focus_visible(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_focus_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_gravity(&self) -> gdk::Gravity {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_gravity(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_group(&self) -> Option<WindowGroup> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_group(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_hide_titlebar_when_maximized(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_hide_titlebar_when_maximized(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_icon(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe { from_glib_none(gtk_sys::gtk_window_get_icon(self.as_ref().to_glib_none().0)) }
    }

    fn get_icon_list(&self) -> Vec<gdk_pixbuf::Pixbuf> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(gtk_sys::gtk_window_get_icon_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_icon_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_mnemonic_modifier(&self) -> gdk::ModifierType {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_mnemonic_modifier(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_mnemonics_visible(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_mnemonics_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_modal(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_modal(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_position(&self) -> (i32, i32) {
        unsafe {
            let mut root_x = mem::MaybeUninit::uninit();
            let mut root_y = mem::MaybeUninit::uninit();
            gtk_sys::gtk_window_get_position(
                self.as_ref().to_glib_none().0,
                root_x.as_mut_ptr(),
                root_y.as_mut_ptr(),
            );
            let root_x = root_x.assume_init();
            let root_y = root_y.assume_init();
            (root_x, root_y)
        }
    }

    fn get_resizable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_role(&self) -> Option<GString> {
        unsafe { from_glib_none(gtk_sys::gtk_window_get_role(self.as_ref().to_glib_none().0)) }
    }

    fn get_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            gtk_sys::gtk_window_get_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn get_skip_pager_hint(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_skip_pager_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_skip_taskbar_hint(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_skip_taskbar_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_title(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_titlebar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_titlebar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_transient_for(&self) -> Option<Window> {
        unsafe {
            from_glib_none(gtk_sys::gtk_window_get_transient_for(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_type_hint(&self) -> gdk::WindowTypeHint {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_type_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_urgency_hint(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_urgency_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_window_type(&self) -> WindowType {
        unsafe {
            from_glib(gtk_sys::gtk_window_get_window_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_group(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_has_group(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_toplevel_focus(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_has_toplevel_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn iconify(&self) {
        unsafe {
            gtk_sys::gtk_window_iconify(self.as_ref().to_glib_none().0);
        }
    }

    fn is_active(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_is_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_maximized(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_is_maximized(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn maximize(&self) {
        unsafe {
            gtk_sys::gtk_window_maximize(self.as_ref().to_glib_none().0);
        }
    }

    fn mnemonic_activate(&self, keyval: u32, modifier: gdk::ModifierType) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_mnemonic_activate(
                self.as_ref().to_glib_none().0,
                keyval,
                modifier.to_glib(),
            ))
        }
    }

    fn move_(&self, x: i32, y: i32) {
        unsafe {
            gtk_sys::gtk_window_move(self.as_ref().to_glib_none().0, x, y);
        }
    }

    fn parse_geometry(&self, geometry: &str) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_parse_geometry(
                self.as_ref().to_glib_none().0,
                geometry.to_glib_none().0,
            ))
        }
    }

    fn present_with_time(&self, timestamp: u32) {
        unsafe {
            gtk_sys::gtk_window_present_with_time(self.as_ref().to_glib_none().0, timestamp);
        }
    }

    fn propagate_key_event(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_window_propagate_key_event(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn remove_accel_group<P: IsA<AccelGroup>>(&self, accel_group: &P) {
        unsafe {
            gtk_sys::gtk_window_remove_accel_group(
                self.as_ref().to_glib_none().0,
                accel_group.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P) {
        unsafe {
            gtk_sys::gtk_window_remove_mnemonic(
                self.as_ref().to_glib_none().0,
                keyval,
                target.as_ref().to_glib_none().0,
            );
        }
    }

    fn resize(&self, width: i32, height: i32) {
        unsafe {
            gtk_sys::gtk_window_resize(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn resize_to_geometry(&self, width: i32, height: i32) {
        unsafe {
            gtk_sys::gtk_window_resize_to_geometry(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_accept_focus(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_accept_focus(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_application<P: IsA<Application>>(&self, application: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_application(
                self.as_ref().to_glib_none().0,
                application.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_attached_to<P: IsA<Widget>>(&self, attach_widget: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_attached_to(
                self.as_ref().to_glib_none().0,
                attach_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_decorated(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_decorated(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_default<P: IsA<Widget>>(&self, default_widget: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_default(
                self.as_ref().to_glib_none().0,
                default_widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_default_geometry(&self, width: i32, height: i32) {
        unsafe {
            gtk_sys::gtk_window_set_default_geometry(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_default_size(&self, width: i32, height: i32) {
        unsafe {
            gtk_sys::gtk_window_set_default_size(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn set_deletable(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_deletable(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_destroy_with_parent(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_destroy_with_parent(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_focus<P: IsA<Widget>>(&self, focus: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_focus(
                self.as_ref().to_glib_none().0,
                focus.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_focus_on_map(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_focus_on_map(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_focus_visible(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_focus_visible(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_geometry_hints<P: IsA<Widget>>(
        &self,
        geometry_widget: Option<&P>,
        geometry: Option<&gdk::Geometry>,
        geom_mask: gdk::WindowHints,
    ) {
        unsafe {
            gtk_sys::gtk_window_set_geometry_hints(
                self.as_ref().to_glib_none().0,
                geometry_widget.map(|p| p.as_ref()).to_glib_none().0,
                mut_override(geometry.to_glib_none().0),
                geom_mask.to_glib(),
            );
        }
    }

    fn set_gravity(&self, gravity: gdk::Gravity) {
        unsafe {
            gtk_sys::gtk_window_set_gravity(self.as_ref().to_glib_none().0, gravity.to_glib());
        }
    }

    fn set_has_user_ref_count(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_has_user_ref_count(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_hide_titlebar_when_maximized(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_hide_titlebar_when_maximized(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_icon(&self, icon: Option<&gdk_pixbuf::Pixbuf>) {
        unsafe {
            gtk_sys::gtk_window_set_icon(self.as_ref().to_glib_none().0, icon.to_glib_none().0);
        }
    }

    fn set_icon_from_file<P: AsRef<std::path::Path>>(
        &self,
        filename: P,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gtk_sys::gtk_window_set_icon_from_file(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_icon_list(&self, list: &[gdk_pixbuf::Pixbuf]) {
        unsafe {
            gtk_sys::gtk_window_set_icon_list(
                self.as_ref().to_glib_none().0,
                list.to_glib_none().0,
            );
        }
    }

    fn set_icon_name(&self, name: Option<&str>) {
        unsafe {
            gtk_sys::gtk_window_set_icon_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn set_keep_above(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_keep_above(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_keep_below(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_keep_below(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_mnemonic_modifier(&self, modifier: gdk::ModifierType) {
        unsafe {
            gtk_sys::gtk_window_set_mnemonic_modifier(
                self.as_ref().to_glib_none().0,
                modifier.to_glib(),
            );
        }
    }

    fn set_mnemonics_visible(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_mnemonics_visible(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_modal(&self, modal: bool) {
        unsafe {
            gtk_sys::gtk_window_set_modal(self.as_ref().to_glib_none().0, modal.to_glib());
        }
    }

    fn set_position(&self, position: WindowPosition) {
        unsafe {
            gtk_sys::gtk_window_set_position(self.as_ref().to_glib_none().0, position.to_glib());
        }
    }

    fn set_resizable(&self, resizable: bool) {
        unsafe {
            gtk_sys::gtk_window_set_resizable(self.as_ref().to_glib_none().0, resizable.to_glib());
        }
    }

    fn set_role(&self, role: &str) {
        unsafe {
            gtk_sys::gtk_window_set_role(self.as_ref().to_glib_none().0, role.to_glib_none().0);
        }
    }

    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            gtk_sys::gtk_window_set_screen(self.as_ref().to_glib_none().0, screen.to_glib_none().0);
        }
    }

    fn set_skip_pager_hint(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_skip_pager_hint(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_skip_taskbar_hint(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_skip_taskbar_hint(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            gtk_sys::gtk_window_set_startup_id(
                self.as_ref().to_glib_none().0,
                startup_id.to_glib_none().0,
            );
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            gtk_sys::gtk_window_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_titlebar<P: IsA<Widget>>(&self, titlebar: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_titlebar(
                self.as_ref().to_glib_none().0,
                titlebar.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_transient_for<P: IsA<Window>>(&self, parent: Option<&P>) {
        unsafe {
            gtk_sys::gtk_window_set_transient_for(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_type_hint(&self, hint: gdk::WindowTypeHint) {
        unsafe {
            gtk_sys::gtk_window_set_type_hint(self.as_ref().to_glib_none().0, hint.to_glib());
        }
    }

    fn set_urgency_hint(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_window_set_urgency_hint(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_wmclass(&self, wmclass_name: &str, wmclass_class: &str) {
        unsafe {
            gtk_sys::gtk_window_set_wmclass(
                self.as_ref().to_glib_none().0,
                wmclass_name.to_glib_none().0,
                wmclass_class.to_glib_none().0,
            );
        }
    }

    fn stick(&self) {
        unsafe {
            gtk_sys::gtk_window_stick(self.as_ref().to_glib_none().0);
        }
    }

    fn unfullscreen(&self) {
        unsafe {
            gtk_sys::gtk_window_unfullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn unmaximize(&self) {
        unsafe {
            gtk_sys::gtk_window_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    fn unstick(&self) {
        unsafe {
            gtk_sys::gtk_window_unstick(self.as_ref().to_glib_none().0);
        }
    }

    fn get_property_default_height(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"default-height\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `default-height` getter")
                .unwrap()
        }
    }

    fn set_property_default_height(&self, default_height: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"default-height\0".as_ptr() as *const _,
                Value::from(&default_height).to_glib_none().0,
            );
        }
    }

    fn get_property_default_width(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"default-width\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `default-width` getter")
                .unwrap()
        }
    }

    fn set_property_default_width(&self, default_width: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"default-width\0".as_ptr() as *const _,
                Value::from(&default_width).to_glib_none().0,
            );
        }
    }

    fn get_property_has_toplevel_focus(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"has-toplevel-focus\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `has-toplevel-focus` getter")
                .unwrap()
        }
    }

    fn get_property_is_active(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"is-active\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `is-active` getter")
                .unwrap()
        }
    }

    fn get_property_is_maximized(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"is-maximized\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `is-maximized` getter")
                .unwrap()
        }
    }

    fn get_property_type(&self) -> WindowType {
        unsafe {
            let mut value = Value::from_type(<WindowType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `type` getter")
                .unwrap()
        }
    }

    fn get_property_window_position(&self) -> WindowPosition {
        unsafe {
            let mut value = Value::from_type(<WindowPosition as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"window-position\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `window-position` getter")
                .unwrap()
        }
    }

    fn set_property_window_position(&self, window_position: WindowPosition) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"window-position\0".as_ptr() as *const _,
                Value::from(&window_position).to_glib_none().0,
            );
        }
    }

    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_default_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-default\0".as_ptr() as *const _,
                Some(transmute(activate_default_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_default(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("activate-default", &[])
                .unwrap()
        };
    }

    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_focus_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-focus\0".as_ptr() as *const _,
                Some(transmute(activate_focus_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_focus(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("activate-focus", &[])
                .unwrap()
        };
    }

    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enable_debugging_trampoline<P, F: Fn(&P, bool) -> bool + 'static>(
            this: *mut gtk_sys::GtkWindow,
            toggle: glib_sys::gboolean,
            f: glib_sys::gpointer,
        ) -> glib_sys::gboolean
        where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Window::from_glib_borrow(this).unsafe_cast(),
                from_glib(toggle),
            )
            .to_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"enable-debugging\0".as_ptr() as *const _,
                Some(transmute(enable_debugging_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_enable_debugging(&self, toggle: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("enable-debugging", &[&toggle])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_enable_debugging`")
            .unwrap()
    }

    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn keys_changed_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"keys-changed\0".as_ptr() as *const _,
                Some(transmute(keys_changed_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_set_focus<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn set_focus_trampoline<P, F: Fn(&P, &Widget) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            object: *mut gtk_sys::GtkWidget,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Window::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"set-focus\0".as_ptr() as *const _,
                Some(transmute(set_focus_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_accept_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_focus_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accept-focus\0".as_ptr() as *const _,
                Some(transmute(
                    notify_accept_focus_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application\0".as_ptr() as *const _,
                Some(transmute(notify_application_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_attached_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attached_to_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attached-to\0".as_ptr() as *const _,
                Some(transmute(notify_attached_to_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_decorated_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::decorated\0".as_ptr() as *const _,
                Some(transmute(notify_decorated_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_default_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_height_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-height\0".as_ptr() as *const _,
                Some(transmute(
                    notify_default_height_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_default_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-width\0".as_ptr() as *const _,
                Some(transmute(
                    notify_default_width_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_deletable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::deletable\0".as_ptr() as *const _,
                Some(transmute(notify_deletable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_destroy_with_parent_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_destroy_with_parent_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::destroy-with-parent\0".as_ptr() as *const _,
                Some(transmute(
                    notify_destroy_with_parent_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_focus_on_map_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_on_map_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-on-map\0".as_ptr() as *const _,
                Some(transmute(
                    notify_focus_on_map_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_focus_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_visible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-visible\0".as_ptr() as *const _,
                Some(transmute(
                    notify_focus_visible_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_gravity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gravity_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gravity\0".as_ptr() as *const _,
                Some(transmute(notify_gravity_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_has_toplevel_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_toplevel_focus_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-toplevel-focus\0".as_ptr() as *const _,
                Some(transmute(
                    notify_has_toplevel_focus_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_hide_titlebar_when_maximized_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hide_titlebar_when_maximized_trampoline<
            P,
            F: Fn(&P) + 'static,
        >(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hide-titlebar-when-maximized\0".as_ptr() as *const _,
                Some(transmute(
                    notify_hide_titlebar_when_maximized_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon\0".as_ptr() as *const _,
                Some(transmute(notify_icon_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute(notify_icon_name_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_active_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-active\0".as_ptr() as *const _,
                Some(transmute(notify_is_active_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_is_maximized_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_maximized_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-maximized\0".as_ptr() as *const _,
                Some(transmute(
                    notify_is_maximized_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_mnemonics_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonics_visible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonics-visible\0".as_ptr() as *const _,
                Some(transmute(
                    notify_mnemonics_visible_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(transmute(notify_modal_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(transmute(notify_resizable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_role_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_role_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::role\0".as_ptr() as *const _,
                Some(transmute(notify_role_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_screen_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::screen\0".as_ptr() as *const _,
                Some(transmute(notify_screen_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_skip_pager_hint_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_skip_pager_hint_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::skip-pager-hint\0".as_ptr() as *const _,
                Some(transmute(
                    notify_skip_pager_hint_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_skip_taskbar_hint_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_skip_taskbar_hint_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::skip-taskbar-hint\0".as_ptr() as *const _,
                Some(transmute(
                    notify_skip_taskbar_hint_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_startup_id_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::startup-id\0".as_ptr() as *const _,
                Some(transmute(notify_startup_id_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute(notify_title_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_transient_for_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_transient_for_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transient-for\0".as_ptr() as *const _,
                Some(transmute(
                    notify_transient_for_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_type_hint_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::type-hint\0".as_ptr() as *const _,
                Some(transmute(notify_type_hint_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_urgency_hint_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_urgency_hint_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::urgency-hint\0".as_ptr() as *const _,
                Some(transmute(
                    notify_urgency_hint_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_window_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_position_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-position\0".as_ptr() as *const _,
                Some(transmute(
                    notify_window_position_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Window {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Window")
    }
}
