; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s

declare i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_add_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_and_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_or_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_xor_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_add_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_and_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_or_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_xor_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_add_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_add_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_and_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_and_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_or_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_or_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_xor_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_add_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_and_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_or_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_xor_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_add_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_and_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_or_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_xor_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_add_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_add_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_and_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_and_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_or_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_or_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_xor_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_add_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_umax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_smax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_umin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_smin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_and_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_or_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32>)

define i32 @vreduce_xor_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_add_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_umax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_smax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_umin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_smin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_and_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_or_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32>)

define i32 @vreduce_xor_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_add_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_add_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_umax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_smax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_umin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_smin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_and_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_and_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_or_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_or_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32>)

define i32 @vreduce_xor_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %red = call i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_add_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_add_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umax_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smax_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    sw zero, 8(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umin_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smin_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    addi a0, zero, -1
; CHECK-NEXT:    sw a0, 8(sp)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_and_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_and_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_or_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_or_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_xor_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_add_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_add_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umax_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smax_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    sw zero, 8(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umin_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smin_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    addi a0, zero, -1
; CHECK-NEXT:    sw a0, 8(sp)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_and_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_and_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_or_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_or_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_xor_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_add_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_add_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umax_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smax_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    sw zero, 8(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umin_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smin_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    addi a0, zero, -1
; CHECK-NEXT:    sw a0, 8(sp)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    sw a0, 12(sp)
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    addi a0, sp, 8
; CHECK-NEXT:    vlse64.v v25, (a0), zero
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_and_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_and_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_or_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_or_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_xor_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vmv.x.s a1, v25
; CHECK-NEXT:    ret
  %red = call i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}
