/* You can see the menus here are strongly influenced by copying the overall shape from how it’s done in src/menu.cc */

#include <ctype.h>

#include <FL/Fl_Window.H>
#include <FL/Fl.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/fl_draw.H>
#include "base_input.hh"

#include "../lout/msg.h"

typedef struct {
   const char *title;
   const Fl_Menu_Item *menu;
   const Fl_Menu_Item *picked;
   Fl_Widget_Tracker *tracker;
} Input_popup_data_t;

static void Input_replace_with_primary_cb(Fl_Widget*, void *user_data)
{
   BaseInput *i = (BaseInput *)user_data;
   i->value("");
   Fl::paste(*i, false);
}

static void Input_replace_with_clipboard_cb(Fl_Widget*, void *user_data)
{
   BaseInput *i = (BaseInput *)user_data;
   i->value("");
   Fl::paste(*i, true);
}

static void Input_paste_primary_cb(Fl_Widget*, void *user_data)
{
   Fl_Input *i = (Fl_Input *)user_data;
   Fl::paste(*i, false);
}

static void Input_paste_clipboard_cb(Fl_Widget*, void *user_data)
{
   Fl_Input *i = (Fl_Input *)user_data;
   Fl::paste(*i, true);
}

static void Input_clear_cb(Fl_Widget*, void *user_data)
{
   BaseInput *i = (BaseInput *)user_data;
   i->value("");
}

// As an experiment to see whether it’s useful when I see it in a menu and remember it’s there, as opposed to ^Z.
static void Input_undo_cb(Fl_Widget*, void *user_data)
{
   Fl_Input *i = (Fl_Input *)user_data;
   i->undo();
}

static void Input_popup_cb(void *data)
{
   const Fl_Menu_Item *picked;
   Input_popup_data_t *d = (Input_popup_data_t *) data;
   Fl_Widget *us = (Fl_Widget *)d->tracker->widget();


   if (us) {
      // survived the callback

      us->window()->cursor(FL_CURSOR_DEFAULT);
      Fl::pushed(0); // For long press.

      picked = d->menu->popup(Fl::event_x(), Fl::event_y(), d->title, d->picked);

      us = (Fl_Widget *)d->tracker->widget();
      if (us) {
         // survived the popup, which is the bigger challenge
         if (picked) {
            d->picked = picked;
            if (picked->callback()) {
               picked->do_callback((Fl_Widget *)(d->menu), us);
               Fl::focus(us);
            }
         }
      }
   }
   if (!us)
      MSG("The widget tracker saved us from deleted-input-widget disaster!\n");
}

/* virtual so we can clear it above in this class and have the right things happen in derived classes */
int BaseInput::value(const char *str)
{
   return Fl_Input::value(str);
}

/* Hiding down in Fl_Input_::expand(), control characters gain a careted appearance */
int BaseInput::textwidth()
{
   int width;
   const char *p;
   static char careted[3] = "^ ";

   fl_font(textfont(), textsize());
   width = (int)fl_width(value());

   for (p = value(); *p; p++) {
      if (iscntrl(*p)) {
         width -= fl_width(*p);
         careted[1] = *p ^ 0x40;
         width += fl_width(careted);
      }
   }
   return width;
}

void BaseInput::popup_menu()
{
   static Fl_Menu_Item pm[] = {
      {"Replace with primary", 0, Input_replace_with_primary_cb,0,0,0,0,0,0},
      {"Replace with clipboard", 0, Input_replace_with_clipboard_cb,0,0,0,0,0,0},
      {"Paste primary", 0, Input_paste_primary_cb,0,0,0,0,0,0},
      {"Paste clipboard", 0, Input_paste_clipboard_cb,0,0,0,0,0,0},
      {"Clear", 0, Input_clear_cb,0,0,0,0,0,0},
      {"Undo", 0, Input_undo_cb,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0}
   };
   static Input_popup_data_t input_data = {"Input menu", pm, NULL, NULL};

   if (input_data.tracker)
      delete input_data.tracker;
   input_data.tracker = new Fl_Widget_Tracker(this);

#if 0
   /* For now, if they’re all the same value, don’t bother. */

   pm[0].user_data(this);
   pm[1].user_data(this);
   pm[2].user_data(this);
   pm[3].user_data(this);
   pm[4].user_data(this);
   pm[5].user_data(this); // a theme seems to be developing
#endif

   Fl::add_timeout(0.0, Input_popup_cb, (void*)&input_data);
}

int BaseInput::handle(int e)
{
   if (e == FL_PUSH && Fl::event_button() == FL_RIGHT_MOUSE) {
      // reminder that BaseInput still has a pushed(0) due to still having an original-style menu. As of this writing, anyway.
      popup_menu();
      return 1;
   } else if (e == FL_KEYBOARD) {
      unsigned modifier = Fl::event_state() & (FL_SHIFT | FL_CTRL | FL_ALT);

      if (modifier == FL_CTRL) {
         int k = Fl::event_key();
         if (k == 'a' || k == 'e') {
            insert_position(k == 'a' ? 0 : size());
            return 1;
         } else if (k == 'k') {
            cut(insert_position(), size());
            return 1;
         } else if (k == 'd') {
            cut(insert_position(), insert_position()+1);
            return 1;
         }
      }
   }
   return Fl_Input::handle(e);
}

