#ifndef __BASE_INPUT__
#define __BASE_INPUT__

#include <FL/Fl_Input.H>

/*
 * 1. right-click/long-press menus
 * 2. insert_position() on FLTK 1.4 and above, position() on lower.
 * 3. the handful of classic Dillo EMACS-lineage key bindings of ^A ^E ^D ^K
 */

class BaseInput : public Fl_Input {
protected:
   void popup_menu();
public:
   BaseInput (int x, int y, int w, int h, const char *l = 0) : Fl_Input(x,y,w,h,l) {};
   virtual int value(const char *str);
   const char* value() const {return Fl_Input::value();} // the declaration above seemed to have shadowed the visibility of Fl_Input’s value()? :(
   int textwidth();
   int handle(int e);

#if FL_API_VERSION < 10400
   // In 1.4, position() became insert_position(), complete with compilation-filling deprecation warnings that make it impossible to see real warnings in the midst of it all.
   int insert_position() const { return position(); }
   int insert_position(int p) { return position(p); }
   int insert_position(int p, int m) { return position(p, m); }
#endif

};

#endif // __BASE_INPUT__
