/* Made by copying MenuInput and changing the affected widget */

#include <stdlib.h>

#include <FL/Fl_Window.H>
#include <FL/Fl.H>
#include <FL/Fl_Menu_Item.H>
#include "base_text_editor.hh"

#include "../lout/msg.h"

typedef struct {
   const char *title;
   const Fl_Menu_Item *menu;
   const Fl_Menu_Item *picked;
   Fl_Widget_Tracker *tracker;
} Text_Editor_popup_data_t;

BaseTextEditor::BaseTextEditor (int x, int y, int w, int h, const char *l = 0) : Fl_Text_Editor(x,y,w,h,l)
{
   buffer(new Fl_Text_Buffer());
   text_copy = NULL;
}

BaseTextEditor::~BaseTextEditor()
{
   Fl_Text_Buffer *buf = buffer();

   buffer(NULL);
   delete buf;

   if (text_copy)
      free(text_copy);
}

/*
 * Return the value (text) of the input.
 */
char* BaseTextEditor::value()
{
   /* FLTK-1.3 insists upon returning a new copy of the buffer text, so
    * we have to keep track of it.
    */
   if (text_copy)
      free(text_copy);
   text_copy = buffer()->text();
   return text_copy;
}


static void Text_Editor_replace_with_primary_cb(Fl_Widget*, void *user_data)
{
   BaseTextEditor *e = (BaseTextEditor *)user_data;
   e->value("");
   Fl::paste(*e, false);
}

static void Text_Editor_replace_with_clipboard_cb(Fl_Widget*, void *user_data)
{
   BaseTextEditor *e = (BaseTextEditor *)user_data;
   e->value("");
   Fl::paste(*e, true);
}

static void Text_Editor_paste_primary_cb(Fl_Widget*, void *user_data)
{
   Fl_Text_Editor *e = (Fl_Text_Editor *)user_data;
   Fl::paste(*e, false);
}

static void Text_Editor_paste_clipboard_cb(Fl_Widget*, void *user_data)
{
   Fl_Text_Editor *e = (Fl_Text_Editor *)user_data;
   Fl::paste(*e, true);
}

static void Text_Editor_clear_cb(Fl_Widget*, void *user_data)
{
   BaseTextEditor *e = (BaseTextEditor *)user_data;
   e->value("");
}

static void Text_Editor_popup_cb(void *data)
{
   const Fl_Menu_Item *picked;
   Text_Editor_popup_data_t *d = (Text_Editor_popup_data_t *) data;
   Fl_Widget *us = (Fl_Widget *)d->tracker->widget();

   if (us) {
      // survived the callback
      us->window()->cursor(FL_CURSOR_DEFAULT);

      picked = d->menu->popup(Fl::event_x(), Fl::event_y(), d->title, d->picked);

      us = (Fl_Widget *)d->tracker->widget();
      if (us) {
         // survived the popup, which is the bigger challenge
         if (picked) {
            d->picked = picked;
            if (picked->callback()) {
               picked->do_callback((Fl_Widget *)(d->menu), us);
               Fl::focus(us);
            }
         }
      }
   }
   if (!us)
      MSG("The widget tracker saved us from deleted-text-editor-widget disaster!\n");
}

void BaseTextEditor::value(const char *text)
{
   buffer()->text(text);
}

void BaseTextEditor::popup_menu()
{
   static Fl_Menu_Item pm[] = {
      {"Replace with primary", 0, Text_Editor_replace_with_primary_cb,0,0,0,0,0,0},
      {"Replace with clipboard", 0, Text_Editor_replace_with_clipboard_cb,0,0,0,0,0,0},
      {"Paste primary", 0, Text_Editor_paste_primary_cb,0,0,0,0,0,0},
      {"Paste clipboard", 0, Text_Editor_paste_clipboard_cb,0,0,0,0,0,0},
      {"Clear", 0, Text_Editor_clear_cb,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0}
   };
   static Text_Editor_popup_data_t text_editor_data = {"Text Editor menu", pm, NULL, NULL};

   if (text_editor_data.tracker)
      delete text_editor_data.tracker;
   text_editor_data.tracker = new Fl_Widget_Tracker(this);

#if 0
   /* For now, if they’re all the same value, don’t bother. */

   pm[0].user_data(this);
   pm[1].user_data(this);
   pm[2].user_data(this);
   pm[3].user_data(this);
   pm[4].user_data(this);   // a theme is developing
#endif

   Fl::add_timeout(0.0, Text_Editor_popup_cb, (void*)&text_editor_data);
}

int BaseTextEditor::handle(int e)
{
   if (e == FL_PUSH && Fl::event_button() == FL_RIGHT_MOUSE) {
      popup_menu();
      return 1;
   }
   return Fl_Text_Editor::handle(e);
}

