#ifndef __BASE_TEXT_EDITOR__
#define __BASE_TEXT_EDITOR__

#include <FL/Fl_Text_Editor.H>

class BaseTextEditor : public Fl_Text_Editor {
protected:
   char *text_copy;
   void popup_menu();
public:
   BaseTextEditor (int x, int y, int w, int h, const char *l);
   ~BaseTextEditor();
   char* value();
   virtual void value(const char *str);
   int handle(int e);
#if FL_API_VERSION < 10400
   // In 1.4, scrollbar_width() became scrollbar_size(), complete with compilation-filling deprecation warnings that make it impossible to see real warnings in the midst of it all.
   void scrollbar_size(int sz) { scrollbar_width(sz); }
   int scrollbar_size() const { return scrollbar_width(); }
#endif

};

#endif // __BASE_TEXT_EDITOR__
