#ifndef __DW_FLTKVIEWPORT_HH__
#define __DW_FLTKVIEWPORT_HH__

#include <FL/Fl_Group.H>
#include <FL/Fl_Scrollbar.H>

#include "core.hh"
#include "fltkcore.hh"
#include "fltkviewbase.hh"

namespace dw {
namespace fltk {

class FltkViewport: public FltkWidgetView
{
private:
   int SCROLLBAR_THICKNESS;

   int scrollX, scrollY;
   int scrollDX, scrollDY;
   int scrollbarOnLeft;

   int pushX, pushY;
   Fl_Widget *pushed_child;
   bool preventScrollbars;  // do we not want to see them right now?
   bool Hscrollable, Vscrollable;  // do we have enough page to scroll?

   enum { DISABLED, OFF, POTENTIAL, ACTIVE } dragScrollState;
   int dragThreshold, dragX, dragY;
   int horScrolling, verScrolling;

   Fl_Scrollbar *vscrollbar, *hscrollbar;

   void adjustScrollbarsAllocation ();
   void adjustScrollbarValues ();
   void hscrollbarChanged ();
   void vscrollbarChanged ();
   void determineContentBounds(int &boundsX, int &boundsY, int &boundsW, int &boundsH);
   void updateOverlayBounds();
   bool in_heart_of_widget();
   void positionChanged ();

   static void hscrollbarCallback (Fl_Widget *hscrollbar, void *viewportPtr);
   static void vscrollbarCallback (Fl_Widget *vscrollbar, void *viewportPtr);

   void selectionScroll();
   static void selectionScroll(void *vport);

   void updateCanvasWidgets (int oldScrollX, int oldScrollY);
   static void draw_area (void *data, int x, int y, int w, int h);

protected:
   int translateViewXToCanvasX (int x);
   int translateViewYToCanvasY (int y);
   int translateCanvasXToViewX (int x);
   int translateCanvasYToViewY (int y);
   void display_page_position();

public:
   FltkViewport (int x, int y, int w, int h, const char *label = 0);
   ~FltkViewport ();

   void resize(int x, int y, int w, int h);
   void draw ();
   int handle (int event);

   void setCanvasSize (int width, int ascent, int descent);

   bool usesViewport ();
   int getHScrollbarThickness ();
   int getVScrollbarThickness ();
   int getScrollbarOnLeft () {return scrollbarOnLeft; };
   void scroll(int dx, int dy);
   void scroll(dw::core::ScrollCommand cmd);
   void scrollTo (int x, int y);
   void setViewportSize (int width, int height,
                         int hScrollbarThickness, int vScrollbarThickness);
   void setScrollStep(int step);
   void setScrollThickness(int w);

   void setDragScroll (bool enable) { dragScrollState = enable ? OFF : DISABLED; }
   void setDragThreshold (int px) { dragThreshold = px; }
   void setScrollbarOnLeft (bool enable);
   void setOverlayLinkDest(const char *s);
   void setOverlayProgressMsg(const char *s, double proportion);
};

} // namespace fltk
} // namespace dw

#endif // __DW_FLTKVIEWPORT_HH__

