#ifndef __OVERLAY_WINDOW__
#define __OVERLAY_WINDOW__

#include <FL/Fl_Overlay_Window.H>

/*
 * These almost want to be classes, but it isn’t quite worthwhile. Their treatment in draw_overlay() is too different.
 */
typedef struct {
   char *str;
   int drawX, drawY, drawW, drawH;
} drawn_msg;

class OverlayWindow : public Fl_Overlay_Window {
private:
   drawn_msg link_dest, progress_msg;
   double progress;     // proportion between 0.0 and 1.0
   int boundsX, boundsY, boundsW, boundsH; // We can draw in this space
   int mouseX, mouseY; // Avoid drawing where the mouse cursor is.
protected:
   void draw_overlay();
public:
   OverlayWindow (int w, int h);
   ~OverlayWindow ();
   void set_overlay_link_dest(const char *s);
   void set_overlay_progress_msg(const char *s, double proportion);
   void update_overlay_bounds(int boundsX, int boundsY, int boundsW, int boundsH);
   void clear_entire_overlay();
   void clear_overlay_progress_msg();
   void mouse_moved(int x, int y);
};

#endif // __OVERLAY_WINDOW__
