#ifndef __PLACEHOLDER_EDITOR_HH__
#define __PLACEHOLDER_EDITOR_HH__

#include "base_text_editor.hh"

/*
 * Used to show optional placeholder text.
 */
class PlaceholderEditor : public BaseTextEditor {
public:
   PlaceholderEditor (int x, int y, int w, int h, const char* l=0);
   ~PlaceholderEditor ();
   void set_placeholder(const char *str);
   void show_placeholder();
   void show_normal(const char *str);
   void textcolor(Fl_Color c);
   void value(const char* str);
   char* value();
   bool empty();
   int handle(int e);
private:
   char *placeholder;
   bool showing_placeholder;
   Fl_Color usual_color;
};

#endif // __PLACEHOLDER_EDITOR_HH__
