#ifndef __PLACEHOLDER_INPUT__
#define __PLACEHOLDER_INPUT__

#include "base_input.hh"

/*
 * Used to show optional placeholder text.
 */
class PlaceholderInput : public BaseInput {
public:
   PlaceholderInput (int x, int y, int w, int h, const char* l=0);
   ~PlaceholderInput ();
   void set_placeholder(const char *str);
   int show_placeholder();
   int show_normal(const char *str);
   void textcolor(Fl_Color c);
   void input_type(int t);
   int value(const char* str);
   const char* value();
   int handle(int e);
private:
   char *placeholder;
   bool showing_placeholder;
   Fl_Color usual_color;
   int usual_type;
};

#endif // __PLACEHOLDER_INPUT__
