#ifndef __HTTP_H__
#define __HTTP_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "../url.h"

typedef enum {
   HTTP_Sec_Fetch_Dest_audio,
   HTTP_Sec_Fetch_Dest_document,
   HTTP_Sec_Fetch_Dest_embed,
   HTTP_Sec_Fetch_Dest_frame,
   HTTP_Sec_Fetch_Dest_iframe,
   HTTP_Sec_Fetch_Dest_image,
   HTTP_Sec_Fetch_Dest_object,
   HTTP_Sec_Fetch_Dest_style,
   HTTP_Sec_Fetch_Dest_video
} HttpSecFetchDest;

/*
 * External functions
 */
int a_Http_init(void);
extern void a_Http_freeall(void);
int a_Http_proxy_auth(void);
void a_Http_set_proxy_passwd(const char *str);

const char *a_Http_get_proxy_urlstr();
const char *a_Http_get_proxy_authstr();
const char *a_Http_get_language();

char *a_Http_get_referer(const DilloUrl *url);
const char *a_Http_sec_fetch_dest_str(HttpSecFetchDest dest);
const char *a_Http_sec_fetch_mode_str(HttpSecFetchDest dest, const DilloUrl *url, const DilloUrl *requester);
const char *a_Http_sec_fetch_site_str(const DilloUrl *url, const DilloUrl *requester);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __HTTP_H__ */
