/*
 * File: buttons.cc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include <FL/Fl.H>
#include <FL/Fl_Button.H>

#include "buttons.hh"
#include "prefs.h"

// --------------------- FocusAndEnterButton -----------------------
//
// Awkward name because those are its features: it can be triggered by pressing Enter, and it can be focused without drawing that box.

FocusAndEnterButton::FocusAndEnterButton(int x, int y, int w, int h, const char *l) : Fl_Button(x,y,w,h,l)
{
   selection_color(PREFS_UI_BUTTON_HIGHLIGHT_COLOR);
}

/* Had to mostly copy Fl_Button::draw to get rid of the focus box, since the
 * draw_focus() isn’t virtual. I suppose they figure Fl_Button::draw is small,
 * so just copy it. In which case, here we are.
 */
void FocusAndEnterButton::draw() {
  Fl_Color col = (Fl::focus() == this)  ? selection_color() : color();
  draw_box(value() ? (down_box()?down_box():fl_down(box())) : box(), col);
  draw_backdrop();
  if (labeltype() == FL_NORMAL_LABEL && value()) {
    Fl_Color c = labelcolor();
    labelcolor(fl_contrast(c, col));
    draw_label();
    labelcolor(c);
  } else draw_label();
}

int FocusAndEnterButton::handle(int event)
{
   if (event == FL_KEYBOARD) {
      if (Fl::event_key() == FL_Enter) {
         do_callback();
         return 1;
      }
   }

   return Fl_Button::handle(event);
}

