#ifndef __CACHE_H__
#define __CACHE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "fetchreq.h"
#include "client.hh"

/*
 * Flag Defines
 */
#define CA_GotHeaders      0x1  /* True after header is completely got */
#define CA_GotContentType  0x2  /* True after Content-Type is known */
#define CA_InProgress      0x4  /* True if we are getting data */
#define CA_Redirect        0x8  /* Data actually points to a redirect */
#define CA_RedirectLoop   0x10  /* Redirect loop */
#define CA_NotFound       0x20  /* True if remote server didn't find the URL */

/*
 * Function prototypes
 */
void a_Cache_init(void);
int a_Cache_open_url(ClientData *client, CA_Callback_t Call, void *CbData);
FetchReq *a_Cache_get_req(const DilloUrl *url);
void a_Cache_new_fetch(FetchReq *req);
int a_Cache_get_buf(const DilloUrl *Url, char **PBuf, int *BufSize);
char *a_Cache_get_referrer_policy_with_redirection(const DilloUrl *url);
uint_t a_Cache_get_flags(const DilloUrl *url);
uint_t a_Cache_get_flags_with_redirection(const DilloUrl *url);
void a_Cache_reply_header(const DilloUrl *url, const char *buf, size_t buf_size);
int a_Cache_reply_body(const DilloUrl *url, int Op, const char *buf, size_t buf_size);
void a_Cache_report_progress(const DilloUrl *url, size_t bytes_received, size_t content_length);
void a_Cache_freeall(void);
ClientData *a_Cache_client_get_if_unique(int Key);
void a_Cache_stop_client(int Key);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CACHE_H__ */

