#ifndef __CAPI_H__
#define __CAPI_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "cache.h"
#include "fetchreq.h"

#define IORead   0
#define IOWrite  1
#define IOClose  2
#define IOAbort  3

/*
 * Flag defines
 */
#define CAPI_IsCached       (0x1)
#define CAPI_Completed      (0x2)

/*
 * Function prototypes
 */
int a_Capi_open_url(ClientData *client, FetchReq *req, CA_Callback_t Call, void *CbData);
int a_Capi_get_buf(const DilloUrl *Url, char **PBuf, int *BufSize);
char *a_Capi_get_referrer_policy_with_redirection(const DilloUrl *url);
int a_Capi_get_flags(const DilloUrl *Url);
int a_Capi_get_flags_with_redirection(const DilloUrl *Url);
void a_Capi_stop_client(int Key, int force);

const DilloUrl *a_Capi_req_url(ulong_t req_id);
const FetchReq *a_Capi_req_info(ulong_t req_id);
void a_Capi_req_free(FetchReq *f);

void a_Capi_reply_header(ulong_t req_id, const char *buf, size_t buf_size);
int a_Capi_reply_body(ulong_t req_id, const char *buf, size_t buf_size);
void a_Capi_reply_finished(ulong_t req_id);
void a_Capi_reply_aborted(ulong_t req_id);
void a_Capi_report_progress(ulong_t req_id, size_t bytes_received, size_t content_length);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CAPI_H__ */

