
/* This was a file named web.cc, about something called a DilloWeb. It contained various bits needed for making a request and feeding it to the client (the html page, image, stylesheet). Why was it called a web? What did that signify? Is that like “widget” or “object” or “blob”? There was also CacheClient, which was wholly on the side of bits needed for feeding the client. Since they were pretty much much one thing, I glued them together into one thing. */

/*
 * File: web.cc
 *
 * Copyright 2005-2007 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include "msg.h"
#include "nav.h"

#include "client.hh"
#include "default.h"
#include "uicmd.hh"

#include "IO/mime.h"

#include "dw/core.hh"
#include "styleengine.hh"

// Platform independent part
using namespace dw::core;

/*
 * Given the MIME content type, and a fd to read it from,
 * this function connects the proper MIME viewer to it.
 * Return value:
 *    1 on success (and Call and Data properly set).
 *   -1 for unhandled MIME types (and Call and Data untouched).
 */
int a_Client_dispatch (const char *Type, ClientData *client,
                    CA_Callback_t *Call, void **Data)
{
   Widget *dw = NULL;

   _MSG("a_Client_dispatch\n");

   dReturn_val_if_fail(client->bw != NULL, -1);

   Layout *layout = (Layout*)client->bw->render_layout;

   Viewer_t viewer = (client->flags & CLIENT_Source) ? a_Plain_text : a_Mime_get_viewer(Type);

   if (client->flags & CLIENT_RootUrl) {
      /* We have RootUrl! */

      style::Color *bgColor = style::Color::create (layout, prefs.bg_color);
      client->bgColor = bgColor->getColor ();
      layout->setBgColor (bgColor);
      layout->setBgImage (NULL, style::BACKGROUND_REPEAT,
                          style::BACKGROUND_ATTACHMENT_SCROLL,
                          style::createPerLength (0),
                          style::createPerLength (0));

      /* Set a style for the widget */
      StyleEngine styleEngine (layout, client->url, client->url);
      styleEngine.startElement ("body", client->bw);

      if (!viewer)
         viewer = a_Default_viewer;
      dw = (Widget*) viewer(Type, client, Call, Data);

      if (dw) {
         dw->setStyle (styleEngine.style (client->bw));

         /* This method frees the old dw if any */
         layout->setWidget(dw);
      }
      /* Set the page title with the bare filename (e.g. for images),
       * HTML pages with a <TITLE> tag will overwrite it later */
      const char *p = strrchr(URL_STR(client->url), '/');
      a_UIcmd_set_page_title(client->bw, p ? p+1 : "");

      a_UIcmd_display_link_dest(client->bw, "");

      /* Let the Nav module know... */
      a_Nav_expect_done(client->bw);

   } else {
      /* A non-RootUrl. At this moment we only handle image-children */
      if (Type && viewer && !dStrnAsciiCasecmp(Type, "image/", 6)) {
         dw = (Widget*) viewer(Type, client, Call, Data);
      } else {
         MSG_WARN("'%s' cannot be displayed as image; has media type '%s'\n",
                  URL_STR(client->url), Type ? Type : "(none)");
      }
   }
   return (dw ? 1 : -1);
}


/*
 * Allocate and set safe values for a ClientData structure
 */
ClientData* a_Client_new(BrowserWindow *bw, const DilloUrl *url)
{
   ClientData *client= dNew(ClientData, 1);

   _MSG(" a_Client_new\n");
   client->url = a_Url_dup(url);
   client->bw = bw;
   client->flags = 0;
   client->Image = NULL;
   client->bgColor = 0x000000; /* Dummy value will be overwritten
                             * in a_Client_dispatch. */
   return client;
}

/*
 * Deallocate a ClientData structure
 */
void a_Client_free(ClientData *client)
{
   if (!client) return;
   a_Url_free(client->url);
   a_Image_unref(client->Image);
   _MSG("a_Client_free\n");
   dFree(client);
}

