#ifndef __WEB_H__
#define __WEB_H__

#include "url.h"
#include "bw.h"
#include "image.hh"

#define CLIENT_RootUrl  1
#define CLIENT_Source   2

#define CA_Send    (0)  /* Data (body) */
#define CA_Close   (1)  /* Successful operation close */
#define CA_Abort   (2)  /* Operation abort */

/*
 * Callback type for cache clients
 */
typedef void (*CA_Callback_t)(int Op, void *CbData, void *Buf, uint_t BufSize);

/* Html and plain know what to do based on bw, images need Image and bgColor, and style sheets work by having provided Callback and CbData. At the moment, url is needed for dicache. */
typedef struct {
   int Key;                 /* Primary Key for this client */
   DilloUrl *url;        /* Requested URL [reference] */
   BrowserWindow *bw;          /* The requesting browser window [reference] */
   int flags;                  /* Additional info */
   int RedirectLevel;
   DilloImage *Image;          /* For image urls [reference] */
   int32_t bgColor;            /* for image backgrounds */
   CA_Callback_t Callback;  /* Client function */
   void *CbData;            /* Client function data */
} ClientData;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void a_Client_init(void);
ClientData* a_Client_new (BrowserWindow *bw, const DilloUrl* url);
void a_Client_free (ClientData*);
int a_Client_dispatch (const char *Type, ClientData *client,
                    CA_Callback_t *Call, void **Data);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __WEB_H__ */
