
/* CustGroupHorizontal and CustGroupVertical pulled out of ui.hh for the use of findbar as well */

/*
 * Each child is above/below or beside the others. Making a vertical group and initially placing two child buttons next to each other isn’t going to work (put them in a group instead).
 */

  /* #include <FL/Fl_Group.H> */
#include "custgroup.hh"
#include "msg.h"

CustGroupHorizontal::CustGroupHorizontal(int x,int y,int w ,int h,const char *l) :
    Fl_Group(x,y,w,h,l) { }

void CustGroupHorizontal::resize(int X, int Y, int W, int H)
{
   // When resizable is not the first child, Fl_Group can resize those early children in unwanted ways.
    Fl_Widget::resize(X, Y, W, H);
    rearrange();
}

int CustGroupHorizontal::resizable_width()
{
   Fl_Widget*const* a = array();
   int sum = 0;
   int children_ = children();

   for (int i=0; i < children_; i++) {
      if (a[i] != resizable() && a[i]->visible())
         sum += a[i]->w();
   }
   return (w() > sum) ? w() - sum : 0;
}

void CustGroupHorizontal::rearrange()
{
   Fl_Widget*const* a = array();
   int i, _x = x();
   int children_ = children();

   if (resizable() == this) {       // spread them out
      int visible_children = 0;
      for (i = 0; i < children_; i++)
         if (a[i]->visible())
            visible_children++;
      if (visible_children == 1) {  //center it
         while (!a[i]->visible())
            i++;
         a[i]->resize(resizable_width()/2, y(), a[i]->w(), h());
      } else if (visible_children > 1) {
         int gap_size, available_space = resizable_width();

         for (i = 0; i < children_; i++) {
            a[i]->resize(_x, y(), a[i]->w(), h());
            if (a[i]->visible()) {
               visible_children--;
               gap_size = visible_children ? (available_space + visible_children - 1) / visible_children : 0;
               _x += a[i]->w() + gap_size;
               available_space -= gap_size;
            }
         }
      }
   } else {
      for (int i=0; i < children_; i++) {
         if (a[i] == resizable()) {
            a[i]->resize(_x, y(), resizable_width(), h());
         } else {
            a[i]->resize(_x, y(), a[i]->w(), h());
         }
         if (a[i]->visible())
            _x += a[i]->w();
//     printf("horz child %d now x %d y %d w %d h %d\n", i, a[i]->x(), a[i]->y(), a[i]->w(), a[i]->h());
      }
   }
   init_sizes();
   redraw();
}


CustGroupVertical::CustGroupVertical(int x,int y,int w ,int h,const char *l) :
    Fl_Group(x,y,w,h,l) { }

void CustGroupVertical::resize(int X, int Y, int W, int H)
{
   // When resizable is not the first child, Fl_Group can resize those early children in unwanted ways.
   Fl_Widget::resize(X, Y, W, H);
   rearrange();
}

void CustGroupVertical::rearrange()
{
   Fl_Widget*const* a = array();
   int sum = 0, _y = y();
   int children_ = children();

   for (int i=0; i < children_; i++) {
//      printf("vert child %d was x %d y %d w %d h %d\n", i, a[i]->x(), a[i]->y(), a[i]->w(), a[i]->h());
      if (a[i] != resizable() && a[i]->visible())
         sum += a[i]->h();
   }

   for (int i=0; i < children_; i++) {
      if (a[i] == resizable()) {
         if (h() > sum) {
            a[i]->resize(x(), _y, w(), h()-sum);
         } else {
            /* widgets overflow height */
            a[i]->resize(x(), _y, w(), 0);
         }
      } else {
         a[i]->resize(x(), _y, w(), a[i]->h());
      }
      if (a[i]->visible())
         _y += a[i]->h();
//     printf("vert child %d now x %d y %d w %d h %d\n", i, a[i]->x(), a[i]->y(), a[i]->w(), a[i]->h());
   }
   init_sizes();
   redraw();
}

