#ifndef __CUSTGROUP_HH__
#define __CUSTGROUP_HH__

/* CustGroupHorizontal and CustGroupVertical pulled out of ui.hh for the use of findbar as well */

#include <FL/Fl_Group.H>

/*
 * Used to reposition group's widgets when some of them are hidden.
 * All children get the height of the group but retain their original width.
 * The resizable child get's the remaining space.
 */
class CustGroupHorizontal : public Fl_Group {
public:
  CustGroupHorizontal(int x, int y, int w, int h, const char *l = 0);
  int resizable_width();
  void resize(int X, int Y, int W, int H);
  void rearrange();
};

class CustGroupVertical : public Fl_Group {
public:
  CustGroupVertical(int x, int y, int w, int h, const char *l = 0);
  void resize(int X, int Y, int W, int H);
  void rearrange();
};

#endif // __CUSTGROUP_HH__
