#include "default.h"
#include "client.hh"    /* Operations such as CA_Close */
#include "IO/mime.h"  /* the surprising location of a_Plain_text() declaration */

typedef struct {
   CA_Callback_t callback;
   void *data;
   bool_t fed_plain;
   Dstr *our_message;
} DefaultViewer;

static void Default_callback(int Op, void *CbData, void *Buf, uint_t BufSize)
{
   DefaultViewer *def = (DefaultViewer *)CbData;

   if (Op == CA_Close)
      dStr_append(def->our_message, "\n\n…Finished receiving.");

   if (Op || !def->fed_plain) {
      if (Op && !BufSize) {
         /* The file was empty, or aborted before receiving any body. Don’t print a message. */
         dStr_truncate(def->our_message, 0);
      }
      def->callback(Op, def->data, def->our_message->str, def->our_message->len);
      def->fed_plain = TRUE;
   }

   if (Op) {
      dStr_free(def->our_message, 1);
      dFree(def);
   }
}

void *a_Default_viewer(const char *Type, void *vclient, CA_Callback_t *Call, void **Data)
{
   DefaultViewer *def = dNew0(DefaultViewer, 1);

   if (Type) {
      def->our_message = dStr_new("");
      dStr_sprintf(def->our_message, "Can’t display file.\nType: %s", Type);
   } else {
      def->our_message = dStr_new("Unknown file type. Can’t display.");
   }
   dStr_append(def->our_message, "\n\nBut you can still\nsave it\nor stop it\nor perhaps view source.");
   *Call = Default_callback;
   *Data = def;

   return a_Plain_text("text/plain", vclient, &def->callback, &def->data);
}
