#include "fetchreq.h"

static Dlist *active_reqs;

FetchReq *a_FetchReq_official(FetchReq *req)
{
   static ulong_t ID = 0;

   FetchReq *r2 = dNew(FetchReq, 1);
   r2->id = ++ID;
   r2->url = a_Url_dup(req->url);
   r2->referrer = a_Url_dup(req->referrer);
   r2->referrerpolicy = req->referrerpolicy;
   r2->sec_fetch_dest = req->sec_fetch_dest;
   r2->user_saw_url = req->user_saw_url;
   return r2;
}

static int FetchReq_by_id(const void *v1, const void *v2)
{
   ulong_t id1 = ((const FetchReq *)v1)->id;
   ulong_t id2 = (ulong_t)v2;

   return id1 == id2 ? 0 : id1 < id2 ? -1 : 1;
}

const DilloUrl *a_FetchReq_url(ulong_t req_id)
{
   const FetchReq *f = dList_find_sorted(active_reqs, (void*)req_id, FetchReq_by_id);

   return f ? f->url : NULL;
}

const FetchReq *a_FetchReq_get(ulong_t req_id)
{
   return dList_find_sorted(active_reqs, (void*)req_id, FetchReq_by_id);

}

void a_FetchReq_activate(FetchReq *f)
{
   dList_insert_sorted(active_reqs, f, FetchReq_by_id);
}

void a_FetchReq_deactivate(const FetchReq *f)
{
   dList_remove(active_reqs, f);
}

void a_FetchReq_free(FetchReq *f)
{
   if (f) {
      a_Url_free((DilloUrl*)f->url);
      a_Url_free((DilloUrl*)f->referrer);
      dFree(f);
   }
}

void a_FetchReq_init()
{
   active_reqs = dList_new(32);
}

void a_FetchReq_freeall()
{
   dList_free(active_reqs);
}
