#ifndef __FETCHREQ_H__
#define __FETCHREQ_H__

#include "url.h"
#include "referrer.h"
#include "IO/http.h"

typedef struct {
   ulong_t id;
   const DilloUrl *url;
   const DilloUrl *referrer;
   ReferrerPolicyType referrerpolicy;
   HttpSecFetchDest sec_fetch_dest;
   bool_t user_saw_url;
} FetchReq;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

FetchReq *a_FetchReq_official(FetchReq *req);       // make a proper FetchReq struct with a proper ID because we will use it for a real fetch
const DilloUrl *a_FetchReq_url(ulong_t req_id);     // if you don’t need the whole struct
const FetchReq *a_FetchReq_get(ulong_t req_id);
void a_FetchReq_activate(FetchReq *f);              // using for a real fetch now (kept in a list)
void a_FetchReq_deactivate(const FetchReq *f);      // out of the list (but not freed, as it will continue an afterlife on a cache entry in case we ever need it again [e.g. for reloads])
void a_FetchReq_free(FetchReq *f);

void a_FetchReq_init();
void a_FetchReq_freeall();

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __FETCHREQ_H__ */
