#ifndef __FINDBAR_HH__
#define __FINDBAR_HH__

#include <FL/Fl_Widget.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Toggle_Button.H>

#include "tipwin.hh"
#include "custgroup.hh"
#include "menuinput.hh"

/*
 * Searchbar to find text in page.
 */
class Findbar : public CustGroupVertical {
   CustGroupHorizontal *row1, *row2;
   CustButton *hide_btn, *next_btn, *prev_btn;
   Fl_Toggle_Button *case_btn;
   MenuInput *i;
   const int original_height;

   static void search_cb (Fl_Widget *, void *);
   static void searchBackwards_cb (Fl_Widget *, void *);
   static void hide_cb (Fl_Widget *, void *);
   static void input_cb (Fl_Widget *, void *);

   void check_input_fit();
public:
   Findbar(int width, int height, int min_button_w_px);
   int handle(int event);
   void resize(int x, int y, int w, int h);
   void show();
};

#endif // __FINDBAR_HH__
