/*
 * File: html.hh
 *
 * Copyright (C) 2005-2009 Jorge Arellano Cid <jcid@dillo.org>
 * Copyright (C) 2024 Rodrigo Arias Mallo <rodarima@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */
#ifndef __HTML_HH__
#define __HTML_HH__

#include "url.h"               // for DilloUrl
#include "referrer.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Keep in sync with the length of the Tags array. It is protected by an
 * static assert in html.cc to prevent errors) */
#if ENABLE_SVG
#define HTML_NTAGS 91
#else
#define HTML_NTAGS 90
#endif

/*
 * Exported functions
 */
void a_Html_load_images(void *v_html, DilloUrl *pattern, bool_t user_saw_url, bool_t background);
void a_Html_add_bg_image(void *v_html, void *v_image, DilloUrl *url, DilloUrl *referrer, ReferrerPolicyType referrerpolicy);
void a_Html_form_submit(void *v_html, void *v_form);
void a_Html_form_reset(void *v_html, void *v_form);
void a_Html_form_display_hiddens(void *v_html, void *v_form, bool_t display);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __HTML_HH__ */
