#include <FL/Fl.H>

#include "menuinput.hh"
#include "uicmd.hh"

MenuInput::MenuInput (int x, int y, int w, int h, const char *l) :
   BaseInput(x,y,w,h,l)
{
   selecting = false;
}

/*
 * We are once again having to deal with our simulation of long press. It’s been generally good for the original widget to get releases so they don’t hang out in left-button-is-down state, but we have to throw away consequences. With Fl::pushed(0) inside dw/ where link presses/clicks/releases are sent over to html, FLTK would then just go around asking who would accept this event. The effect was that the menu wouldn’t have focus and the key events wouldn’t move between options.
 */
int MenuInput::handle(int e)
{
   if (e == FL_PUSH) {
      int b = Fl::event_button();

      if (b == FL_RIGHT_MOUSE) {
         selecting = false;
         a_UIcmd_input_popup(a_UIcmd_get_bw_by_widget(this), this);
         return 1;
      } else if (b == FL_LEFT_MOUSE) {
         selecting = true;
      }
   } else if (e == FL_RELEASE) {
      if (!selecting)
         mark(insert_position());
   } else if (e == FL_DRAG) {
      if (!selecting)
         return 1;
   }
   return (BaseInput::handle(e));
}

