#include <string.h>

#include <FL/fl_draw.H>

#include "msgbox.hh"

   /* If we have a message and anywhere to put it, demand the height we need. fl_measure uses references, which is a little unintuitive in that FLTK doesn’t do that so commonly.
    *
    * We don’t shrink the width any narrower than what is asked of us. I was trying that, and having problems. Maybe someday if it’s needed.
    */

MsgBox::MsgBox(int x, int y, int w, int h, const char *l) : Fl_Box(x,y,w,h,l)
{
   box(FL_FLAT_BOX);
   align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
}

void MsgBox::resize(int X, int Y, int W, int H)
{
   if (W && label() && label()[0]) {
      int msgw = W;

      fl_font(labelfont(), labelsize());
      fl_measure(label(), msgw, H, 0);
   } else {
      H = 0;
   }
   if (X != x() || Y != y() || W != w() || H != h())
      Fl_Box::resize(X, Y, W, H);
}

void MsgBox::message(const char *s)
{
   const char *l = label();

   // Enforce NULL for an empty string. As long as no one calls label() functions behind our backs.
   if (s && !*s)
      s = NULL;

   if ((!s && !l) || (s && l && !strcmp(s, l))) {
      // nothing changed
   } else {
      copy_label(s);
      resize(x(), y(), w(), h());
   }
}

/*
 * void Fl_Widget::draw_label() in fl_labeltype.cxx steals some of our pixels normally, but we need them all.
 */
void MsgBox::draw()
{
   draw_box();
   draw_label(x(), y(), w(), h(), align());
}

