#ifndef __MSGBOX_HH__
#define __MSGBOX_HH__

#include <FL/Fl_Box.H>

/*
 * A box that will take the height it needs to contain its message.
 *
 * The FLTK container widgets will not expect this on their own, so you will have to help them when necessary.
 *
 * For align(), I’m sure you will want FL_ALIGN_INSIDE. And it wouldn’t be very interesting without FL_ALIGN_WRAP.
 */

class MsgBox : public Fl_Box {
public:
   MsgBox(int x, int y, int w, int h, const char *l = 0);

   void resize(int X, int Y, int W, int H);
   void message(const char *s);
   void draw();
};

#endif // __MSGBOX_HH__
