#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Secret_Input.H>

#include "../dw/base_input.hh"

#include "passwordwindow.hh"
#include "prefs.h"

static void callback(Fl_Widget *wid)
{
   wid->window()->hide();
}

class PasswordWindow : public Fl_Window {
public:
   Fl_Box *msgbox;
   Fl_Secret_Input *password;
   PasswordWindow(int w, int h) : Fl_Window(w, h) {}
};

/*
 * NOTE This is used as the first window to get a proxy password. There is a comment in dillo.cc about needing window()->make_current() for old non-XFT windows for fl_text_extents() for start URLs. I take this to mean things could be weird because we are early, and that if things are weird, a make_current() might be good to try.
 */
char *a_Password_window(const char *title, const char *msg)
{
   if (!(title && *title))
      title = "Dillo: Password";

   // We are certain to have so much room. Let’s use some of it.
   FL_NORMAL_SIZE <<= 1;

   int password_h = FL_NORMAL_SIZE * 1.2;

   PasswordWindow *win = new PasswordWindow(prefs.width, prefs.height);
   win->box(FL_FLAT_BOX);
   win->Fl_Widget::copy_label(title);

   win->msgbox = new Fl_Box(0, 0, prefs.width, prefs.height - password_h);
   win->msgbox->copy_label(msg);

   win->msgbox->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
   win->add(win->msgbox);

   win->password = new Fl_Secret_Input(0, prefs.height - password_h, prefs.width, password_h);
   win->password->callback(callback);
   win->password->when(FL_WHEN_ENTER_KEY|FL_WHEN_NOT_CHANGED);
   win->add(win->password);

   win->resizable(win->msgbox);
   win->show();

   while (win->shown())
      Fl::wait();

   char *pw = dStrdup(win->password->value());
   delete win;

   FL_NORMAL_SIZE >>= 1;

   return pw;
}

