/*
 * Preferences
 *
 * Copyright (C) 2006-2009 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include "prefs.h"

#define PREFS_START_PAGE      "about:blank"
#define PREFS_FONT_SERIF      "DejaVu Serif"
#define PREFS_FONT_SANS_SERIF "DejaVu Sans"
#define PREFS_FONT_CURSIVE    "URW Chancery L"
#define PREFS_FONT_FANTASY    "DejaVu Sans" /* TODO: find good default */
#define PREFS_FONT_MONOSPACE  "DejaVu Sans Mono"
#define PREFS_SEARCH_URL      "dd POST@https://lite.duckduckgo.com/lite/?q=%s"
#define PREFS_NO_PROXY        "localhost,127.0.0.1"
#define PREFS_SAVE_DIR        "/tmp/"
#define PREFS_HTTP_LANGUAGE   "en-US,en;q=0.5"
#define PREFS_HTTP_REFERER    "host"
#define PREFS_HTTP_USER_AGENT "Dillo/" VERSION " (Mobile fork)"
#define PREFS_THEME           "none"
#define PREFS_TLS_MIN_VERSION "1.2"
#define PREFS_CONNECT_TIMEOUT 30

/*-----------------------------------------------------------------------------
 * Global Data
 *---------------------------------------------------------------------------*/
DilloPrefs prefs;

/*
 * Sets the default settings.
 */

void a_Prefs_init(void)
{
   prefs.adjust_min_width = TRUE;
   prefs.adjust_table_min_width = TRUE;
   prefs.allow_white_bg = TRUE;
   prefs.white_bg_replacement = 0xe0e0a3; // 0xdcd1ba;
   prefs.bg_color = 0xdcd1ba;
   prefs.connect_timeout = 30;
   prefs.contrast_visited_color = TRUE;
   prefs.default_text_size_pt = 8;
   prefs.dns_over_https_url = NULL;
   prefs.dpi = 0;
   prefs.drag_scrolling_button = 1;
   prefs.drag_threshold = 5;
   prefs.enterpress_forces_submit = FALSE;
   prefs.focus_new_tab = TRUE;
   prefs.font_cursive = dStrdup(PREFS_FONT_CURSIVE);
   prefs.font_fantasy = dStrdup(PREFS_FONT_FANTASY);
   prefs.font_max_size = 100;
   prefs.font_min_size = 6;
   prefs.font_monospace = dStrdup(PREFS_FONT_MONOSPACE);
   prefs.font_sans_serif = dStrdup(PREFS_FONT_SANS_SERIF);
   prefs.font_serif = dStrdup(PREFS_FONT_SERIF);

   /* these four constitute the geometry */
   prefs.width = PREFS_GEOMETRY_DEFAULT_WIDTH;
   prefs.height = PREFS_GEOMETRY_DEFAULT_HEIGHT;
   prefs.xpos = PREFS_GEOMETRY_DEFAULT_XPOS;
   prefs.ypos = PREFS_GEOMETRY_DEFAULT_YPOS;

   prefs.http_insecure = FALSE;
   prefs.http_language = dStrdup(PREFS_HTTP_LANGUAGE);
   prefs.http_proxy = NULL;
   prefs.http_max_conns = 6;
   prefs.http_proxyuser = NULL;
   prefs.http_referer = dStrdup(PREFS_HTTP_REFERER);
   prefs.http_user_agent = dStrdup(PREFS_HTTP_USER_AGENT);
   prefs.limit_text_width = TRUE;
   prefs.load_background_images=FALSE;
   prefs.load_images=TRUE;
   prefs.load_stylesheets=TRUE;
   prefs.long_press_length = 1.0;
   prefs.middle_click_opens_new_tab = TRUE;
   prefs.no_proxy = dStrdup(PREFS_NO_PROXY);
   prefs.parse_embedded_css=TRUE;
   prefs.save_dir = dStrdup(PREFS_SAVE_DIR);
   prefs.search_urls = dList_new(16);
   dList_append(prefs.search_urls, dStrdup(PREFS_SEARCH_URL));
   prefs.search_url_idx = 0;
   prefs.show_back = TRUE;
   prefs.show_bookmarks = FALSE;
   prefs.show_extra_warnings = FALSE;
   prefs.show_forw = TRUE;
   prefs.show_menubutton=TRUE;
   prefs.show_msg = TRUE;
   prefs.show_quit_dialog = TRUE;
   prefs.show_reload = FALSE;
   prefs.show_stop = TRUE;
   prefs.show_tooltip = FALSE;
   prefs.show_ui_tooltip = FALSE;
   prefs.start_page = dStrdup(PREFS_START_PAGE);
   prefs.theme = dStrdup(PREFS_THEME);
   prefs.tls_cipher_list = NULL;
   prefs.tls_min_version = dStrdup(PREFS_TLS_MIN_VERSION);
   prefs.ui_button_highlight_color = -1;
   prefs.ui_fg_color = -1;
   prefs.ui_insecure_color = -1;
   prefs.ui_left_handed = FALSE;
   prefs.ui_main_bg_color = -1;
   prefs.ui_min_button_h_mm = 5.0;
   prefs.ui_min_button_w_mm = 7.0;
   prefs.ui_selection_color = -1;
   prefs.ui_text_bg_color = -1;

   prefs.penalty_hyphen = 100;
   prefs.penalty_hyphen_2 = 800;
   prefs.penalty_em_dash_left = 800;
   prefs.penalty_em_dash_right = 100;
   prefs.penalty_em_dash_right_2 = 800;
   prefs.stretchability_factor = 100;
}

/*
 *  memory-deallocation
 *  (Call this one at exit time)
 */
void a_Prefs_freeall(void)
{
   int i;

   dFree(prefs.font_cursive);
   dFree(prefs.font_fantasy);
   dFree(prefs.font_monospace);
   dFree(prefs.font_sans_serif);
   dFree(prefs.font_serif);
   dFree(prefs.http_language);
   dFree(prefs.http_proxy);
   dFree(prefs.http_proxyuser);
   dFree(prefs.http_referer);
   dFree(prefs.http_user_agent);
   dFree(prefs.tls_min_version);
   dFree(prefs.tls_cipher_list);
   dFree(prefs.dns_over_https_url);
   dFree(prefs.no_proxy);
   dFree(prefs.save_dir);
   for (i = 0; i < dList_length(prefs.search_urls); ++i)
      dFree(dList_nth_data(prefs.search_urls, i));
   dList_free(prefs.search_urls);
   dFree(prefs.start_page);
   dFree(prefs.theme);
}
