#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>   // fl_font fl_measure

#include "buttons.hh"
#include "custgroup.hh"
#include "questionbar.hh"
#include "ui.hh"   // we’re part of the UI, so why go through UIcmd?

const int NOWRAP = 0;

/* This can be delicate because close_all comes through here for confirmation when there are multiple UIs. */

void Questionbar::yes_cb(Fl_Widget *btn, void *vq)
{
   BrowserWindow *bw = a_UIcmd_get_bw_by_widget(btn);
   Questionbar *q = (Questionbar *)vq;
   UIcmd_ask_cb *cb = q->Callback;
   void *data = q->Data;

   delete q;
   a_UIcmd_rearrange_UI(bw);

   cb(data);
}

void Questionbar::no_cb(Fl_Widget *btn, void *vq)
{
   BrowserWindow *bw = a_UIcmd_get_bw_by_widget(btn);
   Questionbar *q = (Questionbar *)vq;

   delete q;
   a_UIcmd_rearrange_UI(bw);
}

/* When we have the widths figured out thanks to CustGroupHorizontal::rearrange(), we need to figure out how tall to make the bar so there’s enough room in the box for the question. */
void Questionbar::determine_height()
{
   int h, w = QuestionBox->w();

   // This is an idiocy from Fl_Widget::draw_label(). There’s so much of this shit in FLTK—especially the oldest widgets—where Dillo must be the only FLTK program ever that has regularly needed to size things to contain things properly under various conditions?? And the later FLTK programmers can’t fix any of that nonsense because backward compatibility.
   if (w > 11 && QuestionBox->align()&(FL_ALIGN_LEFT|FL_ALIGN_RIGHT))
      w -= 6;

   // If we remember this one day and can think of nothing else to do (or this turns out to be a little bit off on occasion, derive a class from Fl_Box where the draw() calls draw_label() giving the full x y w h

   fl_font(QuestionBox->labelfont(), QuestionBox->labelsize());
   fl_measure(QuestionBox->label(), w, h, 0);
   size(this->w(), h);

   rearrange();
}

Questionbar::Questionbar(int width, int height, int min_button_w_px, const char *question, UIcmd_ask_cb cb, void *user_data) :
   CustGroupHorizontal(0, 0, width, height)
{
   int w, h;

   box(FL_NO_BOX);
   clear_visible_focus();

   Fl_Group::current(0);

   QuestionBox = new Fl_Box(0, 0, width, height);
   QuestionBox->box(FL_FLAT_BOX); // if changed to a box that uses box_dx, etc, then account for that in determine_height()
   QuestionBox->color(FL_FOREGROUND_COLOR);
   QuestionBox->labelcolor(FL_BACKGROUND_COLOR);
   QuestionBox->copy_label(question);
   QuestionBox->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);

    QuestionYes = new FocusAndEnterButton(0,0,min_button_w_px,height);
    QuestionYes->box(FL_FLAT_BOX);
    QuestionYes->callback(yes_cb, this);
    QuestionYes->label("Yes");
    QuestionYes->tooltip("");
    w = NOWRAP;
    QuestionYes->measure_label(w, h);
    w = MAX(w, min_button_w_px);
    QuestionYes->size(w, h);

    QuestionNo = new FocusAndEnterButton(0,0,min_button_w_px,height);
    QuestionNo->box(FL_FLAT_BOX);
    QuestionNo->callback(no_cb, this);
    QuestionNo->label("No");
    QuestionNo->tooltip("");
    w = NOWRAP;
    QuestionNo->measure_label(w, h);
    w = MAX(w, min_button_w_px);
    QuestionNo->size(w, h);

   Callback = cb;
   Data = user_data;

   add(QuestionBox);
   resizable(QuestionBox);
   add(QuestionYes);
   add(QuestionNo);
   QuestionYes->take_focus();
   rearrange(); // now the widths are set

   determine_height();
}

void Questionbar::resize(int x, int y, int w, int h)
{
   int oldW = this->w();

   CustGroupHorizontal::resize(x,y,w,h);

   if (oldW != this->w())
      determine_height();
}
