#ifndef __DILLO_REFERRER_H__
#define __DILLO_REFERRER_H__

#include "url.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef enum {
   REFERRER_POLICY_NOTSET,
   REFERRER_POLICY_NO_REFERRER,
   REFERRER_POLICY_NO_REFERRER_WHEN_DOWNGRADE,
   REFERRER_POLICY_ORIGIN,
   REFERRER_POLICY_ORIGIN_WHEN_CROSS_ORIGIN,
   REFERRER_POLICY_SAME_ORIGIN,
   REFERRER_POLICY_STRICT_ORIGIN,
   REFERRER_POLICY_STRICT_ORIGIN_WHEN_CROSS_ORIGIN,
   REFERRER_POLICY_UNSAFE_URL
} ReferrerPolicyType;

char *a_Referrer_make(ReferrerPolicyType p, const DilloUrl *destination, const DilloUrl *referring);

ReferrerPolicyType a_Referrer_read(const char *policy);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __DILLO_REFERRER_H__ */

