#ifndef __TABS_HH__
#define __TABS_HH__

#include "FL/Fl_Scroll.H"
#include "FL/Fl_Browser.H"
#include "FL/Fl_Wizard.H"
#include "FL/Fl_Text_Display.H"
#include "FL/Fl_Box.H"
#include "../dw/base_input.hh"
#include "custgroup.hh"
#include "msgbox.hh"
#include "bw.h"
#include "ui.hh"

#include "fetchreq.h"   // for linkmenu

class CustTabs;

class BrowserTab : public Fl_Browser {
protected:
   bool dragging, may_increase_text_size;
   int mouse_y;
   int item_height(void *item) const;
   int item_width(void *item) const;
   void textsize(int);
   int textsize() const;
   void item_draw(void* item, int X, int Y, int W, int H) const;
   void draw();
   BrowserWindow *bw;   // to satisfy a_UIcmd_open_url_nt
   char *make_label(const char *title, const DilloUrl *url);
   void back_to_UI();
   void bigger_if_theres_room();
public:
   BrowserTab (int ww, int wh);
   int handle(int e);
   void resize(int x, int y, int w, int h);
   void build(BrowserWindow *bw);
#if FL_API_VERSION < 10400
   // In 1.4, position() became vposition(), complete with compilation-filling deprecation warnings.
   int vposition() const { return position(); }
   void vposition(int pos) { position(pos); }
#endif
};

class TablistTab : public BrowserTab {
   CustTabs *tabs;
   void do_tablist_cb();
   static void tablist_cb(Fl_Widget *wid, void *);
public:
   TablistTab (int ww, int wh, CustTabs *tabs);
   void build(BrowserWindow *bw);
};

class LinkMenuTab : public BrowserTab {
   FetchReq *req;

   void do_linkmenu_cb();
   static void linkmenu_cb(Fl_Widget *wid, void *);
public:
   LinkMenuTab (int ww, int wh);
   ~LinkMenuTab ();
   int handle(int e);
   void build(BrowserWindow *bw, FetchReq *req, bool_t cached);
};

class ImageMenuTab : public BrowserTab {
   FetchReq *imgreq, *linkreq;
   DilloUrl *page_url;
   bool showing_link;

   void do_imagemenu_cb();
   void overlay_link_state();
   static void imagemenu_cb(Fl_Widget *wid, void *);
public:
   ImageMenuTab (int ww, int wh);
   ~ImageMenuTab ();
   int handle(int e);
   void build(BrowserWindow *bw, FetchReq *imgreq, FetchReq *linkreq, const DilloUrl *page_url, bool_t loaded, bool_t img_cached, bool_t link_cached);
};

class PageMenuTab : public BrowserTab {
   DilloUrl *url;

   void do_pagemenu_cb();
   static void pagemenu_cb(Fl_Widget *wid, void *);
public:
   PageMenuTab (int ww, int wh);
   ~PageMenuTab ();
   void build(BrowserWindow *bw, const DilloUrl *url, bool_t bugs);
};

class FormMenuTab : public BrowserTab {
   DilloUrl *url;
   void *vform;

   void do_formmenu_cb();
   static void formmenu_cb(Fl_Widget *wid, void *);
public:
   FormMenuTab (int ww, int wh);
   ~FormMenuTab ();
   void build(BrowserWindow *bw, const DilloUrl *url, void *vform, bool_t showing_hiddens);
};

class InputMenuTab : public BrowserTab {
   Fl_Widget_Tracker *tracker;
   void do_inputmenu_cb();
   static void inputmenu_cb(Fl_Widget *wid, void *);
public:
   InputMenuTab (int ww, int wh);
   ~InputMenuTab ();
   void build(BrowserWindow *bw, void *vinput);
};

class HistoryTab : public BrowserTab {
   bool navmode; // sigh
   void do_history_cb();
   static void history_cb(Fl_Widget *wid, void *);
public:
   HistoryTab (int ww, int wh);
   void build(BrowserWindow *bw);
   void populate_from_session();
   void populate_from_nav(BrowserWindow *bw);
};

class CommandsTab : public BrowserTab {
   void do_websearch_cb();
   static void websearch_cb(Fl_Widget *wid, void *);
   void websearch (BrowserWindow *bw);
   void do_commands_cb();
   static void commands_cb(Fl_Widget *wid, void *);
public:
   CommandsTab (int ww, int wh);
   void build(BrowserWindow *bw);
};

class DisplayTab : public Fl_Group {
   BrowserWindow *bw;
   Fl_Text_Buffer *buffer;
   Fl_Text_Display *display;
   Fl_Button *close;
public:
   DisplayTab (int ww, int wh);
   ~DisplayTab ();
   int handle(int e);
   void build(BrowserWindow *bw, const char *title, const char *contents);
};

/* Save (and Select) */
class SavefileTab : public CustGroupVertical {
   BaseInput *input;
   Fl_Group *buttons;
   Fl_Button *cancel, *overwrite, *ok;
   MsgBox *msgbox;
   Fl_Browser *filebrowser;

   bool OUR_JOB_IS_TO_SAVE;

   BrowserWindow *bw;
   DilloUrl *url;
   Dstr *filename;

   void message(const char *msg);
   void show_matching_filenames();
   void consider_saving();
   void consider_selecting();
   static void input_cb(Fl_Widget *wid, void *vself);
   void do_input_cb();
   void do_cancel_cb(Fl_Widget *wid);
   static void cancel_cb(Fl_Widget *wid, void *vself);
   void do_overwrite_cb(Fl_Widget *wid);
   static void overwrite_cb(Fl_Widget *wid, void *vself);
   void do_ok_cb(Fl_Widget *wid);
   static void ok_cb(Fl_Widget *wid, void *vself);
   void do_filebrowser_cb(Fl_Widget *wid);
   static void filebrowser_cb(Fl_Widget *wid, void *vself);
   void back_to_UI();
public:
   SavefileTab (int ww, int wh);
   int handle(int e);
   void buildSave(int ww, int wh, const DilloUrl *url, BrowserWindow *bw);
   void buildSelect(int ww, int wh, BrowserWindow *bw, Dstr *filename);
};

class CustTabs : public Fl_Wizard {
  friend void TablistTab::build (BrowserWindow *bw);

   const int non_UI_tabs = 1;
   enum {tablist_tab_idx, history_tab_idx, savefile_tab_idx, display_tab_idx, commands_tab_idx};
   void use_nonUI_tab(Fl_Widget *tab);
public:
   CustTabs (int ww, int wh, const char *lbl=0);
   int handle(int e);
   UI *add_new_tab(Fl_Widget *main, int focus);
   void remove_tab(UI *ui);
   void value(Fl_Widget *wid);
   int num_UIs() { return children() - non_UI_tabs; }
   Fl_Widget *value() {return Fl_Wizard::value();};
   void prev_tab(void);
   void next_tab(void);
   void switch_tab(Fl_Widget *child);
   void show_tablist(BrowserWindow *bw);
   void show_linkmenu(BrowserWindow *bw, FetchReq *req, bool_t cached);
   void show_imagemenu(BrowserWindow *bw, FetchReq *imgreq, FetchReq *linkreq, const DilloUrl *page_url, bool_t loaded, bool_t img_cached, bool_t link_cached);
   void show_pagemenu(BrowserWindow *bw, const DilloUrl *url, bool_t bugs);
   void show_formmenu(BrowserWindow *bw, const DilloUrl *url, void *vform, bool_t showing_hiddens);
   void show_inputmenu(BrowserWindow *bw, void *vinput);
   void show_session_history(BrowserWindow *bw);
   void show_nav_history(BrowserWindow *bw);
   void show_savefile(const DilloUrl *url, BrowserWindow *bw);
   void show_selectfile(BrowserWindow *bw, Dstr *filename);
   void show_display(BrowserWindow *bw, const char *title, const char *contents);
   void show_commands(BrowserWindow *bw);
};

#endif // __TABS_HH__
