#ifndef __UI_HH__
#define __UI_HH__

// UI for dillo --------------------------------------------------------------

#include "menuinput.hh"
#include <FL/Fl_Window.H>
#include <FL/Fl_Widget.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Secret_Input.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Tabs.H>

#include "tipwin.hh"
#include "custgroup.hh"
#include "url.h"

typedef enum {
   UI_BACK = 0,
   UI_FORW,
   UI_STOP,
   UI_RELOAD,
   UI_BOOKMARKS,
   UI_CLOSE,
   UI_TABS,
} UIButton;

// Private classes
class CustTabs;

//
// UI class definition -------------------------------------------------------
//
class UI : public CustGroupVertical {
   CustTabs *Tabs;

   CustGroupVertical *TopGroup;
   CustButton *Back, *Forw, *Reload, *Bookmarks, *Stop, *Close, *TabButton, *MenuButton, *StatusClose;
   CustGroupHorizontal *LocBar, *NavBar, *StatusBar;
   MenuInput *Location;

   Fl_Widget *Main;
   Fl_Group *Panel, *LocationGroup;
   Fl_Box *StatusOutput;
   Fl_Group *FindBar;

   // Panel customization variables
   int p_xpos, bw, bh, lh, nh, fh, sh;
   int min_button_w_px, min_button_h_px;

   CustButton *make_button(const char *label, const char *tooltip, int b_n);
   void make_location(int ww);
   void make_menu_button();
   void make_panel(int ww);

   void make_question_bar(int ww, int wh);
   void make_status_bar(int ww, int wh);
   void determine_status_height();
   static void status_close_cb(Fl_Widget *wid, void *data);

public:

   UI(int x,int y,int w,int h, Fl_Widget *main);
   ~UI();

   int handle(int event);
   void resize(int x, int y, int w, int h);
   void rearrange();

   const char *get_location();
   void set_location(const char *str);
   void focus_location();
   void check_location_fit();
   void focus_main();
   void set_status(const char *str);
   void customize();
   void button_set_sens(UIButton btn, int sens);
   void paste(bool clipboard);
   void findbar_toggle(bool add);
   void username_password(const char *msg, void (*callback)(bool_t, const char *, const char *, void *) , void *data);
   void ask_user(const char *question, void (*callback)(void *), void *data);
   void ask_name_password(const char *prompt, void (*callback)(void *, void*), void *data);
   void update_location_color();
   void update_tab_count(int n);
   void update_nav_button_order();

   CustTabs *tabs() { return Tabs; }
   void tabs(CustTabs *tabs) { Tabs = tabs; }
};

#endif // __UI_HH__
