#ifndef __UICMD_HH__
#define __UICMD_HH__

#include "bw.h"
#include "fetchreq.h"

typedef enum {
   UICMD_LOC_HERE,
   UICMD_LOC_NEW_WINDOW,
   UICMD_LOC_NEW_TAB,
   UICMD_LOC_NEW_TAB_FOCUSED,
   UICMD_LOC_FROM_EVENT_STATE    // Dillo has a standard pattern for where to open when something is clicked
} UIcmd_location;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

BrowserWindow *a_UIcmd_browser_window_new(int x, int y, int ww, int wh);
BrowserWindow *a_UIcmd_get_bw_by_widget(void *v_wid);
void a_UIcmd_send_event_to_tabs_by_wid(int e, void *v_wid);
void a_UIcmd_open_location_urlstr(void *vbw, const char *urlstr);
void a_UIcmd_open_url(BrowserWindow *bw, UIcmd_location loc, FetchReq *req);
void a_UIcmd_select_tab(void *vbw);
void a_UIcmd_back(void *vbw);
void a_UIcmd_forw(void *vbw);
void a_UIcmd_reload(void *vbw);
void a_UIcmd_repush(void *vbw);
void a_UIcmd_save(void *vbw);
void a_UIcmd_stop(void *vbw);
void a_UIcmd_save_link(BrowserWindow *bw, const DilloUrl *url);
void a_UIcmd_open_file(void *vbw);
void a_UIcmd_select_file(BrowserWindow *bw, Dstr *filename);
void a_UIcmd_websearch(BrowserWindow *bw, const char *item);
char *a_UIcmd_get_passwd(const char *username);
void a_UIcmd_session_history(void *vbw);
void a_UIcmd_nav_history(void *vbw);
void a_UIcmd_book(void *vbw);
void a_UIcmd_add_bookmark(BrowserWindow *bw, const DilloUrl *url);
void a_UIcmd_findtext_dialog(BrowserWindow *bw);
void a_UIcmd_findtext_search(BrowserWindow *bw,const char *key,int case_sens,
                             int backwards);
void a_UIcmd_findtext_reset(BrowserWindow *bw);
void a_UIcmd_findbar_toggle(BrowserWindow *bw, int on);

typedef void (UIcmd_username_password_cb)(bool_t ok, const char *user, const char *password, void *data);
void a_UIcmd_username_password(void *vbw, const char *msg, UIcmd_username_password_cb callback, void *data);

/* for now, the callback only needs to be called if the user says Yes. */
typedef void (UIcmd_ask_cb)(void* data);
void a_UIcmd_ask_user(BrowserWindow *bw, const char *question, UIcmd_ask_cb callback, void *data);

void a_UIcmd_rearrange_UI(BrowserWindow *bw);
void a_UIcmd_focus_main_area(BrowserWindow *bw);
void a_UIcmd_focus_location(void *vbw);
void a_UIcmd_update_location_color();
void a_UIcmd_update_handedness();
void a_UIcmd_page_popup(void *vbw, void *v_ToplevelStylesheets, void *v_ImportStylesheets);
void a_UIcmd_link_popup(BrowserWindow *bw, FetchReq *req, bool_t cached);
void a_UIcmd_image_popup(BrowserWindow *bw, FetchReq *imgreq,
                         FetchReq *linkreq, const DilloUrl *page_url, bool_t loaded_img, bool_t img_cached, bool_t link_cached);
void a_UIcmd_form_popup(BrowserWindow *bw, const DilloUrl *url, void *vform,
                        bool_t showing_hiddens);
void a_UIcmd_input_popup(BrowserWindow *bw, void *input);
void a_UIcmd_commands_tab(BrowserWindow *bw);
bool_t a_UIcmd_get_selection_mode(BrowserWindow *bw);
void a_UIcmd_set_selection_mode(BrowserWindow *bw, bool_t v);
void a_UIcmd_copy_urlstr(BrowserWindow *bw, const char *urlstr);
void a_UIcmd_view_page_source(BrowserWindow *bw, const DilloUrl *url);
void a_UIcmd_larger();
void a_UIcmd_smaller();
void a_UIcmd_view_page_bugs(void *vbw);
void a_UIcmd_tab_list(BrowserWindow *bw);
int *a_UIcmd_get_history(BrowserWindow *bw);
void a_UIcmd_nav_jump(BrowserWindow *bw, int index);
void a_UIcmd_authenticated(const DilloUrl *url);

void a_UIcmd_close_bw(void *vbw);
void a_UIcmd_close_all_bw(void *vbw);

void a_UIcmd_init(void);


// UI binding functions -------------------------------------------------------

void a_UIcmd_get_wh(BrowserWindow *bw, int *w, int *h);
void a_UIcmd_get_scroll_xy(BrowserWindow *bw, int *x, int *y);
void a_UIcmd_set_scroll_xy(BrowserWindow *bw, int x, int y);
void a_UIcmd_set_scroll_by_fragment(BrowserWindow *bw, const char *f);
void a_UIcmd_scroll(BrowserWindow *bw, int icmd);
char *a_UIcmd_get_location_text(BrowserWindow *bw);
void a_UIcmd_set_location_text(void *vbw, const char *text);
void a_UIcmd_set_page_prog(BrowserWindow *bw, size_t nbytes, double proportion, uint_t bugs, uint_t cookies);
void a_UIcmd_set_page_title(BrowserWindow *bw, const char *label);
void a_UIcmd_display_link_dest(BrowserWindow *bw, const char *str);
void a_UIcmd_set_msg(BrowserWindow *bw, const char *format, ...);
void a_UIcmd_set_buttons_sens(BrowserWindow *bw);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __UICMD_HH__
