#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>   // fl_font fl_measure

#include "buttons.hh"
#include "custgroup.hh"
#include "usernamepasswordbar.hh"
#include "ui.hh"   // we’re part of the UI, so why go through UIcmd?

void UsernamePasswordBar::button_cb(Fl_Widget *btn, void *vu)
{
   BrowserWindow *bw = a_UIcmd_get_bw_by_widget(btn);
   UsernamePasswordBar *u = (UsernamePasswordBar *)vu;

   bool_t ok = btn == u->OK;

   u->Callback(ok, ok ? u->Username->value() : NULL, ok ? u->Password->value() : NULL, u->Data);

   delete u;
   a_UIcmd_rearrange_UI(bw);
}

void UsernamePasswordBar::callback(UIcmd_username_password_cb cb, void *user_data)
{
   Callback = cb;
   Data = user_data;
   activate();
}

UsernamePasswordBar::UsernamePasswordBar(int width, int height, const char *msg) :
   CustGroupVertical(0, 0, width, height)
{
   int y, w = width, h;

   Callback = NULL;
   Data = NULL;
   deactivate(); // won’t work until you call callback().

   box(FL_NO_BOX);
   clear_visible_focus();

   Fl_Group::current(0);

   MsgBox = new Fl_Box(0, 0, width, height);
   MsgBox->box(FL_FLAT_BOX); // if changed to a box that uses box_dx, etc, then account for that in determine_height()
   MsgBox->color(FL_FOREGROUND_COLOR);
   MsgBox->labelcolor(FL_BACKGROUND_COLOR);
   MsgBox->copy_label(msg);
   MsgBox->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);

   fl_font(MsgBox->labelfont(), MsgBox->labelsize());
   fl_measure(MsgBox->label(), w, h, 0);
   MsgBox->size(w, h);

   y = h;

   Username = new PlaceholderInput(0, y, width, FL_NORMAL_SIZE * 1.4, "");
   Username->set_placeholder("username");

   y += Username->h();

   Password = new PlaceholderInput(0, y, width, FL_NORMAL_SIZE * 1.4, "");
   Password->input_type(FL_SECRET_INPUT);
   Password->set_placeholder("password");

   y += Password->h();

   /* A plain Fl_Group for ButtonGroup didn’t work at all. I’m so accustomed to CustGroup*  */
   ButtonGroup = new CustGroupHorizontal(0, y, width, FL_NORMAL_SIZE);

   OK = new FocusAndEnterButton(0,0, width/2,FL_NORMAL_SIZE, "OK");
   OK->box(FL_FLAT_BOX);
   OK->callback(button_cb, this);
   ButtonGroup->add(OK);

   Dismiss = new FocusAndEnterButton(OK->w(), 0, width - OK->w(), FL_NORMAL_SIZE, "Dismiss");
   Dismiss->box(FL_FLAT_BOX);
   Dismiss->callback(button_cb, this);
   ButtonGroup->add(Dismiss);

   y += ButtonGroup->h();

   add(MsgBox);
   add(Username);
   add(Password);
   add(ButtonGroup);
   size(this->w(), y);
   rearrange();
}

void UsernamePasswordBar::resize(int x, int y, int w, int h)
{
   int oldW = this->w(),
       oldMsgBoxH = MsgBox->h();

   CustGroupVertical::resize(x,y,w,h);

   if (oldW != this->w()) {
      int msgBoxW = w, msgBoxH;

      fl_font(MsgBox->labelfont(), MsgBox->labelsize());
      fl_measure(MsgBox->label(), msgBoxW, msgBoxH, 0);
      MsgBox->size(w, msgBoxH);
      OK->size(w / 2, OK->h());
      Dismiss->size(w - OK->w(), Dismiss->h());
      if (msgBoxH != oldMsgBoxH)
         size(w, h + msgBoxH - oldMsgBoxH);
      rearrange();
   }
}
